/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.v1;

import java.io.File;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import org.neo4j.driver.internal.cluster.RoutingSettings;
import org.neo4j.driver.internal.logging.JULogging;
import org.neo4j.driver.internal.retry.RetrySettings;
import org.neo4j.driver.v1.Logging;
import org.neo4j.driver.v1.util.Immutable;

@Immutable
public class Config {
    private final Logging logging;
    private final boolean logLeakedSessions;
    private final int maxIdleConnectionPoolSize;
    private final long idleTimeBeforeConnectionTest;
    private final boolean encrypted;
    private final TrustStrategy trustStrategy;
    private final int routingFailureLimit;
    private final long routingRetryDelayMillis;
    private final int connectionTimeoutMillis;
    private final RetrySettings retrySettings;

    private Config(ConfigBuilder builder) {
        this.logging = builder.logging;
        this.logLeakedSessions = builder.logLeakedSessions;
        this.idleTimeBeforeConnectionTest = builder.idleTimeBeforeConnectionTest;
        this.maxIdleConnectionPoolSize = builder.maxIdleConnectionPoolSize;
        this.encrypted = builder.encrypted;
        this.trustStrategy = builder.trustStrategy;
        this.routingFailureLimit = builder.routingFailureLimit;
        this.routingRetryDelayMillis = builder.routingRetryDelayMillis;
        this.connectionTimeoutMillis = builder.connectionTimeoutMillis;
        this.retrySettings = builder.retrySettings;
    }

    public Logging logging() {
        return this.logging;
    }

    public boolean logLeakedSessions() {
        return this.logLeakedSessions;
    }

    @Deprecated
    public int connectionPoolSize() {
        return this.maxIdleConnectionPoolSize;
    }

    public int maxIdleConnectionPoolSize() {
        return this.maxIdleConnectionPoolSize;
    }

    public long idleTimeBeforeConnectionTest() {
        return this.idleTimeBeforeConnectionTest;
    }

    public int connectionTimeoutMillis() {
        return this.connectionTimeoutMillis;
    }

    @Deprecated
    public EncryptionLevel encryptionLevel() {
        return this.encrypted ? EncryptionLevel.REQUIRED : EncryptionLevel.NONE;
    }

    public boolean encrypted() {
        return this.encrypted;
    }

    public TrustStrategy trustStrategy() {
        return this.trustStrategy;
    }

    public static ConfigBuilder build() {
        return new ConfigBuilder();
    }

    public static Config defaultConfig() {
        return Config.build().toConfig();
    }

    RoutingSettings routingSettings() {
        return new RoutingSettings(this.routingFailureLimit, this.routingRetryDelayMillis);
    }

    RetrySettings retrySettings() {
        return this.retrySettings;
    }

    public static class TrustStrategy {
        private final Strategy strategy;
        private final File certFile;

        private TrustStrategy(Strategy strategy) {
            this(strategy, null);
        }

        private TrustStrategy(Strategy strategy, File certFile) {
            this.strategy = strategy;
            this.certFile = certFile;
        }

        public Strategy strategy() {
            return this.strategy;
        }

        public File certFile() {
            return this.certFile;
        }

        @Deprecated
        public static TrustStrategy trustSignedBy(File certFile) {
            return new TrustStrategy(Strategy.TRUST_SIGNED_CERTIFICATES, certFile);
        }

        public static TrustStrategy trustCustomCertificateSignedBy(File certFile) {
            return new TrustStrategy(Strategy.TRUST_CUSTOM_CA_SIGNED_CERTIFICATES, certFile);
        }

        public static TrustStrategy trustSystemCertificates() {
            return new TrustStrategy(Strategy.TRUST_SYSTEM_CA_SIGNED_CERTIFICATES);
        }

        public static TrustStrategy trustAllCertificates() {
            return new TrustStrategy(Strategy.TRUST_ALL_CERTIFICATES);
        }

        @Deprecated
        public static TrustStrategy trustOnFirstUse(File knownHostsFile) {
            return new TrustStrategy(Strategy.TRUST_ON_FIRST_USE, knownHostsFile);
        }

        public static enum Strategy {
            TRUST_ON_FIRST_USE,
            TRUST_SIGNED_CERTIFICATES,
            TRUST_ALL_CERTIFICATES,
            TRUST_CUSTOM_CA_SIGNED_CERTIFICATES,
            TRUST_SYSTEM_CA_SIGNED_CERTIFICATES;

        }
    }

    public static enum EncryptionLevel {
        NONE,
        REQUIRED;

    }

    public static class ConfigBuilder {
        private Logging logging = new JULogging(Level.INFO);
        private boolean logLeakedSessions;
        private int maxIdleConnectionPoolSize = 10;
        private long idleTimeBeforeConnectionTest = -1L;
        private boolean encrypted = true;
        private TrustStrategy trustStrategy = TrustStrategy.trustAllCertificates();
        private int routingFailureLimit = 1;
        private long routingRetryDelayMillis = TimeUnit.SECONDS.toMillis(5L);
        private int connectionTimeoutMillis = (int)TimeUnit.SECONDS.toMillis(5L);
        private RetrySettings retrySettings = RetrySettings.DEFAULT;

        private ConfigBuilder() {
        }

        public ConfigBuilder withLogging(Logging logging) {
            this.logging = logging;
            return this;
        }

        public ConfigBuilder withLeakedSessionsLogging() {
            this.logLeakedSessions = true;
            return this;
        }

        @Deprecated
        public ConfigBuilder withMaxSessions(int size) {
            return this;
        }

        public ConfigBuilder withMaxIdleSessions(int size) {
            this.maxIdleConnectionPoolSize = size;
            return this;
        }

        @Deprecated
        public ConfigBuilder withSessionLivenessCheckTimeout(long timeout) {
            this.withConnectionLivenessCheckTimeout(timeout, TimeUnit.MILLISECONDS);
            return this;
        }

        public ConfigBuilder withConnectionLivenessCheckTimeout(long value, TimeUnit unit) {
            this.idleTimeBeforeConnectionTest = unit.toMillis(value);
            return this;
        }

        @Deprecated
        public ConfigBuilder withEncryptionLevel(EncryptionLevel level) {
            this.encrypted = level == EncryptionLevel.REQUIRED;
            return this;
        }

        public ConfigBuilder withEncryption() {
            this.encrypted = true;
            return this;
        }

        public ConfigBuilder withoutEncryption() {
            this.encrypted = false;
            return this;
        }

        public ConfigBuilder withTrustStrategy(TrustStrategy trustStrategy) {
            this.trustStrategy = trustStrategy;
            return this;
        }

        @Deprecated
        public ConfigBuilder withRoutingFailureLimit(int routingFailureLimit) {
            if (routingFailureLimit < 1) {
                throw new IllegalArgumentException("The failure limit may not be smaller than 1, but was: " + routingFailureLimit);
            }
            this.routingFailureLimit = routingFailureLimit;
            return this;
        }

        @Deprecated
        public ConfigBuilder withRoutingRetryDelay(long delay, TimeUnit unit) {
            long routingRetryDelayMillis = unit.toMillis(delay);
            if (routingRetryDelayMillis < 0L) {
                throw new IllegalArgumentException(String.format("The retry delay may not be smaller than 0, but was %d %s.", new Object[]{delay, unit}));
            }
            this.routingRetryDelayMillis = routingRetryDelayMillis;
            return this;
        }

        public ConfigBuilder withConnectionTimeout(long value, TimeUnit unit) {
            long connectionTimeoutMillis = unit.toMillis(value);
            if (connectionTimeoutMillis < 0L) {
                throw new IllegalArgumentException(String.format("The connection timeout may not be smaller than 0, but was %d %s.", new Object[]{value, unit}));
            }
            int connectionTimeoutMillisInt = (int)connectionTimeoutMillis;
            if ((long)connectionTimeoutMillisInt != connectionTimeoutMillis) {
                throw new IllegalArgumentException(String.format("The connection timeout must represent int value when converted to milliseconds %d.", connectionTimeoutMillis));
            }
            this.connectionTimeoutMillis = connectionTimeoutMillisInt;
            return this;
        }

        public ConfigBuilder withMaxTransactionRetryTime(long value, TimeUnit unit) {
            long maxRetryTimeMs = unit.toMillis(value);
            if (maxRetryTimeMs < 0L) {
                throw new IllegalArgumentException(String.format("The max retry time may not be smaller than 0, but was %d %s.", new Object[]{value, unit}));
            }
            this.retrySettings = new RetrySettings(maxRetryTimeMs);
            return this;
        }

        public Config toConfig() {
            return new Config(this);
        }
    }
}

