/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.Term;
import org.apache.lucene.queryparser.classic.MultiFieldQueryParser;
import org.apache.lucene.queryparser.classic.ParseException;
import org.apache.lucene.queryparser.classic.QueryParser;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;

public class OLuceneIndexType {
    public static Field createField(String fieldName, Object value, Field.Store store) {
        if (value instanceof Number) {
            Number number = (Number)value;
            if (value instanceof Long) {
                return new LongField(fieldName, number.longValue(), store);
            }
            if (value instanceof Float) {
                return new FloatField(fieldName, number.floatValue(), store);
            }
            if (value instanceof Double) {
                return new DoubleField(fieldName, number.doubleValue(), store);
            }
            return new IntField(fieldName, number.intValue(), store);
        }
        if (value instanceof Date) {
            return new LongField(fieldName, ((Date)value).getTime(), store);
        }
        if (fieldName.equalsIgnoreCase("RID")) {
            StringField ridField = new StringField(fieldName, value.toString(), store);
            return ridField;
        }
        if (fieldName.startsWith("_")) {
            StringField ridField = new StringField(fieldName, value.toString(), store);
            return ridField;
        }
        return new TextField(fieldName, value.toString(), store);
    }

    public static Query createExactQuery(OIndexDefinition index, Object key) {
        BooleanQuery query = null;
        if (key instanceof String) {
            BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
            if (index.getFields().size() > 0) {
                for (String idx : index.getFields()) {
                    queryBuilder.add((Query)new TermQuery(new Term(idx, key.toString())), BooleanClause.Occur.SHOULD);
                }
            } else {
                queryBuilder.add((Query)new TermQuery(new Term("KEY", key.toString())), BooleanClause.Occur.SHOULD);
            }
            query = queryBuilder.build();
        } else if (key instanceof OCompositeKey) {
            BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
            int i = 0;
            OCompositeKey keys = (OCompositeKey)key;
            for (String idx : index.getFields()) {
                String val = (String)keys.getKeys().get(i);
                queryBuilder.add((Query)new TermQuery(new Term(idx, val)), BooleanClause.Occur.MUST);
                ++i;
            }
            query = queryBuilder.build();
        }
        return query;
    }

    public static Query createDeleteQuery(OIdentifiable value, List<String> fields, Object key) {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add(OLuceneIndexType.createQueryId(value), BooleanClause.Occur.MUST);
        HashMap<String, String> values = new HashMap<String, String>();
        if (!(key instanceof OCompositeKey)) {
            values.put(fields.iterator().next(), key.toString());
        }
        for (String s : values.keySet()) {
            queryBuilder.add((Query)new TermQuery(new Term(s, ((String)values.get(s)).toLowerCase(Locale.ENGLISH))), BooleanClause.Occur.MUST);
        }
        return queryBuilder.build();
    }

    public static Query createQueryId(OIdentifiable value) {
        return new TermQuery(new Term("RID", value.getIdentity().toString()));
    }

    public static Query createFullQuery(OIndexDefinition index, Object key, Analyzer analyzer) throws ParseException {
        String query = "";
        if (key instanceof OCompositeKey) {
            Object params = ((OCompositeKey)key).getKeys().get(0);
            if (params instanceof Map) {
                Object q = ((Map)params).get("q");
                if (q != null) {
                    query = q.toString();
                }
            } else {
                query = params.toString();
            }
        } else {
            query = key.toString();
        }
        return OLuceneIndexType.getQueryParser(index, query, analyzer);
    }

    protected static Query getQueryParser(OIndexDefinition index, String key, Analyzer analyzer) throws ParseException {
        QueryParser queryParser;
        if (key.startsWith("(")) {
            queryParser = new QueryParser("", analyzer);
        } else {
            String[] fields = null;
            if (index.isAutomatic()) {
                fields = index.getFields().toArray(new String[index.getFields().size()]);
            } else {
                int length = index.getTypes().length;
                fields = new String[length];
                for (int i = 0; i < length; ++i) {
                    fields[i] = "k" + i;
                }
            }
            queryParser = new MultiFieldQueryParser(fields, analyzer);
        }
        return queryParser.parse(key);
    }

    public static Sort sort(Query query, OIndexDefinition index, boolean ascSortOrder) {
        String key = (String)index.getFields().iterator().next();
        Number number = ((NumericRangeQuery)query).getMin();
        number = number != null ? (Number)number : (Number)((NumericRangeQuery)query).getMax();
        SortField.Type fieldType = SortField.Type.INT;
        if (number instanceof Long) {
            fieldType = SortField.Type.LONG;
        } else if (number instanceof Float) {
            fieldType = SortField.Type.FLOAT;
        } else if (number instanceof Double) {
            fieldType = SortField.Type.DOUBLE;
        }
        return new Sort(new SortField(key, fieldType, ascSortOrder));
    }
}

