/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.collections;

import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.collections.OLuceneAbstractResultSet;
import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.engine.OLuceneIndexEngineAbstract;
import com.orientechnologies.lucene.query.OLuceneQueryContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import java.io.IOException;
import java.util.Iterator;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;

public class OLuceneResultSet
extends OLuceneAbstractResultSet {
    public OLuceneResultSet(OLuceneIndexEngine engine, OLuceneQueryContext queryContext) {
        super(engine, queryContext);
    }

    @Override
    public int size() {
        return this.topDocs.totalHits;
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return new OLuceneResultSetIterator();
    }

    private class OLuceneResultSetIterator
    implements Iterator<OIdentifiable> {
        private ScoreDoc[] array;
        private int index;
        private int localIndex;
        private int totalHits;

        public OLuceneResultSetIterator() {
            this.totalHits = OLuceneResultSet.this.topDocs.totalHits;
            this.index = 0;
            this.localIndex = 0;
            this.array = OLuceneResultSet.this.topDocs.scoreDocs;
            OLuceneIndexEngineAbstract.sendTotalHits(OLuceneResultSet.this.indexName, OLuceneResultSet.this.queryContext.context, OLuceneResultSet.this.topDocs.totalHits);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.totalHits;
        }

        @Override
        public OIdentifiable next() {
            if (this.localIndex == this.array.length) {
                this.localIndex = 0;
                this.fetchMoreResult();
            }
            ScoreDoc score = this.array[this.localIndex++];
            Document ret = null;
            OContextualRecordId res = null;
            try {
                ret = OLuceneResultSet.this.queryContext.getSearcher().doc(score.doc);
                String rId = ret.get("RID");
                res = new OContextualRecordId(rId);
                OLuceneResultSet.this.engine.onRecordAddedToResultSet(OLuceneResultSet.this.queryContext, res, ret, score);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            ++this.index;
            return res;
        }

        private void fetchMoreResult() {
            TopDocs topDocs = null;
            try {
                switch (OLuceneResultSet.this.queryContext.cfg) {
                    case NO_FILTER_NO_SORT: {
                        topDocs = OLuceneResultSet.this.queryContext.getSearcher().searchAfter(this.array[this.array.length - 1], OLuceneResultSet.this.query, OLuceneResultSet.this.pageSize.intValue());
                        break;
                    }
                    case FILTER_SORT: {
                        topDocs = OLuceneResultSet.this.queryContext.getSearcher().searchAfter(this.array[this.array.length - 1], OLuceneResultSet.this.query, OLuceneResultSet.this.queryContext.filter, OLuceneResultSet.this.pageSize.intValue(), OLuceneResultSet.this.queryContext.sort);
                        break;
                    }
                    case FILTER: {
                        topDocs = OLuceneResultSet.this.queryContext.getSearcher().searchAfter(this.array[this.array.length - 1], OLuceneResultSet.this.query, OLuceneResultSet.this.queryContext.filter, OLuceneResultSet.this.pageSize.intValue());
                        break;
                    }
                    case SORT: {
                        topDocs = OLuceneResultSet.this.queryContext.getSearcher().searchAfter(this.array[this.array.length - 1], OLuceneResultSet.this.query, OLuceneResultSet.this.pageSize.intValue(), OLuceneResultSet.this.queryContext.sort);
                    }
                }
                this.array = topDocs.scoreDocs;
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on fetching document by query '%s' to Lucene index", (Throwable)e, new Object[]{OLuceneResultSet.this.query});
            }
        }

        @Override
        public void remove() {
        }
    }
}

