/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.index;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.lucene.OLuceneIndex;
import com.orientechnologies.lucene.OLuceneTxOperations;
import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexCursor;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import com.orientechnologies.orient.core.index.OIndexEngine;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.OIndexEngineCallback;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;

public class OLuceneIndexNotUnique
extends OIndexAbstract<Set<OIdentifiable>>
implements OLuceneIndex {
    public OLuceneIndexNotUnique(String name, String typeId, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata) {
        super(name, typeId, algorithm, valueContainerAlgorithm, metadata, version, (OStorage)storage);
    }

    public long rebuild(OProgressListener iProgressListener) {
        return super.rebuild(iProgressListener);
    }

    public boolean remove(final Object key, final OIdentifiable value) {
        if (key != null) {
            OTransaction transaction = this.getDatabase().getTransaction();
            if (transaction.isActive()) {
                transaction.addIndexEntry((OIndex)this, super.getName(), OTransactionIndexChanges.OPERATION.REMOVE, this.encodeKey(key), value);
                OLuceneTxChanges transactionChanges = this.getTransactionChanges(transaction);
                try {
                    transactionChanges.remove(key, value);
                }
                catch (IOException e) {
                    OLogManager.instance().error((Object)this, "Error while removing", (Throwable)e, new Object[0]);
                }
                return true;
            }
            while (true) {
                try {
                    return (Boolean)this.storage.callIndexEngine(false, false, this.indexId, (OIndexEngineCallback)new OIndexEngineCallback<Boolean>(){

                        public Boolean callEngine(OIndexEngine engine) {
                            OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                            return indexEngine.remove(key, value);
                        }
                    });
                }
                catch (OInvalidIndexEngineIdException e) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
        }
        return true;
    }

    public boolean remove(Object key) {
        return super.remove(key);
    }

    protected OBinarySerializer determineValueSerializer() {
        return this.storage.getComponentsFactory().binarySerializerFactory.getObjectSerializer((byte)21);
    }

    protected Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> interpretTxKeyChanges(OTransactionIndexChangesPerKey changes) {
        return changes.interpret(OTransactionIndexChangesPerKey.Interpretation.NonUnique);
    }

    public Object getCollatingValue(Object key) {
        return key;
    }

    protected void commitSnapshot(final Map<Object, Object> snapshot) {
        while (true) {
            try {
                this.storage.callIndexEngine(false, false, this.indexId, (OIndexEngineCallback)new OIndexEngineCallback<Object>(){

                    public Boolean callEngine(OIndexEngine engine) {
                        OLuceneTxOperations operations;
                        Object key;
                        OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                        for (Map.Entry snapshotEntry : snapshot.entrySet()) {
                            key = snapshotEntry.getKey();
                            operations = (OLuceneTxOperations)snapshotEntry.getValue();
                            for (OIdentifiable oIdentifiable : operations.removed) {
                                indexEngine.remove(OLuceneIndexNotUnique.this.decodeKey(key), oIdentifiable);
                            }
                        }
                        for (Map.Entry snapshotEntry : snapshot.entrySet()) {
                            key = snapshotEntry.getKey();
                            operations = (OLuceneTxOperations)snapshotEntry.getValue();
                            indexEngine.put(OLuceneIndexNotUnique.this.decodeKey(key), operations.added);
                        }
                        OTransaction transaction = OLuceneIndexNotUnique.this.getDatabase().getTransaction();
                        OLuceneIndexNotUnique.this.resetTransactionChanges(transaction);
                        return null;
                    }
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    protected Object decodeKey(Object key) {
        return key;
    }

    private void resetTransactionChanges(OTransaction transaction) {
        transaction.setCustomData(this.getName(), null);
    }

    protected void putInSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        OLuceneTxOperations operations = (OLuceneTxOperations)snapshot.get(key = this.getCollatingValue(key));
        if (operations == null) {
            operations = new OLuceneTxOperations();
            snapshot.put(key, operations);
        }
        operations.added.add((OIdentifiable)value.getIdentity());
        snapshot.put(key, operations);
    }

    protected void removeFromSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        OLuceneTxOperations operations = (OLuceneTxOperations)snapshot.get(key = this.getCollatingValue(key));
        if (operations == null) {
            operations = new OLuceneTxOperations();
            snapshot.put(key, operations);
        }
        operations.removed.add((OIdentifiable)value.getIdentity());
        snapshot.put(key, operations);
    }

    protected void clearSnapshot(OIndexAbstract.IndexTxSnapshot indexTxSnapshot) {
        indexTxSnapshot.clear = true;
        indexTxSnapshot.indexSnapshot.clear();
    }

    protected void onIndexEngineChange(int indexId) {
        while (true) {
            try {
                this.storage.callIndexEngine(false, false, indexId, (OIndexEngineCallback)new OIndexEngineCallback<Object>(){

                    public Object callEngine(OIndexEngine engine) {
                        OLuceneIndexEngine oIndexEngine = (OLuceneIndexEngine)engine;
                        oIndexEngine.init(OLuceneIndexNotUnique.this.getName(), OLuceneIndexNotUnique.this.getType(), OLuceneIndexNotUnique.this.getDefinition(), OLuceneIndexNotUnique.this.isAutomatic(), OLuceneIndexNotUnique.this.getMetadata());
                        return null;
                    }
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    protected Object encodeKey(Object key) {
        return key;
    }

    public OLuceneTxChanges getTransactionChanges(OTransaction transaction) {
        OLuceneTxChanges changes = (OLuceneTxChanges)transaction.getCustomData(this.getName());
        if (changes == null) {
            while (true) {
                try {
                    changes = (OLuceneTxChanges)this.storage.callIndexEngine(false, false, this.indexId, (OIndexEngineCallback)new OIndexEngineCallback<OLuceneTxChanges>(){

                        public OLuceneTxChanges callEngine(OIndexEngine engine) {
                            OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                            try {
                                return indexEngine.buildTxChanges();
                            }
                            catch (IOException e) {
                                throw OException.wrapException((OException)new OIndexException("Cannot get searcher from index " + OLuceneIndexNotUnique.this.getName()), (Throwable)e);
                            }
                        }
                    });
                }
                catch (OInvalidIndexEngineIdException e) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
            transaction.setCustomData(this.getName(), (Object)changes);
        }
        return changes;
    }

    public OLuceneIndexNotUnique create(String name, OIndexDefinition indexDefinition, String clusterIndexName, Set<String> clustersToIndex, boolean rebuild, OProgressListener progressListener) {
        return (OLuceneIndexNotUnique)super.create(indexDefinition, clusterIndexName, clustersToIndex, rebuild, progressListener, this.determineValueSerializer());
    }

    public Set<OIdentifiable> get(final Object key) {
        final OTransaction transaction = this.getDatabase().getTransaction();
        if (transaction.isActive()) {
            while (true) {
                try {
                    return (Set)this.storage.callIndexEngine(false, false, this.indexId, (OIndexEngineCallback)new OIndexEngineCallback<Set<OIdentifiable>>(){

                        public Set<OIdentifiable> callEngine(OIndexEngine engine) {
                            OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                            return (Set)indexEngine.getInTx(key, OLuceneIndexNotUnique.this.getTransactionChanges(transaction));
                        }
                    });
                }
                catch (OInvalidIndexEngineIdException e) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
        }
        while (true) {
            try {
                return (Set)this.storage.getIndexValue(this.indexId, key);
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public OLuceneIndexNotUnique put(final Object key, final OIdentifiable singleValue) {
        if (key != null) {
            OTransaction transaction = this.getDatabase().getTransaction();
            if (transaction.isActive()) {
                Document luceneDoc;
                OLuceneTxChanges transactionChanges = this.getTransactionChanges(transaction);
                transaction.addIndexEntry((OIndex)this, super.getName(), OTransactionIndexChanges.OPERATION.PUT, this.encodeKey(key), singleValue);
                while (true) {
                    try {
                        luceneDoc = (Document)this.storage.callIndexEngine(false, false, this.indexId, (OIndexEngineCallback)new OIndexEngineCallback<Document>(){

                            public Document callEngine(OIndexEngine engine) {
                                OLuceneIndexEngine oIndexEngine = (OLuceneIndexEngine)engine;
                                return oIndexEngine.buildDocument(key, singleValue);
                            }
                        });
                    }
                    catch (OInvalidIndexEngineIdException e) {
                        this.doReloadIndexEngine();
                        continue;
                    }
                    break;
                }
                try {
                    transactionChanges.put(key, singleValue, luceneDoc);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                while (true) {
                    try {
                        this.storage.updateIndexEntry(this.indexId, key, (Callable)new Callable<Object>(){

                            @Override
                            public Object call() throws Exception {
                                return Arrays.asList(singleValue);
                            }
                        });
                    }
                    catch (OInvalidIndexEngineIdException e) {
                        this.doReloadIndexEngine();
                        continue;
                    }
                    break;
                }
            }
        }
        return this;
    }

    public long getSize() {
        while (true) {
            try {
                return (Long)this.storage.callIndexEngine(false, false, this.indexId, (OIndexEngineCallback)new OIndexEngineCallback<Long>(){

                    public Long callEngine(OIndexEngine engine) {
                        OTransaction transaction = OLuceneIndexNotUnique.this.getDatabase().getTransaction();
                        OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                        return indexEngine.sizeInTx(OLuceneIndexNotUnique.this.getTransactionChanges(transaction));
                    }
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public long getKeySize() {
        return 0L;
    }

    public OIndexCursor iterateEntries(Collection<?> keys, boolean ascSortOrder) {
        return null;
    }

    public OIndexCursor iterateEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        while (true) {
            try {
                return this.storage.iterateIndexEntriesBetween(this.indexId, fromKey, fromInclusive, toKey, toInclusive, ascOrder, null);
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public OIndexCursor iterateEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        while (true) {
            try {
                return this.storage.iterateIndexEntriesMajor(this.indexId, fromKey, fromInclusive, ascOrder, null);
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public OIndexCursor iterateEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        while (true) {
            try {
                return this.storage.iterateIndexEntriesMinor(this.indexId, toKey, toInclusive, ascOrder, null);
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public OIndexCursor cursor() {
        while (true) {
            try {
                return this.storage.getIndexCursor(this.indexId, null);
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public OIndexCursor descCursor() {
        while (true) {
            try {
                return this.storage.getIndexCursor(this.indexId, null);
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public boolean supportsOrderedIterations() {
        return false;
    }

    @Override
    public IndexSearcher searcher() throws IOException {
        while (true) {
            try {
                return (IndexSearcher)this.storage.callIndexEngine(false, false, this.indexId, (OIndexEngineCallback)new OIndexEngineCallback<IndexSearcher>(){

                    public IndexSearcher callEngine(OIndexEngine engine) {
                        OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                        try {
                            return indexEngine.searcher();
                        }
                        catch (IOException e) {
                            throw OException.wrapException((OException)new OIndexException("Cannot get searcher from index " + OLuceneIndexNotUnique.this.getName()), (Throwable)e);
                        }
                    }
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public boolean canBeUsedInEqualityOperators() {
        return false;
    }
}

