/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.query;

import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import com.orientechnologies.orient.core.command.OCommandContext;
import java.io.IOException;
import org.apache.lucene.facet.FacetsConfig;
import org.apache.lucene.facet.taxonomy.TaxonomyReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.MultiReader;
import org.apache.lucene.search.Filter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;

public class OLuceneQueryContext {
    public final OCommandContext context;
    public final Query query;
    public final Filter filter;
    public final Sort sort;
    protected final IndexSearcher searcher;
    public QueryContextCFG cfg;
    public boolean facet = false;
    public boolean drillDown = false;
    public TaxonomyReader reader;
    protected OLuceneTxChanges changes;
    private FacetsConfig facetConfig;
    private String facetField;
    private String drillDownQuery;

    public OLuceneQueryContext(OCommandContext context, IndexSearcher searcher, Query query) {
        this(context, searcher, query, null);
    }

    public OLuceneQueryContext(OCommandContext context, IndexSearcher searcher, Query query, Filter filter) {
        this(context, searcher, query, filter, null);
    }

    public OLuceneQueryContext(OCommandContext context, IndexSearcher searcher, Query query, Filter filter, Sort sort) {
        this.context = context;
        this.searcher = searcher;
        this.query = query;
        this.filter = filter;
        this.sort = sort;
        this.initCFG();
    }

    private void initCFG() {
        this.cfg = this.filter != null && this.sort != null ? QueryContextCFG.FILTER_SORT : (this.filter == null && this.sort == null ? QueryContextCFG.NO_FILTER_NO_SORT : (this.filter != null ? QueryContextCFG.FILTER : QueryContextCFG.SORT));
    }

    public OLuceneQueryContext setFacet(boolean facet) {
        this.facet = facet;
        return this;
    }

    public OLuceneQueryContext setReader(TaxonomyReader reader) {
        this.reader = reader;
        return this;
    }

    public FacetsConfig getFacetConfig() {
        return this.facetConfig;
    }

    public void setFacetConfig(FacetsConfig facetConfig) {
        this.facetConfig = facetConfig;
    }

    public String getFacetField() {
        return this.facetField;
    }

    public void setFacetField(String facetField) {
        this.facetField = facetField;
    }

    public boolean isDrillDown() {
        return this.drillDown;
    }

    public String getDrillDownQuery() {
        return this.drillDownQuery;
    }

    public void setDrillDownQuery(String drillDownQuery) {
        this.drillDownQuery = drillDownQuery;
        this.drillDown = drillDownQuery != null;
    }

    public boolean isInTx() {
        return this.changes != null;
    }

    public OLuceneQueryContext setChanges(OLuceneTxChanges changes) {
        this.changes = changes;
        return this;
    }

    public OLuceneTxChanges changes() {
        return this.changes;
    }

    public IndexSearcher getSearcher() throws IOException {
        return this.changes == null ? this.searcher : new IndexSearcher((IndexReader)new MultiReader(new IndexReader[]{this.searcher.getIndexReader(), this.changes.searcher().getIndexReader()}));
    }

    public static enum QueryContextCFG {
        NO_FILTER_NO_SORT,
        FILTER_SORT,
        FILTER,
        SORT;

    }
}

