/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.configuration;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.teleporter.configuration.api.OAggregatedJoinTableMapping;
import com.orientechnologies.teleporter.configuration.api.OConfiguration;
import com.orientechnologies.teleporter.configuration.api.OConfiguredEdgeClass;
import com.orientechnologies.teleporter.configuration.api.OConfiguredProperty;
import com.orientechnologies.teleporter.configuration.api.OConfiguredPropertyMapping;
import com.orientechnologies.teleporter.configuration.api.OConfiguredVertexClass;
import com.orientechnologies.teleporter.configuration.api.OEdgeMappingInformation;
import com.orientechnologies.teleporter.configuration.api.OSourceTable;
import com.orientechnologies.teleporter.configuration.api.OSplittingEdgeInformation;
import com.orientechnologies.teleporter.configuration.api.OVertexMappingInformation;
import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.exception.OTeleporterRuntimeException;
import com.orientechnologies.teleporter.mapper.rdbms.OAggregatorEdge;
import com.orientechnologies.teleporter.mapper.rdbms.OER2GraphMapper;
import com.orientechnologies.teleporter.mapper.rdbms.classmapper.OEVClassMapper;
import com.orientechnologies.teleporter.mapper.rdbms.classmapper.OEntityClassMapper;
import com.orientechnologies.teleporter.model.dbschema.OAttribute;
import com.orientechnologies.teleporter.model.dbschema.OCanonicalRelationship;
import com.orientechnologies.teleporter.model.dbschema.OEntity;
import com.orientechnologies.teleporter.model.dbschema.OLogicalRelationship;
import com.orientechnologies.teleporter.model.dbschema.ORelationship;
import com.orientechnologies.teleporter.model.dbschema.OSourceDatabaseInfo;
import com.orientechnologies.teleporter.model.graphmodel.OEdgeType;
import com.orientechnologies.teleporter.model.graphmodel.OModelProperty;
import com.orientechnologies.teleporter.model.graphmodel.OVertexType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class OConfigurationHandler {
    private boolean runningAggregationStrategy;

    public OConfigurationHandler(boolean runningAggregationStrategy) {
        this.runningAggregationStrategy = runningAggregationStrategy;
    }

    public OConfiguration buildConfigurationFromJSONDoc(ODocument jsonConfiguration) {
        return this.buildConfigurationFromJSONDoc(jsonConfiguration, true);
    }

    public OConfiguration buildConfigurationFromJSONDoc(ODocument jsonConfiguration, boolean keepVerticesCoordinates) {
        OConfiguration configuration = new OConfiguration();
        this.buildConfiguredVertices(jsonConfiguration, configuration, keepVerticesCoordinates);
        this.buildConfiguredEdges(jsonConfiguration, configuration);
        return configuration;
    }

    private void buildConfiguredVertices(ODocument jsonConfiguration, OConfiguration configuration, boolean keepVerticesCoordinates) {
        List verticesDoc = (List)jsonConfiguration.field("vertices");
        LinkedList<OConfiguredVertexClass> configuredVertices = new LinkedList<OConfiguredVertexClass>();
        if (verticesDoc == null) {
            OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'vertices' field not found.");
            throw new OTeleporterRuntimeException();
        }
        for (ODocument currentVertexDoc : verticesDoc) {
            ODocument mappingDoc;
            String configuredVertexClassName = (String)currentVertexDoc.field("name");
            if (configuredVertexClassName == null) {
                OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'name' field not found in vertex class definition.");
                throw new OTeleporterRuntimeException();
            }
            OConfiguredVertexClass currentConfiguredVertex = new OConfiguredVertexClass(configuredVertexClassName, configuration);
            OVertexMappingInformation currentMapping = new OVertexMappingInformation(currentConfiguredVertex);
            List externalKeyProps = (List)currentVertexDoc.field("externalKey");
            if (externalKeyProps != null) {
                currentConfiguredVertex.setExternalKeyProps(externalKeyProps);
            }
            if ((mappingDoc = (ODocument)currentVertexDoc.field("mapping")) == null) {
                OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'mapping' field not found in the '%s' vertex-type definition.", configuredVertexClassName);
                throw new OTeleporterRuntimeException();
            }
            String aggregationFunction = (String)mappingDoc.field("aggregationFunction");
            currentMapping.setAggregationFunction(aggregationFunction);
            List sourceTableDocs = (List)mappingDoc.field("sourceTables");
            if (sourceTableDocs == null) {
                OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'sourceTables' field not found in the '%s' vertex-type mapping.", configuredVertexClassName);
                throw new OTeleporterRuntimeException();
            }
            LinkedList<OSourceTable> sourceTables = new LinkedList<OSourceTable>();
            HashMap<String, String> sourceId2tableName = new HashMap<String, String>();
            int i = 0;
            for (ODocument sourceTable : sourceTableDocs) {
                String sourceIdName = (String)sourceTable.field("name");
                String sourceTableName = (String)sourceTable.field("tableName");
                String dataSource = (String)sourceTable.field("dataSource");
                List primaryKey = (List)sourceTable.field("primaryKey");
                if (sourceIdName == null) {
                    OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'name' field not found in the '%s' vertex-class mapping with the source table.", configuredVertexClassName);
                    throw new OTeleporterRuntimeException();
                }
                if (sourceTableName == null) {
                    OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'tableName' field not found in the '%s' vertex-class mapping with the source table.", configuredVertexClassName);
                    throw new OTeleporterRuntimeException();
                }
                if (dataSource == null) {
                    OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'dataSource' field not found in the '%s' vertex-class mapping with the source table.", configuredVertexClassName);
                    throw new OTeleporterRuntimeException();
                }
                sourceId2tableName.put(sourceIdName, sourceTableName);
                List aggregationColumns = (List)sourceTable.field("aggregationColumns");
                List primaryKeyColumns = (List)sourceTable.field("primaryKey");
                if (aggregationFunction != null && aggregationColumns == null) {
                    OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'aggregationColumns' field not found in the '%s' vertex-class mapping with the source table ('aggregationFunction' field is stated, thus 'aggregationColumns' field is expected for each source table).", configuredVertexClassName);
                    throw new OTeleporterRuntimeException();
                }
                OSourceTable currentSourceTable = new OSourceTable(sourceIdName, currentMapping);
                currentSourceTable.setDataSource(dataSource);
                currentSourceTable.setTableName(sourceTableName);
                currentSourceTable.setPrimaryKeyColumns(primaryKey);
                if (aggregationFunction != null && aggregationColumns != null) {
                    currentSourceTable.setAggregationColumns(aggregationColumns);
                }
                currentSourceTable.setPrimaryKeyColumns(primaryKeyColumns);
                sourceTables.add(currentSourceTable);
                ++i;
            }
            currentMapping.setSourceTables(sourceTables);
            currentConfiguredVertex.setMapping(currentMapping);
            List<OConfiguredProperty> configuredProperties = this.extractProperties(currentVertexDoc, configuredVertexClassName);
            currentConfiguredVertex.setConfiguredProperties(configuredProperties);
            if (keepVerticesCoordinates) {
                currentConfiguredVertex.setX((Double)currentVertexDoc.field("x"));
                currentConfiguredVertex.setY((Double)currentVertexDoc.field("y"));
                currentConfiguredVertex.setPx((Double)currentVertexDoc.field("px"));
                currentConfiguredVertex.setPy((Double)currentVertexDoc.field("py"));
                currentConfiguredVertex.setFixed((Integer)currentVertexDoc.field("fixed"));
            }
            configuredVertices.add(currentConfiguredVertex);
        }
        configuration.setConfiguredVertices(configuredVertices);
    }

    private void buildConfiguredEdges(ODocument jsonConfiguration, OConfiguration configuration) {
        List edgesDoc = (List)jsonConfiguration.field("edges");
        LinkedList<OConfiguredEdgeClass> configuredEdges = new LinkedList<OConfiguredEdgeClass>();
        if (edgesDoc == null) {
            OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'edges' field not found.");
            throw new OTeleporterRuntimeException();
        }
        for (ODocument currentEdgeDoc : edgesDoc) {
            String[] edgeFields = currentEdgeDoc.fieldNames();
            if (edgeFields.length != 1) {
                OTeleporterContext.getInstance().getOutputManager().error("Configuration error: wrong edge definition.");
            }
            String configuredEdgeClassName = edgeFields[0];
            OConfiguredEdgeClass currentConfiguredEdge = new OConfiguredEdgeClass(configuredEdgeClassName, configuration);
            OAggregatedJoinTableMapping joinTableMapping = null;
            LinkedList<OEdgeMappingInformation> edgeMappings = new LinkedList<OEdgeMappingInformation>();
            ODocument currentEdgeInfo = (ODocument)currentEdgeDoc.field(configuredEdgeClassName);
            List mappingDocs = (List)currentEdgeInfo.field("mapping");
            ODocument splittingDoc = (ODocument)currentEdgeInfo.field("splitting");
            if (mappingDocs == null && splittingDoc == null) {
                OTeleporterContext.getInstance().getOutputManager().error("Configuration error: neither 'mapping' nor 'splitting' fields found in the '%s' edge-type definition.", configuredEdgeClassName);
                throw new OTeleporterRuntimeException();
            }
            if (mappingDocs != null && splittingDoc != null) {
                OTeleporterContext.getInstance().getOutputManager().error("Configuration error: both 'mapping' and 'splitting' fields found in the '%s' edge-type definition. These fields are mutually exclusive.", configuredEdgeClassName);
                throw new OTeleporterRuntimeException();
            }
            if (mappingDocs != null) {
                for (ODocument mappingDoc : mappingDocs) {
                    OEdgeMappingInformation currentMapping = new OEdgeMappingInformation(currentConfiguredEdge);
                    String currentForeignEntityName = (String)mappingDoc.field("fromTable");
                    String currentParentEntityName = (String)mappingDoc.field("toTable");
                    List fromColumns = (List)mappingDoc.field("fromColumns");
                    List toColumns = (List)mappingDoc.field("toColumns");
                    ODocument joinTableDoc = (ODocument)mappingDoc.field("joinTable");
                    if (currentForeignEntityName == null) {
                        OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'fromTable' field not found in the '%s' edge-type mapping.", configuredEdgeClassName);
                        throw new OTeleporterRuntimeException();
                    }
                    if (currentParentEntityName == null) {
                        OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'toTable' field not found in the '%s' edge-type mapping.", configuredEdgeClassName);
                        throw new OTeleporterRuntimeException();
                    }
                    if (fromColumns == null) {
                        OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'fromColumns' field not found in the '%s' edge-type mapping.", configuredEdgeClassName);
                        throw new OTeleporterRuntimeException();
                    }
                    if (toColumns == null) {
                        OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'toColumns' field not found in the '%s' edge-type mapping.", configuredEdgeClassName);
                        throw new OTeleporterRuntimeException();
                    }
                    String direction = (String)mappingDoc.field("direction");
                    if (direction != null && !direction.equals("direct") && !direction.equals("inverse")) {
                        OTeleporterContext.getInstance().getOutputManager().error("Configuration error: direction for the edge %s cannot be '%s'. Allowed values: 'direct' or 'inverse' \n", configuredEdgeClassName, direction);
                        throw new OTeleporterRuntimeException();
                    }
                    boolean foreignEntityIsJoinTableToAggregate = false;
                    if (joinTableDoc != null) {
                        String joinTableName = (String)joinTableDoc.field("tableName");
                        if (joinTableName == null) {
                            OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'tableName' field not found in the join table mapping with the '%s' edge-type.", configuredEdgeClassName);
                            throw new OTeleporterRuntimeException();
                        }
                        joinTableMapping = new OAggregatedJoinTableMapping(joinTableName);
                        if (this.runningAggregationStrategy) {
                            List joinTableFromColumns = (List)joinTableDoc.field("fromColumns");
                            List joinTableToColumns = (List)joinTableDoc.field("toColumns");
                            if (joinTableFromColumns == null) {
                                OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'fromColumns' field not found in the join table mapping with the '%s' edge-type.", configuredEdgeClassName);
                                throw new OTeleporterRuntimeException();
                            }
                            if (joinTableToColumns == null) {
                                OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'toColumns' field not found in the join table mapping with the '%s' edge-type.", configuredEdgeClassName);
                                throw new OTeleporterRuntimeException();
                            }
                            joinTableMapping.setFromColumns(joinTableFromColumns);
                            joinTableMapping.setToColumns(joinTableToColumns);
                        } else {
                            OTeleporterContext.getInstance().getOutputManager().error("Configuration not compliant with the chosen strategy: you cannot perform the aggregation declared in the migrationConfigDoc for the join table %s while executing migration with a not-aggregating strategy. Thus no aggregation will be performed.\n", joinTableName);
                            throw new OTeleporterRuntimeException();
                        }
                    }
                    currentMapping.setFromTableName(currentForeignEntityName);
                    currentMapping.setToTableName(currentParentEntityName);
                    currentMapping.setFromColumns(fromColumns);
                    currentMapping.setToColumns(toColumns);
                    currentMapping.setDirection(direction);
                    currentMapping.setRepresentedJoinTableMapping(joinTableMapping);
                    edgeMappings.add(currentMapping);
                }
                currentConfiguredEdge.setMappings(edgeMappings);
            } else if (splittingDoc != null) {
                String fromVertexClass = (String)splittingDoc.field("fromVertexClass");
                if (fromVertexClass == null) {
                    OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'fromVertexClass' field not found in the 'splitting' area in the '%s' edge-type definition.", configuredEdgeClassName);
                    throw new OTeleporterRuntimeException();
                }
                String toVertexClass = (String)splittingDoc.field("toVertexClass");
                if (fromVertexClass == null) {
                    OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'toVertexClass' field not found in the 'splitting' area in the '%s' edge-type definition.", configuredEdgeClassName);
                    throw new OTeleporterRuntimeException();
                }
                String sourceTable = (String)splittingDoc.field("sourceTable");
                if (sourceTable == null) {
                    OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'sourceTable' field not found in the 'splitting' area in the '%s' edge-type definition.", configuredEdgeClassName);
                    throw new OTeleporterRuntimeException();
                }
                String direction = (String)splittingDoc.field("direction");
                if (direction == null) {
                    direction = "direct";
                }
                OSplittingEdgeInformation splittingEdgeInfo = new OSplittingEdgeInformation(fromVertexClass, toVertexClass, sourceTable);
                currentConfiguredEdge.setSplittingEdgeInfo(splittingEdgeInfo);
            }
            if (currentEdgeInfo.field("isLogical") != null) {
                currentConfiguredEdge.setLogical((Boolean)currentEdgeInfo.field("isLogical"));
            }
            List<OConfiguredProperty> configuredProperties = this.extractProperties(currentEdgeInfo, configuredEdgeClassName);
            currentConfiguredEdge.setConfiguredProperties(configuredProperties);
            configuredEdges.add(currentConfiguredEdge);
        }
        configuration.setConfiguredEdges(configuredEdges);
    }

    private List<OConfiguredProperty> extractProperties(ODocument currentElementInfo, String className) {
        ODocument elementPropsDoc = (ODocument)currentElementInfo.field("properties");
        LinkedList<OConfiguredProperty> configuredProperties = new LinkedList<OConfiguredProperty>();
        if (elementPropsDoc != null) {
            String[] propertiesFields;
            for (String propertyName : propertiesFields = elementPropsDoc.fieldNames()) {
                ODocument currentElementPropertyDoc = (ODocument)elementPropsDoc.field(propertyName);
                Boolean isIncludedInMigration = (Boolean)currentElementPropertyDoc.field("include");
                String propertyType = (String)currentElementPropertyDoc.field("type");
                Integer ordinalPosition = (Integer)currentElementPropertyDoc.field("ordinalPosition");
                if (isIncludedInMigration == null) {
                    OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'include' field not found in the '%s' property definition ('%s' Class).", propertyName, className);
                    throw new OTeleporterRuntimeException();
                }
                if (propertyType == null) {
                    OTeleporterContext.getInstance().getStatistics().warningMessages.add("Configuration ERROR: the property " + propertyName + " will not added to the correspondent Class because the type is badly defined or not defined at all.");
                    continue;
                }
                propertyType = propertyType.toUpperCase(Locale.ENGLISH);
                if (ordinalPosition == null) {
                    OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'ordinalPosition' field not found in the '%s' property definition ('%s' Class).", propertyName, className);
                    throw new OTeleporterRuntimeException();
                }
                Boolean mandatory = (Boolean)currentElementPropertyDoc.field("mandatory");
                Boolean readOnly = (Boolean)currentElementPropertyDoc.field("readOnly");
                Boolean notNull = (Boolean)currentElementPropertyDoc.field("notNull");
                if (mandatory == null) {
                    OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'mandatory' field not found in the '%s' property definition ('%s' Class).", propertyName, className);
                    throw new OTeleporterRuntimeException();
                }
                if (readOnly == null) {
                    OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'readOnly' field not found in the '%s' property definition ('%s' Class).", propertyName, className);
                    throw new OTeleporterRuntimeException();
                }
                if (notNull == null) {
                    OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'notNull' field not found in the '%s' property definition ('%s' Class).", propertyName, className);
                    throw new OTeleporterRuntimeException();
                }
                ODocument propertyMappingInfo = (ODocument)currentElementPropertyDoc.field("mapping");
                OConfiguredPropertyMapping propertyMapping = null;
                if (propertyMappingInfo != null) {
                    String source = (String)propertyMappingInfo.field("source");
                    String columnName = (String)propertyMappingInfo.field("columnName");
                    String type = (String)propertyMappingInfo.field("type");
                    if (source == null) {
                        OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'source' field not found in the '%s' property mapping ('%s' Class).", propertyName, className);
                        throw new OTeleporterRuntimeException();
                    }
                    if (columnName == null) {
                        OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'columnName' field not found in the '%s' property mapping ('%s' Class).", propertyName, className);
                        throw new OTeleporterRuntimeException();
                    }
                    if (type == null) {
                        OTeleporterContext.getInstance().getOutputManager().error("Configuration error: 'type' field not found in the '%s' property mapping ('%s' Class).", propertyName, className);
                        throw new OTeleporterRuntimeException();
                    }
                    propertyMapping = new OConfiguredPropertyMapping(source);
                    propertyMapping.setColumnName(columnName);
                    propertyMapping.setType(type);
                }
                OConfiguredProperty currentConfiguredProperty = new OConfiguredProperty(propertyName);
                currentConfiguredProperty.setIncludedInMigration(isIncludedInMigration);
                currentConfiguredProperty.setPropertyType(propertyType);
                currentConfiguredProperty.setOrdinalPosition(ordinalPosition);
                currentConfiguredProperty.setMandatory(mandatory);
                currentConfiguredProperty.setReadOnly(readOnly);
                currentConfiguredProperty.setNotNull(notNull);
                currentConfiguredProperty.setPropertyMapping(propertyMapping);
                configuredProperties.add(currentConfiguredProperty);
            }
        }
        return configuredProperties;
    }

    public ODocument buildJSONDocFromConfiguration(OConfiguration configuration) {
        ODocument jsonConfiguration = new ODocument();
        this.writeConfiguredVerticesOnJsonDocument(configuration, jsonConfiguration);
        this.writeConfiguredEdgesOnJsonDocument(configuration, jsonConfiguration);
        return jsonConfiguration;
    }

    private void writeConfiguredVerticesOnJsonDocument(OConfiguration configuration, ODocument jsonConfiguration) {
        LinkedList<ODocument> vertices = new LinkedList<ODocument>();
        for (OConfiguredVertexClass currConfiguredVertex : configuration.getConfiguredVertices()) {
            Integer fixed;
            ODocument currVertexDoc = new ODocument();
            currVertexDoc.field("name", (Object)currConfiguredVertex.getName());
            OVertexMappingInformation currVertexMapping = currConfiguredVertex.getMapping();
            ODocument currVertexMappingDoc = new ODocument();
            List<OSourceTable> sourceTables = currVertexMapping.getSourceTables();
            LinkedList<ODocument> sourceTablesDoc = new LinkedList<ODocument>();
            for (OSourceTable currSourceTable : sourceTables) {
                ODocument currSourceTableDoc = new ODocument();
                currSourceTableDoc.field("name", (Object)currSourceTable.getSourceIdName());
                currSourceTableDoc.field("dataSource", (Object)currSourceTable.getDataSource());
                currSourceTableDoc.field("tableName", (Object)currSourceTable.getTableName());
                List<String> aggregationColumns = currSourceTable.getAggregationColumns();
                if (aggregationColumns != null) {
                    currSourceTableDoc.field("aggregationColumns", aggregationColumns);
                }
                if (currSourceTable.getPrimaryKeyColumns() != null) {
                    currSourceTableDoc.field("primaryKey", currSourceTable.getPrimaryKeyColumns());
                }
                sourceTablesDoc.add(currSourceTableDoc);
            }
            currVertexMappingDoc.field("sourceTables", sourceTablesDoc);
            String aggregationFunction = currVertexMapping.getAggregationFunction();
            if (aggregationFunction != null) {
                currVertexMappingDoc.field("aggregationFunction", (Object)aggregationFunction);
            }
            currVertexDoc.field("mapping", (Object)currVertexMappingDoc);
            ODocument propertiesDoc = this.writeConfiguredProperties(currConfiguredVertex.getConfiguredProperties());
            currVertexDoc.field("properties", (Object)propertiesDoc);
            if (currConfiguredVertex.getExternalKeyProps().size() > 0) {
                currVertexDoc.field("externalKey", currConfiguredVertex.getExternalKeyProps());
            }
            Double x = currConfiguredVertex.getX();
            Double y = currConfiguredVertex.getY();
            if (x != null && y != null) {
                currVertexDoc.field("x", (Object)x);
                currVertexDoc.field("y", (Object)y);
            }
            Double px = currConfiguredVertex.getPx();
            Double py = currConfiguredVertex.getPy();
            if (px != null && py != null) {
                currVertexDoc.field("px", (Object)px);
                currVertexDoc.field("py", (Object)py);
            }
            if ((fixed = currConfiguredVertex.getFixed()) != null) {
                currVertexDoc.field("fixed", (Object)fixed);
            }
            vertices.add(currVertexDoc);
        }
        jsonConfiguration.field("vertices", vertices);
    }

    private void writeConfiguredEdgesOnJsonDocument(OConfiguration configuration, ODocument jsonConfiguration) {
        LinkedList<ODocument> edges = new LinkedList<ODocument>();
        for (OConfiguredEdgeClass currConfiguredEdge : configuration.getConfiguredEdges()) {
            ODocument currEdgeDoc = new ODocument();
            ODocument currEdgeInfoDoc = new ODocument();
            String edgeClassName = currConfiguredEdge.getName();
            List<OEdgeMappingInformation> edgeMappings = currConfiguredEdge.getMappings();
            OSplittingEdgeInformation splittingEdgeInfo = currConfiguredEdge.getSplittingEdgeInfo();
            if (edgeMappings != null) {
                LinkedList<ODocument> edgeMappingDocs = new LinkedList<ODocument>();
                for (OEdgeMappingInformation currEdgeMapping : edgeMappings) {
                    ODocument currEdgeMappingDoc = new ODocument();
                    currEdgeMappingDoc.field("fromTable", (Object)currEdgeMapping.getFromTableName());
                    currEdgeMappingDoc.field("fromColumns", currEdgeMapping.getFromColumns());
                    currEdgeMappingDoc.field("toTable", (Object)currEdgeMapping.getToTableName());
                    currEdgeMappingDoc.field("toColumns", currEdgeMapping.getToColumns());
                    OAggregatedJoinTableMapping representedJoinTableMapping = currEdgeMapping.getRepresentedJoinTableMapping();
                    if (representedJoinTableMapping != null) {
                        ODocument joinTableMapping = new ODocument();
                        joinTableMapping.field("tableName", (Object)representedJoinTableMapping.getTableName());
                        joinTableMapping.field("fromColumns", representedJoinTableMapping.getFromColumns());
                        joinTableMapping.field("toColumns", representedJoinTableMapping.getToColumns());
                        currEdgeMappingDoc.field("joinTable", (Object)joinTableMapping);
                    }
                    currEdgeMappingDoc.field("direction", (Object)currEdgeMapping.getDirection());
                    edgeMappingDocs.add(currEdgeMappingDoc);
                }
                currEdgeInfoDoc.field("mapping", edgeMappingDocs);
            } else if (splittingEdgeInfo != null) {
                ODocument splittingInfoDoc = new ODocument();
                splittingInfoDoc.field("fromVertexClass", (Object)splittingEdgeInfo.getFromVertexClass());
                splittingInfoDoc.field("toVertexClass", (Object)splittingEdgeInfo.getToVertexClass());
                splittingInfoDoc.field("sourceTable", (Object)splittingEdgeInfo.getSourceTable());
                currEdgeInfoDoc.field("splitting", (Object)splittingInfoDoc);
            }
            currEdgeInfoDoc.field("isLogical", (Object)currConfiguredEdge.isLogical());
            ODocument propertiesDoc = this.writeConfiguredProperties(currConfiguredEdge.getConfiguredProperties());
            currEdgeInfoDoc.field("properties", (Object)propertiesDoc);
            currEdgeDoc.field(edgeClassName, (Object)currEdgeInfoDoc);
            edges.add(currEdgeDoc);
        }
        jsonConfiguration.field("edges", edges);
    }

    private ODocument writeConfiguredProperties(Collection<OConfiguredProperty> configuredProperties) {
        ODocument propertiesDoc = new ODocument();
        for (OConfiguredProperty currConfiguredProperty : configuredProperties) {
            ODocument currConfiguredPropertyInfoDoc = new ODocument();
            String propertyName = currConfiguredProperty.getPropertyName();
            currConfiguredPropertyInfoDoc.field("include", (Object)currConfiguredProperty.isIncludedInMigration());
            currConfiguredPropertyInfoDoc.field("type", (Object)currConfiguredProperty.getPropertyType());
            currConfiguredPropertyInfoDoc.field("ordinalPosition", (Object)currConfiguredProperty.getOrdinalPosition());
            currConfiguredPropertyInfoDoc.field("mandatory", (Object)currConfiguredProperty.isMandatory());
            currConfiguredPropertyInfoDoc.field("readOnly", (Object)currConfiguredProperty.isReadOnly());
            currConfiguredPropertyInfoDoc.field("notNull", (Object)currConfiguredProperty.isNotNull());
            OConfiguredPropertyMapping propertyMapping = currConfiguredProperty.getPropertyMapping();
            if (propertyMapping != null) {
                ODocument propertyMappingDoc = new ODocument();
                propertyMappingDoc.field("source", (Object)propertyMapping.getSourceName());
                propertyMappingDoc.field("columnName", (Object)propertyMapping.getColumnName());
                propertyMappingDoc.field("type", (Object)propertyMapping.getType());
                currConfiguredPropertyInfoDoc.field("mapping", (Object)propertyMappingDoc);
            }
            propertiesDoc.field(propertyName, (Object)currConfiguredPropertyInfoDoc);
        }
        return propertiesDoc;
    }

    public OConfiguration buildConfigurationFromMapper(OER2GraphMapper mapper) {
        OConfiguration configuration = new OConfiguration();
        Map<String, String> tableName2SourceIdName = this.buildConfigVerticesFromGraphModel(mapper, configuration);
        this.buildConfigEdgesFromGraphModel(mapper, configuration, tableName2SourceIdName);
        return configuration;
    }

    protected Map<String, String> buildConfigVerticesFromGraphModel(OER2GraphMapper mapper, OConfiguration configuration) {
        HashMap<String, String> tableName2SourceIdName = new HashMap<String, String>();
        for (OVertexType currVertexType : mapper.getVertexType2EVClassMappers().keySet()) {
            OEntity currentEntity = mapper.getEntityByVertexType(currVertexType);
            OSourceDatabaseInfo currSourceDBInfo = currentEntity.getSourceDataseInfo();
            String sourceIdName = currSourceDBInfo.getSourceIdName() + "_" + currentEntity.getName();
            tableName2SourceIdName.put(currentEntity.getName(), sourceIdName);
        }
        LinkedList<OConfiguredVertexClass> configuredVertexClasses = new LinkedList<OConfiguredVertexClass>();
        for (OVertexType currVertexType : mapper.getVertexType2EVClassMappers().keySet()) {
            if (this.runningAggregationStrategy && currVertexType.isFromJoinTable()) continue;
            OEntity currentEntity = mapper.getEntityByVertexType(currVertexType);
            OSourceDatabaseInfo currSourceDBInfo = currentEntity.getSourceDataseInfo();
            List<OEVClassMapper> currClassMappers = mapper.getVertexType2EVClassMappers().get(currVertexType);
            if (currClassMappers.size() == 0) {
                OTeleporterContext.getInstance().getOutputManager().error("Error during the model building: the %s vertex class is not mapped to any table.", currVertexType.getName());
                throw new OTeleporterRuntimeException();
            }
            OConfiguredVertexClass currConfiguredVertexClass = new OConfiguredVertexClass(currVertexType.getName(), configuration);
            OVertexMappingInformation vertexMappingInfo = new OVertexMappingInformation(currConfiguredVertexClass);
            LinkedList<OSourceTable> sourceTables = new LinkedList<OSourceTable>();
            LinkedList<String> primaryKeyColumns = new LinkedList<String>();
            for (OAttribute currAttribute : currentEntity.getPrimaryKey().getInvolvedAttributes()) {
                primaryKeyColumns.add(currAttribute.getName());
            }
            String sourceIdName = currSourceDBInfo.getSourceIdName() + "_" + currentEntity.getName();
            OSourceTable sourceTable = new OSourceTable(sourceIdName, vertexMappingInfo);
            sourceTable.setDataSource(currSourceDBInfo.getSourceIdName());
            sourceTable.setTableName(currentEntity.getName());
            sourceTable.setPrimaryKeyColumns(primaryKeyColumns);
            sourceTables.add(sourceTable);
            vertexMappingInfo.setSourceTables(sourceTables);
            currConfiguredVertexClass.setMapping(vertexMappingInfo);
            LinkedList<OConfiguredProperty> configuredProperties = new LinkedList<OConfiguredProperty>();
            for (OModelProperty currModelProperty : currVertexType.getProperties()) {
                String correspondentAttributeName;
                OAttribute correspondentAttribute;
                OConfiguredProperty currConfiguredProperty = new OConfiguredProperty(currModelProperty.getName());
                currConfiguredProperty.setIncludedInMigration(currModelProperty.isIncludedInMigration());
                currConfiguredProperty.setPropertyType(currModelProperty.getOrientdbType());
                currConfiguredProperty.setOrdinalPosition(currModelProperty.getOrdinalPosition());
                if (currModelProperty.isMandatory() != null) {
                    currConfiguredProperty.setMandatory(currModelProperty.isMandatory());
                }
                if (currModelProperty.isReadOnly() != null) {
                    currConfiguredProperty.setReadOnly(currModelProperty.isReadOnly());
                }
                if (currModelProperty.isNotNull() != null) {
                    currConfiguredProperty.setNotNull(currModelProperty.isNotNull());
                }
                if ((correspondentAttribute = currentEntity.getAttributeByName(correspondentAttributeName = mapper.getAttributeByPropertyAboveMappers(currModelProperty.getName(), currClassMappers))) != null) {
                    OConfiguredPropertyMapping propertyMappingInfo = new OConfiguredPropertyMapping(sourceTable.getSourceIdName());
                    propertyMappingInfo.setColumnName(correspondentAttributeName);
                    propertyMappingInfo.setType(correspondentAttribute.getDataType());
                    currConfiguredProperty.setPropertyMapping(propertyMappingInfo);
                }
                configuredProperties.add(currConfiguredProperty);
            }
            currConfiguredVertexClass.setConfiguredProperties(configuredProperties);
            if (currVertexType.getExternalKey().size() > 0) {
                currConfiguredVertexClass.getExternalKeyProps().addAll(currVertexType.getExternalKey());
            }
            configuredVertexClasses.add(currConfiguredVertexClass);
        }
        configuration.setConfiguredVertices(configuredVertexClasses);
        return tableName2SourceIdName;
    }

    protected void buildConfigEdgesFromGraphModel(OER2GraphMapper mapper, OConfiguration configuration, Map<String, String> tableName2SourceIdName) {
        String executionStrategy = OTeleporterContext.getInstance().getExecutionStrategy();
        LinkedList<OConfiguredEdgeClass> configuredEdgeClasses = new LinkedList<OConfiguredEdgeClass>();
        for (OEdgeType currEdgeType : mapper.getGraphModel().getEdgesType()) {
            OConfiguredEdgeClass currConfiguredEdgeClass = new OConfiguredEdgeClass(currEdgeType.getName(), configuration);
            OVertexType aggregatedVertexType = null;
            OEntity joinTable = null;
            boolean isLogicalEdge = false;
            if (!currEdgeType.isSplittingEdge()) {
                OEdgeMappingInformation currEdgeMappingInformation;
                List relationships = mapper.getEdgeType2relationships().get(currEdgeType);
                LinkedList<OEdgeMappingInformation> edgeMappings = new LinkedList<OEdgeMappingInformation>();
                OAggregatorEdge aggregatorEdge = mapper.getAggregatorEdgeByEdgeTypeName(currEdgeType.getName());
                if (aggregatorEdge == null) {
                    for (ORelationship currentRelationship : relationships) {
                        OVertexType startingVertexType;
                        if (currentRelationship instanceof OLogicalRelationship) {
                            isLogicalEdge = true;
                        }
                        if ((startingVertexType = mapper.getVertexTypeByEntity(currentRelationship.getForeignEntity())) == null || mapper.getJoinVertex2aggregatorEdges().keySet().contains(startingVertexType)) continue;
                        currEdgeMappingInformation = new OEdgeMappingInformation(currConfiguredEdgeClass);
                        currEdgeMappingInformation.setFromTableName(currentRelationship.getForeignEntity().getName());
                        currEdgeMappingInformation.setToTableName(currentRelationship.getParentEntity().getName());
                        LinkedList<String> fromColumns = new LinkedList<String>();
                        for (OAttribute oAttribute : currentRelationship.getFromColumns()) {
                            fromColumns.add(oAttribute.getName());
                        }
                        LinkedList<String> toColumns = new LinkedList<String>();
                        for (Object attribute2 : currentRelationship.getToColumns()) {
                            toColumns.add(((OAttribute)attribute2).getName());
                        }
                        currEdgeMappingInformation.setFromColumns(fromColumns);
                        currEdgeMappingInformation.setToColumns(toColumns);
                        currEdgeMappingInformation.setDirection(currentRelationship.getDirection());
                        edgeMappings.add(currEdgeMappingInformation);
                    }
                } else {
                    Object attribute2;
                    OVertexType inVertexType = currEdgeType.getInVertexType();
                    OVertexType outVertexType = currEdgeType.getOutVertexType();
                    OEntity startingTable = mapper.getEntityByVertexType(outVertexType);
                    OEntity arrivalTable = mapper.getEntityByVertexType(inVertexType);
                    currEdgeMappingInformation = new OEdgeMappingInformation(currConfiguredEdgeClass);
                    currEdgeMappingInformation.setFromTableName(startingTable.getName());
                    currEdgeMappingInformation.setToTableName(arrivalTable.getName());
                    LinkedList<String> fromColumns = new LinkedList<String>();
                    for (Object attribute2 : startingTable.getPrimaryKey().getInvolvedAttributes()) {
                        fromColumns.add(((OAttribute)attribute2).getName());
                    }
                    LinkedList<String> linkedList = new LinkedList<String>();
                    attribute2 = arrivalTable.getPrimaryKey().getInvolvedAttributes().iterator();
                    while (attribute2.hasNext()) {
                        OAttribute attribute3 = (OAttribute)attribute2.next();
                        linkedList.add(attribute3.getName());
                    }
                    currEdgeMappingInformation.setFromColumns(fromColumns);
                    currEdgeMappingInformation.setToColumns(linkedList);
                    currEdgeMappingInformation.setDirection("direct");
                    aggregatedVertexType = mapper.getJoinVertexTypeByAggregatorEdge(aggregatorEdge.getEdgeType().getName());
                    joinTable = mapper.getEntityByVertexType(aggregatedVertexType);
                    OAggregatedJoinTableMapping joinTableMappingInfo = new OAggregatedJoinTableMapping(joinTable.getName());
                    Iterator<OCanonicalRelationship> outRelationshipsIterator = joinTable.getOutCanonicalRelationships().iterator();
                    OCanonicalRelationship currRelationship = outRelationshipsIterator.next();
                    fromColumns = new LinkedList();
                    for (OAttribute attribute4 : currRelationship.getFromColumns()) {
                        fromColumns.add(attribute4.getName());
                    }
                    currRelationship = outRelationshipsIterator.next();
                    LinkedList<String> linkedList2 = new LinkedList<String>();
                    for (OAttribute attribute3 : currRelationship.getFromColumns()) {
                        linkedList2.add(attribute3.getName());
                    }
                    joinTableMappingInfo.setFromColumns(fromColumns);
                    joinTableMappingInfo.setToColumns(linkedList2);
                    currEdgeMappingInformation.setRepresentedJoinTableMapping(joinTableMappingInfo);
                    edgeMappings.add(currEdgeMappingInformation);
                }
                currConfiguredEdgeClass.setMappings(edgeMappings);
            } else {
                OVertexType inVertexType = currEdgeType.getInVertexType();
                OVertexType outVertexType = currEdgeType.getOutVertexType();
                String sourceTable = mapper.getEEClassMappersByEdge(currEdgeType).get(0).getEntity().getName();
                OSplittingEdgeInformation splittingInfo = new OSplittingEdgeInformation(outVertexType.getName(), inVertexType.getName(), sourceTable);
                currConfiguredEdgeClass.setSplittingEdgeInfo(splittingInfo);
            }
            currConfiguredEdgeClass.setLogical(isLogicalEdge);
            LinkedList<OConfiguredProperty> configuredProperties = new LinkedList<OConfiguredProperty>();
            for (OModelProperty currModelProperty : currEdgeType.getProperties()) {
                String correspondentAttributeName;
                OEntityClassMapper currClassMapper;
                OConfiguredProperty currConfiguredProperty = new OConfiguredProperty(currModelProperty.getName());
                currConfiguredProperty.setIncludedInMigration(true);
                currConfiguredProperty.setPropertyType(currModelProperty.getOrientdbType());
                currConfiguredProperty.setOrdinalPosition(currModelProperty.getOrdinalPosition());
                currConfiguredProperty.setMandatory(false);
                currConfiguredProperty.setReadOnly(false);
                currConfiguredProperty.setNotNull(false);
                if (joinTable != null) {
                    currClassMapper = mapper.getEVClassMappersByEntity(joinTable).get(0);
                    correspondentAttributeName = currClassMapper.getAttributeByProperty(currModelProperty.getName());
                    OAttribute correspondentAttribute = joinTable.getAttributeByName(correspondentAttributeName);
                    if (correspondentAttribute != null) {
                        OConfiguredPropertyMapping propertyMappingInfo = new OConfiguredPropertyMapping(tableName2SourceIdName.get(joinTable.getName()));
                        propertyMappingInfo.setColumnName(correspondentAttributeName);
                        propertyMappingInfo.setType(correspondentAttribute.getDataType());
                        currConfiguredProperty.setPropertyMapping(propertyMappingInfo);
                    }
                } else if (currEdgeType.isSplittingEdge()) {
                    currClassMapper = mapper.getEEClassMappersByEdge(currEdgeType).get(0);
                    correspondentAttributeName = currClassMapper.getAttributeByProperty(currModelProperty.getName());
                    OEntity correspondentEntity = currClassMapper.getEntity();
                    OAttribute correspondentAttribute = null;
                    if (correspondentEntity != null) {
                        correspondentAttribute = correspondentEntity.getAttributeByName(correspondentAttributeName);
                    }
                    if (correspondentAttribute != null) {
                        OConfiguredPropertyMapping propertyMappingInfo = new OConfiguredPropertyMapping(tableName2SourceIdName.get(correspondentEntity.getName()));
                        propertyMappingInfo.setColumnName(correspondentAttributeName);
                        propertyMappingInfo.setType(correspondentAttribute.getDataType());
                        currConfiguredProperty.setPropertyMapping(propertyMappingInfo);
                    }
                }
                configuredProperties.add(currConfiguredProperty);
            }
            currConfiguredEdgeClass.setConfiguredProperties(configuredProperties);
            if (currConfiguredEdgeClass.getMappings() != null && currConfiguredEdgeClass.getMappings().size() > 0) {
                configuredEdgeClasses.add(currConfiguredEdgeClass);
                continue;
            }
            configuredEdgeClasses.add(currConfiguredEdgeClass);
        }
        configuration.setConfiguredEdges(configuredEdgeClasses);
    }

    public void filterAccordingToWhiteList(ODocument jsonConfiguration, List<String> includedTables) {
        List verticesDoc = (List)jsonConfiguration.field("vertices");
        Iterator it = verticesDoc.iterator();
        while (it.hasNext()) {
            String correspondentTableName;
            ODocument currentVertexDoc = (ODocument)it.next();
            ODocument currentMapping = (ODocument)currentVertexDoc.field("mapping");
            List sourceTables = (List)currentMapping.field("sourceTables");
            if (sourceTables.size() != 1 || includedTables.contains(correspondentTableName = (String)((ODocument)sourceTables.get(0)).field("tableName"))) continue;
            it.remove();
        }
        List edgesDoc = (List)jsonConfiguration.field("edges");
        it = edgesDoc.iterator();
        while (it.hasNext()) {
            ODocument currentEdgeDoc = (ODocument)it.next();
            String edgeName = currentEdgeDoc.fieldNames()[0];
            ODocument currentEdgeDocInfo = (ODocument)currentEdgeDoc.field(edgeName);
            List currentEdgeDocMappings = (List)currentEdgeDocInfo.field("mapping");
            ArrayList<ODocument> newMappings = new ArrayList<ODocument>();
            for (ODocument currentMapping : currentEdgeDocMappings) {
                if (!includedTables.contains(currentMapping.field("fromTable")) || !includedTables.contains(currentMapping.field("toTable"))) continue;
                newMappings.add(currentMapping);
            }
            if (newMappings.size() == 0) {
                it.remove();
                continue;
            }
            if (currentEdgeDocMappings.size() <= newMappings.size()) continue;
            currentEdgeDocInfo.field("mapping", (Object)newMappings.toArray());
        }
    }

    public void filterAccordingToBlackList(ODocument jsonConfiguration, List<String> excludedTables) {
        List verticesDoc = (List)jsonConfiguration.field("vertices");
        Iterator it = verticesDoc.iterator();
        while (it.hasNext()) {
            String correspondentTableName;
            ODocument currentVertexDoc = (ODocument)it.next();
            ODocument currentMapping = (ODocument)currentVertexDoc.field("mapping");
            List sourceTables = (List)currentMapping.field("sourceTables");
            if (sourceTables.size() != 1 || !excludedTables.contains(correspondentTableName = (String)((ODocument)sourceTables.get(0)).field("tableName"))) continue;
            it.remove();
        }
        List edgesDoc = (List)jsonConfiguration.field("edges");
        for (ODocument currentEdgeDoc : edgesDoc) {
            String edgeName = currentEdgeDoc.fieldNames()[0];
            ODocument currentEdgeDocInfo = (ODocument)currentEdgeDoc.field(edgeName);
            List currentEdgeDocMappings = (List)currentEdgeDocInfo.field("mapping");
            ArrayList<ODocument> newMappings = new ArrayList<ODocument>();
            for (ODocument currentMapping : currentEdgeDocMappings) {
                if (excludedTables.contains(currentMapping.field("fromTable")) || excludedTables.contains(currentMapping.field("toTable"))) continue;
                newMappings.add(currentMapping);
            }
            if (currentEdgeDocMappings.size() <= newMappings.size()) continue;
            currentEdgeDocInfo.field("mapping", (Object)newMappings.toArray());
        }
    }
}

