/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.configuration.api;

import com.orientechnologies.teleporter.configuration.api.OConfiguredEdgeClass;
import com.orientechnologies.teleporter.configuration.api.OConfiguredVertexClass;
import com.orientechnologies.teleporter.configuration.api.OSourceTable;
import com.orientechnologies.teleporter.model.dbschema.OEntity;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class OConfiguration {
    private static OConfiguration instance = null;
    private List<OConfiguredVertexClass> configuredVertices = new LinkedList<OConfiguredVertexClass>();
    private List<OConfiguredEdgeClass> configuredEdges = new LinkedList<OConfiguredEdgeClass>();

    public static OConfiguration getInstance() {
        if (instance == null) {
            instance = new OConfiguration();
        }
        return instance;
    }

    public List<OConfiguredVertexClass> getConfiguredVertices() {
        return this.configuredVertices;
    }

    public void setConfiguredVertices(List<OConfiguredVertexClass> configuredVertices) {
        this.configuredVertices = configuredVertices;
    }

    public List<OConfiguredEdgeClass> getConfiguredEdges() {
        return this.configuredEdges;
    }

    public void setConfiguredEdges(List<OConfiguredEdgeClass> configuredEdges) {
        this.configuredEdges = configuredEdges;
    }

    public OConfiguredVertexClass getVertexClassByName(String vertexClassName) {
        for (OConfiguredVertexClass currVertexClass : this.configuredVertices) {
            if (!currVertexClass.getName().equals(vertexClassName)) continue;
            return currVertexClass;
        }
        return null;
    }

    public OConfiguredEdgeClass getEdgeClassByName(String edgeClassName) {
        for (OConfiguredEdgeClass currEdgeClass : this.configuredEdges) {
            if (!currEdgeClass.getName().equals(edgeClassName)) continue;
            return currEdgeClass;
        }
        return null;
    }

    public OConfiguredVertexClass getVertexByMappedEntities(List<OEntity> mappedEntities) {
        for (OConfiguredVertexClass currConfiguredVertex : this.configuredVertices) {
            boolean isTargetVertex = this.isTargetVertex(currConfiguredVertex, mappedEntities);
            if (!isTargetVertex) continue;
            return currConfiguredVertex;
        }
        return null;
    }

    private boolean isTargetVertex(OConfiguredVertexClass currConfiguredVertex, List<OEntity> mappedEntities) {
        List<OSourceTable> sourceTables = currConfiguredVertex.getMapping().getSourceTables();
        for (OEntity currEntity : mappedEntities) {
            String entityName = currEntity.getName();
            boolean containsEntity = false;
            for (OSourceTable sourceTable : sourceTables) {
                if (!sourceTable.getTableName().equals(entityName)) continue;
                containsEntity = true;
                break;
            }
            if (containsEntity) continue;
            return false;
        }
        return true;
    }

    public OConfiguredVertexClass getVertexClassByTableName(String tableName) {
        for (OConfiguredVertexClass vertexClass : this.configuredVertices) {
            List<OSourceTable> sourceTables = vertexClass.getMapping().getSourceTables();
            for (OSourceTable sourceTable : sourceTables) {
                if (!sourceTable.getTableName().equals(tableName)) continue;
                return vertexClass;
            }
        }
        return null;
    }

    public Map<String, List<OConfiguredVertexClass>> buildTableName2MappedConfiguredVertices() {
        HashMap<String, List<OConfiguredVertexClass>> tableName2mappedConfiguredVertices = new HashMap<String, List<OConfiguredVertexClass>>();
        for (OConfiguredVertexClass currConfiguredVertexClass : this.configuredVertices) {
            for (OSourceTable currSourceTable : currConfiguredVertexClass.getMapping().getSourceTables()) {
                String tableName = currSourceTable.getTableName();
                LinkedList<OConfiguredVertexClass> mappedVertices = (LinkedList<OConfiguredVertexClass>)tableName2mappedConfiguredVertices.get(tableName);
                if (mappedVertices == null) {
                    mappedVertices = new LinkedList<OConfiguredVertexClass>();
                }
                mappedVertices.add(currConfiguredVertexClass);
                tableName2mappedConfiguredVertices.put(tableName, mappedVertices);
            }
        }
        return tableName2mappedConfiguredVertices;
    }
}

