/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.context;

import com.orientechnologies.teleporter.context.OOutputStreamManager;
import com.orientechnologies.teleporter.context.OTeleporterStatistics;
import com.orientechnologies.teleporter.importengine.rdbms.dbengine.ODBQueryEngine;
import com.orientechnologies.teleporter.nameresolver.ONameResolver;
import com.orientechnologies.teleporter.persistence.handler.ODriverDataTypeHandler;
import java.io.PrintWriter;
import java.io.StringWriter;

public class OTeleporterContext {
    private static OTeleporterContext instance = null;
    private OTeleporterStatistics statistics = new OTeleporterStatistics();
    private OOutputStreamManager outputManager;
    private ODriverDataTypeHandler dataTypeHandler;
    private ONameResolver nameResolver;
    private String driverDependencyPath;
    private String executionStrategy;
    private ODBQueryEngine dbQueryEngine;

    private OTeleporterContext() {
    }

    public static OTeleporterContext getInstance() {
        if (instance == null) {
            instance = new OTeleporterContext();
        }
        return instance;
    }

    public static OTeleporterContext newInstance() {
        instance = new OTeleporterContext();
        return instance;
    }

    public OTeleporterStatistics getStatistics() {
        return this.statistics;
    }

    public void setStatistics(OTeleporterStatistics statistics) {
        this.statistics = statistics;
    }

    public OOutputStreamManager getOutputManager() {
        return this.outputManager;
    }

    public void setOutputManager(OOutputStreamManager outputManager) {
        this.outputManager = outputManager;
    }

    public ODriverDataTypeHandler getDataTypeHandler() {
        return this.dataTypeHandler;
    }

    public void setDataTypeHandler(ODriverDataTypeHandler dataTypeHandler) {
        this.dataTypeHandler = dataTypeHandler;
    }

    public ONameResolver getNameResolver() {
        return this.nameResolver;
    }

    public void setNameResolver(ONameResolver nameResolver) {
        this.nameResolver = nameResolver;
    }

    public String getDriverDependencyPath() {
        return this.driverDependencyPath;
    }

    public void setDriverDependencyPath(String driverDependencyPath) {
        this.driverDependencyPath = driverDependencyPath;
    }

    public String getExecutionStrategy() {
        return this.executionStrategy;
    }

    public void setExecutionStrategy(String executionStrategy) {
        this.executionStrategy = executionStrategy;
    }

    public ODBQueryEngine getDbQueryEngine() {
        return this.dbQueryEngine;
    }

    public void setDbQueryEngine(ODBQueryEngine dbQueryEngine) {
        this.dbQueryEngine = dbQueryEngine;
    }

    public String printExceptionMessage(Exception e, String message, String level) {
        message = e.getMessage() != null ? message + "\n" + e.getClass().getName() + " - " + e.getMessage() : message + "\n" + e.getClass().getName();
        switch (level) {
            case "debug": {
                this.outputManager.debug(message);
                break;
            }
            case "info": {
                this.outputManager.info(message);
                break;
            }
            case "warn": {
                this.outputManager.warn(message);
                break;
            }
            case "error": {
                this.outputManager.error(message);
            }
        }
        return message;
    }

    public String printExceptionStackTrace(Exception e, String level) {
        StringWriter writer = new StringWriter();
        e.printStackTrace(new PrintWriter(writer));
        String s = ((Object)writer).toString();
        switch (level) {
            case "debug": {
                this.outputManager.debug("\n" + s + "\n");
                break;
            }
            case "info": {
                this.outputManager.info("\n" + s + "\n");
                break;
            }
            case "warn": {
                this.outputManager.warn("\n" + s + "\n");
                break;
            }
            case "error": {
                this.outputManager.error("\n" + s + "\n");
            }
        }
        return s;
    }
}

