/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.context;

import com.orientechnologies.teleporter.ui.OStatisticsListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class OTeleporterStatistics {
    public volatile int runningStepNumber;
    public volatile int totalNumberOfEntities;
    public volatile int builtEntities;
    public volatile int entitiesAnalyzedForRelationship;
    public volatile int builtRelationships;
    public volatile int totalNumberOfRelationships;
    public volatile Date startWork1Time;
    public volatile int totalNumberOfModelVertices;
    public volatile int builtModelVertexTypes;
    public volatile int totalNumberOfModelEdges;
    public volatile int builtModelEdgeTypes;
    public volatile Date startWork2Time;
    public volatile int totalNumberOfVertexTypes;
    public volatile int wroteVertexType;
    public volatile int totalNumberOfEdgeTypes;
    public volatile int wroteEdgeType;
    public volatile int totalNumberOfIndices;
    public volatile int wroteIndexes;
    public volatile Date startWork3Time;
    public volatile int totalNumberOfRecords;
    public volatile int analyzedRecords;
    public volatile int orientAddedVertices;
    public volatile int orientUpdatedVertices;
    public volatile int orientAddedEdges;
    public volatile Date startWork4Time;
    public volatile int totalNumberOfLogicalRelationships;
    public volatile int doneLogicalRelationships;
    public volatile int leftVerticesCurrentLogicalRelationship;
    public volatile int doneLeftVerticesCurrentLogicalRelationship;
    public volatile Date startWork5Time;
    public volatile Set<String> warningMessages;
    public volatile Set<String> errorMessages;
    private volatile List<OStatisticsListener> listeners;

    public OTeleporterStatistics() {
        this.init();
        this.warningMessages = new HashSet<String>();
        this.errorMessages = new HashSet<String>();
        this.listeners = new ArrayList<OStatisticsListener>();
    }

    private void init() {
        this.runningStepNumber = -1;
        this.totalNumberOfEntities = 0;
        this.builtEntities = 0;
        this.entitiesAnalyzedForRelationship = 0;
        this.builtRelationships = 0;
        this.totalNumberOfRelationships = 0;
        this.totalNumberOfModelVertices = 0;
        this.builtModelVertexTypes = 0;
        this.totalNumberOfModelEdges = 0;
        this.builtModelEdgeTypes = 0;
        this.totalNumberOfVertexTypes = 0;
        this.wroteVertexType = 0;
        this.totalNumberOfEdgeTypes = 0;
        this.wroteEdgeType = 0;
        this.totalNumberOfIndices = 0;
        this.wroteIndexes = 0;
        this.totalNumberOfRecords = 0;
        this.analyzedRecords = 0;
        this.orientAddedVertices = 0;
        this.orientAddedEdges = 0;
        this.totalNumberOfLogicalRelationships = 0;
        this.doneLogicalRelationships = 0;
        this.leftVerticesCurrentLogicalRelationship = 0;
        this.doneLeftVerticesCurrentLogicalRelationship = 0;
    }

    public void reset() {
        this.init();
    }

    public void registerListener(OStatisticsListener listener) {
        this.listeners.add(listener);
    }

    public void notifyListeners() {
        for (OStatisticsListener listener : this.listeners) {
            listener.updateOnEvent(this);
        }
    }

    public String sourceDbSchemaBuildingProgress() {
        String s = "Source DB Schema\n";
        s = s + "Entities: " + this.builtEntities;
        s = s + "\nRelationships: " + this.builtRelationships;
        return s;
    }

    public String graphModelBuildingProgress() {
        String s = "Graph Model Building\n";
        s = s + "Built Model Vertices: " + this.builtModelVertexTypes;
        s = s + "\nBuilt Model Edges: " + this.builtModelEdgeTypes;
        return s;
    }

    public String orientSchemaWritingProgress() {
        String s = "OrientDB Schema\n";
        s = s + "Vertex Type: " + this.wroteVertexType;
        s = s + "\nEdge Type: " + this.wroteEdgeType;
        s = s + "\nIndexes: " + this.wroteIndexes;
        return s;
    }

    public String importingProgress() {
        String s = "OrientDB Importing\n";
        s = s + "Analyzed Records: " + this.analyzedRecords + "/" + this.totalNumberOfRecords;
        s = s + "\nAdded Vertices on OrientDB: " + this.orientAddedVertices;
        s = s + "\nUpdated Vertices on OrientDB: " + this.orientUpdatedVertices;
        s = s + "\nAdded Edges on OrientDB: " + this.orientAddedEdges;
        return s;
    }

    public String toString() {
        String s = "\n\nSUMMARY\n\n";
        s = s + this.sourceDbSchemaBuildingProgress() + "\n\n" + this.orientSchemaWritingProgress() + "\n\n" + this.importingProgress() + "\n\n";
        if (this.errorMessages.size() > 0) {
            s = s + "Error Messages:\n";
            for (String message : this.errorMessages) {
                s = s + message + "\n";
            }
        }
        s = s + "\n\n";
        if (this.warningMessages.size() > 0) {
            s = s + "Warning Messages:\n";
            for (String message : this.warningMessages) {
                s = s + message + "\n";
            }
        }
        return s;
    }
}

