/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.factory;

import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.importengine.rdbms.dbengine.OCommonQueryBuilder;
import com.orientechnologies.teleporter.importengine.rdbms.dbengine.OMysqlQueryBuilder;
import com.orientechnologies.teleporter.importengine.rdbms.dbengine.OPostgreSQLQueryBuilder;
import com.orientechnologies.teleporter.importengine.rdbms.dbengine.OQueryBuilder;

public class OQueryBuilderFactory {
    public OQueryBuilder buildQueryBuilder(String driver) {
        OCommonQueryBuilder queryBuilder;
        switch (driver) {
            case "oracle.jdbc.driver.OracleDriver": {
                queryBuilder = new OCommonQueryBuilder();
                break;
            }
            case "com.microsoft.sqlserver.jdbc.SQLServerDriver": {
                queryBuilder = new OCommonQueryBuilder();
                break;
            }
            case "com.mysql.jdbc.Driver": {
                queryBuilder = new OMysqlQueryBuilder();
                break;
            }
            case "org.postgresql.Driver": {
                queryBuilder = new OPostgreSQLQueryBuilder();
                break;
            }
            case "org.hsqldb.jdbc.JDBCDriver": {
                queryBuilder = new OCommonQueryBuilder();
                break;
            }
            default: {
                queryBuilder = new OCommonQueryBuilder();
                OTeleporterContext.getInstance().getStatistics().warningMessages.add("Driver " + driver + " is not completely supported, the common query builder will be adopted for the case-sensitive queries. Thus problems may occur during the querying.");
            }
        }
        return queryBuilder;
    }
}

