/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.factory;

import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.exception.OTeleporterIOException;
import com.orientechnologies.teleporter.strategy.OWorkflowStrategy;
import com.orientechnologies.teleporter.strategy.rdbms.ODBMSModelBuildingAggregationStrategy;
import com.orientechnologies.teleporter.strategy.rdbms.ODBMSNaiveAggregationStrategy;
import com.orientechnologies.teleporter.strategy.rdbms.ODBMSNaiveStrategy;
import com.orientechnologies.teleporter.strategy.rdbms.ODBMSSimpleModelBuildingStrategy;

public class OStrategyFactory {
    public OWorkflowStrategy buildStrategy(String storageDriver, String chosenStrategy) throws OTeleporterIOException {
        OWorkflowStrategy strategy = null;
        if (chosenStrategy == null) {
            strategy = new ODBMSNaiveAggregationStrategy();
        } else {
            switch (chosenStrategy) {
                case "naive": {
                    strategy = new ODBMSNaiveStrategy();
                    break;
                }
                case "naive-aggregate": {
                    strategy = new ODBMSNaiveAggregationStrategy();
                    break;
                }
                case "interactive": {
                    strategy = new ODBMSSimpleModelBuildingStrategy();
                    break;
                }
                case "interactive-aggr": {
                    strategy = new ODBMSModelBuildingAggregationStrategy();
                    break;
                }
                default: {
                    OTeleporterContext.getInstance().getOutputManager().error("The typed strategy doesn't exist for migration from the chosen RDBMS.\n");
                }
            }
            OTeleporterContext.getInstance().setExecutionStrategy(chosenStrategy);
        }
        if (strategy == null) {
            throw new OTeleporterIOException("Strategy not available for the chosen source.");
        }
        return strategy;
    }
}

