/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.http.handler;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.server.OServer;
import com.orientechnologies.teleporter.context.OOutputStreamManager;
import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.http.handler.OTeleporterJob;
import com.orientechnologies.teleporter.http.handler.OTeleporterListener;
import com.orientechnologies.teleporter.util.ODriverConfigurator;
import com.orientechnologies.teleporter.util.OMigrationConfigManager;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class OTeleporterHandler {
    private ExecutorService pool = Executors.newFixedThreadPool(1);
    OTeleporterJob currentJob = null;

    public ODocument execute(ODocument args, OServer currentServerInstance) throws Exception {
        OTeleporterJob job = new OTeleporterJob(args, currentServerInstance, new OTeleporterListener(){

            @Override
            public void onEnd(OTeleporterJob oTeleporterJob) {
                OTeleporterHandler.this.currentJob = null;
            }
        });
        job.validate();
        this.currentJob = job;
        Future<ODocument> future = this.pool.submit(job);
        ODocument executionResult = null;
        executionResult = future.get();
        return executionResult;
    }

    public void checkConnection(ODocument args) throws Exception {
        ODriverConfigurator configurator = new ODriverConfigurator();
        String driver = (String)args.field("driver");
        String jurl = (String)args.field("jurl");
        String username = (String)args.field("username");
        String password = (String)args.field("password");
        OTeleporterContext.getInstance().setOutputManager(new OOutputStreamManager(2));
        configurator.checkConnection(driver, jurl, username, password);
    }

    public ODocument status() {
        ODocument status = new ODocument();
        ArrayList<ODocument> jobs = new ArrayList<ODocument>();
        if (this.currentJob != null) {
            jobs.add(this.currentJob.status());
        }
        status.field("jobs", jobs);
        return status;
    }

    public ODocument getTables(ODocument params) throws Exception {
        ODriverConfigurator configurator = new ODriverConfigurator();
        ArrayList<ODocument> tables = new ArrayList<ODocument>();
        String driver = (String)params.field("driver");
        String uri = (String)params.field("jurl");
        String username = (String)params.field("username");
        String password = (String)params.field("password");
        OTeleporterContext.getInstance().setOutputManager(new OOutputStreamManager(2));
        configurator.checkDriverConfiguration(driver);
        Connection connection = configurator.getDBMSConnection(driver, uri, username, password);
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        String[] tableTypes = new String[]{"TABLE"};
        ResultSet resultTable = databaseMetaData.getTables(null, null, null, tableTypes);
        int id = 1;
        while (resultTable.next()) {
            String tableName = resultTable.getString("TABLE_NAME");
            ODocument currentTable = new ODocument();
            currentTable.field("id", (Object)id);
            currentTable.field("tableName", (Object)tableName);
            tables.add(currentTable);
            ++id;
        }
        resultTable.close();
        ODocument result = new ODocument();
        result.field("tables", tables);
        return result;
    }

    public void saveConfiguration(ODocument args, OServer server) throws Exception {
        String outDbName = (String)args.field("outDBName");
        String migrationConfig = (String)args.field("migrationConfig");
        if (migrationConfig == null) {
            throw new IllegalArgumentException("Migration config is null.");
        }
        if (outDbName == null) {
            throw new IllegalArgumentException("target database name is null.");
        }
        String serverDatabaseDirectory = server.getDatabaseDirectory();
        String outDbUrl = serverDatabaseDirectory + outDbName;
        OMigrationConfigManager.writeConfigurationInTargetDB(migrationConfig, outDbUrl);
    }
}

