/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.importengine.rdbms.dbengine;

import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.factory.OQueryBuilderFactory;
import com.orientechnologies.teleporter.importengine.ODataSourceQueryEngine;
import com.orientechnologies.teleporter.importengine.rdbms.dbengine.OQueryBuilder;
import com.orientechnologies.teleporter.model.dbschema.OEntity;
import com.orientechnologies.teleporter.model.dbschema.OHierarchicalBag;
import com.orientechnologies.teleporter.model.dbschema.OSourceDatabaseInfo;
import com.orientechnologies.teleporter.persistence.util.ODBSourceConnection;
import com.orientechnologies.teleporter.persistence.util.OQueryResult;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

public class ODBQueryEngine
implements ODataSourceQueryEngine {
    private OQueryBuilderFactory queryBuilderFactory = new OQueryBuilderFactory();
    private OQueryBuilder queryBuilder;

    public ODBQueryEngine(String driver) {
        this.queryBuilder = this.queryBuilderFactory.buildQueryBuilder(driver);
    }

    public OQueryResult countTableRecords(OSourceDatabaseInfo sourceDBInfo, String currentTableName, String currentTableSchema) {
        String query = this.queryBuilder.countTableRecords(currentTableName, currentTableSchema);
        return this.executeQuery(query, sourceDBInfo);
    }

    public OQueryResult getRecordById(OEntity entity, String[] propertyOfKey, String[] valueOfKey) {
        OSourceDatabaseInfo sourceDBInfo = entity.getSourceDataseInfo();
        String query = this.queryBuilder.getRecordById(entity, propertyOfKey, valueOfKey);
        return this.executeQuery(query, sourceDBInfo);
    }

    public OQueryResult getRecordsByEntity(OEntity entity) {
        OSourceDatabaseInfo sourceDBInfo = entity.getSourceDataseInfo();
        String query = this.queryBuilder.getRecordsByEntity(entity);
        return this.executeQuery(query, sourceDBInfo);
    }

    public OQueryResult getRecordsFromMultipleEntities(List<OEntity> mappedEntities, String[][] columns) {
        OSourceDatabaseInfo sourceDBInfo = mappedEntities.get(0).getSourceDataseInfo();
        String query = this.queryBuilder.getRecordsFromMultipleEntities(mappedEntities, columns);
        return this.executeQuery(query, sourceDBInfo);
    }

    public OQueryResult getRecordsFromSingleTableByDiscriminatorValue(String discriminatorColumn, String currentDiscriminatorValue, OEntity entity) {
        OSourceDatabaseInfo sourceDBInfo = entity.getSourceDataseInfo();
        String query = this.queryBuilder.getRecordsFromSingleTableByDiscriminatorValue(discriminatorColumn, currentDiscriminatorValue, entity);
        return this.executeQuery(query, sourceDBInfo);
    }

    public OQueryResult getEntityTypeFromSingleTable(String discriminatorColumn, OEntity entity, String[] propertyOfKey, String[] valueOfKey) {
        OSourceDatabaseInfo sourceDBInfo = entity.getSourceDataseInfo();
        String query = this.queryBuilder.getEntityTypeFromSingleTable(discriminatorColumn, entity, propertyOfKey, valueOfKey);
        return this.executeQuery(query, sourceDBInfo);
    }

    public OQueryResult buildAggregateTableFromHierarchicalBag(OHierarchicalBag bag) {
        OSourceDatabaseInfo sourceDBInfo = bag.getSourceDataseInfo();
        String query = this.queryBuilder.buildAggregateTableFromHierarchicalBag(bag);
        return this.executeQuery(query, sourceDBInfo);
    }

    public OQueryResult executeQuery(String query, OSourceDatabaseInfo sourceDBInfo) {
        ResultSet result = null;
        Connection dbConnection = null;
        Statement statement = null;
        try {
            try {
                dbConnection = ODBSourceConnection.getConnection(sourceDBInfo);
            }
            catch (Exception e) {
                String mess = "";
                OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
                OTeleporterContext.getInstance().printExceptionStackTrace(e, "debug");
            }
            statement = dbConnection.createStatement(1003, 1007);
            result = statement.executeQuery(query);
        }
        catch (SQLException e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "debug");
        }
        OQueryResult queryResult = new OQueryResult(dbConnection, statement, result);
        return queryResult;
    }
}

