/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.model.dbschema;

import com.orientechnologies.teleporter.model.dbschema.OAttribute;
import com.orientechnologies.teleporter.model.dbschema.OEntity;
import com.orientechnologies.teleporter.model.dbschema.OForeignKey;
import com.orientechnologies.teleporter.model.dbschema.OPrimaryKey;
import com.orientechnologies.teleporter.model.dbschema.ORelationship;
import java.util.List;

public class OCanonicalRelationship
extends ORelationship {
    private OForeignKey foreignKey;
    private OPrimaryKey primaryKey;

    public OCanonicalRelationship(OEntity foreignEntity, OEntity parentEntity) {
        this.foreignEntity = foreignEntity;
        this.parentEntity = parentEntity;
        this.direction = "direct";
    }

    public OCanonicalRelationship(OEntity foreignEntity, OEntity parentEntity, OForeignKey foreignKey, OPrimaryKey primaryKey) {
        this.foreignEntity = foreignEntity;
        this.parentEntity = parentEntity;
        this.foreignKey = foreignKey;
        this.primaryKey = primaryKey;
        this.direction = "direct";
    }

    @Override
    public List<OAttribute> getFromColumns() {
        return this.foreignKey.getInvolvedAttributes();
    }

    @Override
    public List<OAttribute> getToColumns() {
        return this.primaryKey.getInvolvedAttributes();
    }

    public OForeignKey getForeignKey() {
        return this.foreignKey;
    }

    public void setForeignKey(OForeignKey foreignKey) {
        this.foreignKey = foreignKey;
    }

    public OPrimaryKey getPrimaryKey() {
        return this.primaryKey;
    }

    public void setPrimaryKey(OPrimaryKey primaryKey) {
        this.primaryKey = primaryKey;
    }

    public boolean equals(Object obj) {
        OCanonicalRelationship that = (OCanonicalRelationship)obj;
        return this.foreignEntity.equals(that.getForeignEntity()) && this.parentEntity.equals(that.getParentEntity()) && this.foreignKey.equals(that.getForeignKey()) && this.primaryKey.equals(that.getPrimaryKey());
    }

    public String toString() {
        return "OCanonicalRelationship [foreignEntity=" + this.foreignEntity.getName() + ", parentEntity=" + this.parentEntity.getName() + ", Foreign key=" + this.foreignKey.toString() + ", Primary key=" + this.primaryKey.toString() + "]";
    }
}

