/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.model.dbschema;

import com.orientechnologies.teleporter.model.dbschema.OEntity;
import com.orientechnologies.teleporter.model.dbschema.OSourceDatabaseInfo;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;

public class OHierarchicalBag {
    private Map<Integer, Set<OEntity>> depth2entities;
    private String inheritancePattern;
    private String discriminatorColumn;
    private Map<String, String> entityName2discriminatorValue;

    public OHierarchicalBag() {
        this.depth2entities = new LinkedHashMap<Integer, Set<OEntity>>();
        this.entityName2discriminatorValue = new HashMap<String, String>();
    }

    public OHierarchicalBag(String inheritancePattern) {
        this.inheritancePattern = inheritancePattern;
        this.depth2entities = new HashMap<Integer, Set<OEntity>>();
        this.entityName2discriminatorValue = new HashMap<String, String>();
    }

    public Map<Integer, Set<OEntity>> getDepth2entities() {
        return this.depth2entities;
    }

    public void setDepth2entities(Map<Integer, Set<OEntity>> depth2entities) {
        this.depth2entities = depth2entities;
    }

    public String getInheritancePattern() {
        return this.inheritancePattern;
    }

    public void setInheritancePattern(String inheritancePattern) {
        this.inheritancePattern = inheritancePattern;
    }

    public String getDiscriminatorColumn() {
        return this.discriminatorColumn;
    }

    public void setDiscriminatorColumn(String discriminatorColumn) {
        this.discriminatorColumn = discriminatorColumn;
    }

    public Map<String, String> getEntityName2discriminatorValue() {
        return this.entityName2discriminatorValue;
    }

    public void setEntityName2discriminatorValue(Map<String, String> entityName2discriminatorValue) {
        this.entityName2discriminatorValue = entityName2discriminatorValue;
    }

    public int hashCode() {
        Iterator<OEntity> it = this.getDepth2entities().get(0).iterator();
        OEntity rootEntity = it.next();
        int prime = 31;
        int result = 1;
        result = 31 * result + (rootEntity == null ? 0 : rootEntity.getName().hashCode());
        result = 31 * result + (this.inheritancePattern == null ? 0 : this.inheritancePattern.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        OHierarchicalBag that = (OHierarchicalBag)obj;
        Iterator<OEntity> it = this.getDepth2entities().get(0).iterator();
        OEntity rootEntity = it.next();
        it = that.getDepth2entities().get(0).iterator();
        OEntity thatRootEntity = it.next();
        return this.inheritancePattern.equals(that.getInheritancePattern()) && rootEntity.getName().equals(thatRootEntity.getName());
    }

    public OSourceDatabaseInfo getSourceDataseInfo() {
        Set<OEntity> entities = this.getDepth2entities().get(0);
        Iterator<OEntity> it = entities.iterator();
        if (it.hasNext()) {
            return it.next().getSourceDataseInfo();
        }
        return null;
    }
}

