/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.model.graphmodel;

import com.orientechnologies.teleporter.model.graphmodel.OModelProperty;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class OElementType
implements Comparable<OElementType> {
    protected String name;
    protected List<OModelProperty> properties;
    protected List<OModelProperty> inheritedProperties;
    protected Set<OModelProperty> allProperties;
    protected OElementType parentType;
    protected int inheritanceLevel;

    public OElementType(String type) {
        this.name = type;
        this.properties = new LinkedList<OModelProperty>();
        this.inheritedProperties = new LinkedList<OModelProperty>();
        this.allProperties = null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String type) {
        this.name = type;
    }

    public List<OModelProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<OModelProperty> properties) {
        this.properties = properties;
    }

    public List<OModelProperty> getInheritedProperties() {
        return this.inheritedProperties;
    }

    public void setInheritedProperties(List<OModelProperty> inheritedProperties) {
        this.inheritedProperties = inheritedProperties;
    }

    public OElementType getParentType() {
        return this.parentType;
    }

    public void setParentType(OElementType parentType) {
        this.parentType = parentType;
    }

    public int getInheritanceLevel() {
        return this.inheritanceLevel;
    }

    public void setInheritanceLevel(int inheritanceLevel) {
        this.inheritanceLevel = inheritanceLevel;
    }

    public OModelProperty getPropertyByOrdinalPosition(int position) {
        for (OModelProperty property : this.properties) {
            if (property.getOrdinalPosition() != position) continue;
            return property;
        }
        return null;
    }

    public void removePropertyByName(String toRemove) {
        Iterator<OModelProperty> it = this.properties.iterator();
        OModelProperty currentProperty = null;
        while (it.hasNext()) {
            currentProperty = it.next();
            if (!currentProperty.getName().equals(toRemove)) continue;
            it.remove();
        }
    }

    public OModelProperty getPropertyByName(String name) {
        for (OModelProperty property : this.properties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public OModelProperty getInheritedPropertyByName(String name) {
        for (OModelProperty property : this.inheritedProperties) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public OModelProperty getPropertyByNameAmongAll(String name) {
        for (OModelProperty property : this.getAllProperties()) {
            if (!property.getName().equals(name)) continue;
            return property;
        }
        return null;
    }

    public Set<OModelProperty> getAllProperties() {
        if (this.allProperties == null) {
            this.allProperties = new LinkedHashSet<OModelProperty>();
            this.allProperties.addAll(this.inheritedProperties);
            this.allProperties.addAll(this.properties);
        }
        return this.allProperties;
    }

    @Override
    public int compareTo(OElementType toCompare) {
        if (this.inheritanceLevel > toCompare.getInheritanceLevel()) {
            return 1;
        }
        if (this.inheritanceLevel < toCompare.getInheritanceLevel()) {
            return -1;
        }
        return this.name.compareTo(toCompare.getName());
    }
}

