/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.model.graphmodel;

import com.orientechnologies.teleporter.model.graphmodel.OEdgeType;
import com.orientechnologies.teleporter.model.graphmodel.OElementType;
import com.orientechnologies.teleporter.model.graphmodel.OModelProperty;
import com.tinkerpop.blueprints.Direction;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class OVertexType
extends OElementType {
    private List<OEdgeType> inEdgesType = new ArrayList<OEdgeType>();
    private List<OEdgeType> outEdgesType = new ArrayList<OEdgeType>();
    private boolean isFromJoinTable;
    private Set<String> externalKey = new LinkedHashSet<String>();
    private boolean analyzedInLastMigration = false;

    public OVertexType(String vertexType) {
        super(vertexType);
    }

    public List<OEdgeType> getInEdgesType() {
        return this.inEdgesType;
    }

    public void setInEdgesType(List<OEdgeType> inEdgesType) {
        this.inEdgesType = inEdgesType;
    }

    public List<OEdgeType> getOutEdgesType() {
        return this.outEdgesType;
    }

    public void setOutEdgesType(List<OEdgeType> outEdgesType) {
        this.outEdgesType = outEdgesType;
    }

    public void setFromJoinTable(boolean fromJoinTable) {
        this.isFromJoinTable = fromJoinTable;
    }

    public Set<String> getExternalKey() {
        return this.externalKey;
    }

    public void setExternalKey(Set<String> externalKey) {
        this.externalKey = externalKey;
    }

    public boolean isAnalyzedInLastMigration() {
        return this.analyzedInLastMigration;
    }

    public void setAnalyzedInLastMigration(boolean analyzedInLastMigration) {
        this.analyzedInLastMigration = analyzedInLastMigration;
    }

    public OEdgeType getEdgeByName(String edgeName) {
        for (OEdgeType currentEdgeType : this.inEdgesType) {
            if (!currentEdgeType.getName().equals(edgeName)) continue;
            return currentEdgeType;
        }
        for (OEdgeType currentEdgeType : this.outEdgesType) {
            if (!currentEdgeType.getName().equals(edgeName)) continue;
            return currentEdgeType;
        }
        return null;
    }

    public OEdgeType getEdgeByName(String name, Direction direction) {
        if (direction.equals((Object)Direction.IN)) {
            for (OEdgeType currentEdgeType : this.inEdgesType) {
                if (!currentEdgeType.getName().equals(name)) continue;
                return currentEdgeType;
            }
        } else if (direction.equals((Object)Direction.OUT)) {
            for (OEdgeType currentEdgeType : this.outEdgesType) {
                if (!currentEdgeType.getName().equals(name)) continue;
                return currentEdgeType;
            }
        } else if (direction.equals((Object)Direction.BOTH)) {
            return this.getEdgeByName(name);
        }
        return null;
    }

    public boolean isFromJoinTable() {
        return this.isFromJoinTable;
    }

    public void setIsFromJoinTable(boolean isFromJoinTable) {
        this.isFromJoinTable = isFromJoinTable;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        OVertexType that = (OVertexType)obj;
        if (!this.name.equals(that.getName()) || this.isFromJoinTable != that.isFromJoinTable()) {
            return false;
        }
        if (!this.properties.equals(that.getProperties())) {
            return false;
        }
        return this.inEdgesType.equals(that.getInEdgesType()) && this.outEdgesType.equals(that.getOutEdgesType());
    }

    public String toString() {
        String s = "Vertex-type [type = " + this.name + ", # attributes = " + this.properties.size() + ", # inEdges: " + this.inEdgesType.size() + ", # outEdges: " + this.outEdgesType.size() + "]\nAttributes:\n";
        for (OModelProperty currentProperty : this.properties) {
            s = s + currentProperty.getOrdinalPosition() + ": " + currentProperty.getName() + " --> " + currentProperty.toString();
            if (currentProperty.isFromPrimaryKey()) {
                s = s + "(from PK)";
            }
            s = s + "\t";
        }
        return s;
    }
}

