/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.persistence.util;

import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.exception.OTeleporterRuntimeException;
import com.orientechnologies.teleporter.model.dbschema.OSourceDatabaseInfo;
import com.orientechnologies.teleporter.persistence.util.ODriverShim;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;

public class ODBSourceConnection {
    public static Connection getConnection(OSourceDatabaseInfo sourceDBInfo) {
        Connection connection = null;
        String driver = sourceDBInfo.getDriverName();
        String uri = sourceDBInfo.getUrl();
        String username = sourceDBInfo.getUsername();
        String password = sourceDBInfo.getPassword();
        try {
            URL u = new URL("jar:file:" + OTeleporterContext.getInstance().getDriverDependencyPath() + "!/");
            URLClassLoader ucl = new URLClassLoader(new URL[]{u});
            Driver d = (Driver)Class.forName(driver, true, ucl).newInstance();
            DriverManager.registerDriver(new ODriverShim(d));
            connection = DriverManager.getConnection(uri, username, password);
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        return connection;
    }

    public static Connection getConnection(String driver, String uri, String username, String password) {
        Connection connection = null;
        try {
            URL u = new URL("jar:file:" + OTeleporterContext.getInstance().getDriverDependencyPath() + "!/");
            URLClassLoader ucl = new URLClassLoader(new URL[]{u});
            Driver d = (Driver)Class.forName(driver, true, ucl).newInstance();
            DriverManager.registerDriver(new ODriverShim(d));
            connection = DriverManager.getConnection(uri, username, password);
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        return connection;
    }
}

