/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.persistence.util;

import com.orientechnologies.teleporter.context.OTeleporterContext;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class OQueryResult {
    private Connection dbConnection;
    private Statement statement;
    private ResultSet result;

    public OQueryResult(Connection connection, Statement statement, ResultSet result) {
        this.dbConnection = connection;
        this.statement = statement;
        this.result = result;
    }

    public Connection getDbConnection() {
        return this.dbConnection;
    }

    public void setDbConnection(Connection dbConnection) {
        this.dbConnection = dbConnection;
    }

    public Statement getStatement() {
        return this.statement;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public ResultSet getResult() {
        return this.result;
    }

    public void setResult(ResultSet result) {
        this.result = result;
    }

    public void closeAll() {
        try {
            if (this.statement != null && !this.statement.isClosed()) {
                this.statement.close();
            }
            if (this.result != null && !this.result.isClosed()) {
                this.result.close();
            }
            if (this.dbConnection != null && !this.dbConnection.isClosed()) {
                this.dbConnection.close();
            }
        }
        catch (SQLException e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "debug");
        }
    }

    public boolean isConnectionClosed(OTeleporterContext context) {
        try {
            if (this.dbConnection != null) {
                return this.dbConnection.isClosed();
            }
        }
        catch (Exception e) {
            String mess = "";
            context.printExceptionMessage(e, mess, "error");
            context.printExceptionStackTrace(e, "debug");
        }
        return false;
    }

    public boolean isStatementClosed(OTeleporterContext context) {
        try {
            if (this.statement != null) {
                return this.statement.isClosed();
            }
        }
        catch (Exception e) {
            String mess = "";
            context.printExceptionMessage(e, mess, "error");
            context.printExceptionStackTrace(e, "debug");
        }
        return false;
    }

    public boolean isResultSetClosed(OTeleporterContext context) {
        try {
            if (this.result != null) {
                return this.result.isClosed();
            }
        }
        catch (Exception e) {
            String mess = "";
            context.printExceptionMessage(e, mess, "error");
            context.printExceptionStackTrace(e, "debug");
        }
        return false;
    }

    public boolean isAllClosed(OTeleporterContext context) {
        return this.isConnectionClosed(context) && this.isStatementClosed(context) && this.isResultSetClosed(context);
    }
}

