/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.strategy.rdbms;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.teleporter.configuration.OConfigurationHandler;
import com.orientechnologies.teleporter.configuration.api.OConfiguration;
import com.orientechnologies.teleporter.configuration.api.OConfiguredVertexClass;
import com.orientechnologies.teleporter.configuration.api.OSourceTable;
import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.context.OTeleporterStatistics;
import com.orientechnologies.teleporter.exception.OTeleporterRuntimeException;
import com.orientechnologies.teleporter.factory.ODataTypeHandlerFactory;
import com.orientechnologies.teleporter.factory.ONameResolverFactory;
import com.orientechnologies.teleporter.importengine.rdbms.dbengine.ODBQueryEngine;
import com.orientechnologies.teleporter.importengine.rdbms.graphengine.OGraphEngineForDB;
import com.orientechnologies.teleporter.mapper.OSource2GraphMapper;
import com.orientechnologies.teleporter.mapper.rdbms.OER2GraphMapper;
import com.orientechnologies.teleporter.mapper.rdbms.classmapper.OEEClassMapper;
import com.orientechnologies.teleporter.model.OSourceInfo;
import com.orientechnologies.teleporter.model.dbschema.OAttribute;
import com.orientechnologies.teleporter.model.dbschema.OCanonicalRelationship;
import com.orientechnologies.teleporter.model.dbschema.OEntity;
import com.orientechnologies.teleporter.model.dbschema.OHierarchicalBag;
import com.orientechnologies.teleporter.model.dbschema.ORelationship;
import com.orientechnologies.teleporter.model.dbschema.OSourceDatabaseInfo;
import com.orientechnologies.teleporter.model.graphmodel.OEdgeType;
import com.orientechnologies.teleporter.model.graphmodel.OModelProperty;
import com.orientechnologies.teleporter.model.graphmodel.OVertexType;
import com.orientechnologies.teleporter.nameresolver.ONameResolver;
import com.orientechnologies.teleporter.persistence.handler.ODBMSDataTypeHandler;
import com.orientechnologies.teleporter.persistence.util.OQueryResult;
import com.orientechnologies.teleporter.strategy.OWorkflowStrategy;
import com.orientechnologies.teleporter.util.OFunctionsHandler;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientVertex;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;

public abstract class OAbstractDBMSImportStrategy
implements OWorkflowStrategy {
    protected OER2GraphMapper mapper;

    @Override
    public ODocument executeStrategy(OSourceInfo sourceInfo, String outOrientGraphUri, String chosenMapper, String xmlPath, String nameResolverConvention, List<String> includedTables, List<String> excludedTables, ODocument migrationConfigDoc) {
        OSourceDatabaseInfo sourceDBInfo = (OSourceDatabaseInfo)sourceInfo;
        Date globalStart = new Date();
        ODataTypeHandlerFactory dataTypeHandlerFactory = new ODataTypeHandlerFactory();
        ODBMSDataTypeHandler handler = (ODBMSDataTypeHandler)dataTypeHandlerFactory.buildDataTypeHandler(sourceDBInfo.getDriverName());
        OConfigurationHandler configurationHandler = this.buildConfigurationHandler();
        boolean keepVerticesCoordinates = true;
        OConfiguration migrationConfig = null;
        if (migrationConfigDoc != null) {
            if (includedTables != null && includedTables.size() > 0) {
                configurationHandler.filterAccordingToWhiteList(migrationConfigDoc, includedTables);
            } else if (excludedTables != null && excludedTables.size() > 0) {
                configurationHandler.filterAccordingToBlackList(migrationConfigDoc, excludedTables);
            }
            migrationConfig = configurationHandler.buildConfigurationFromJSONDoc(migrationConfigDoc, keepVerticesCoordinates);
        }
        ONameResolverFactory nameResolverFactory = new ONameResolverFactory();
        ONameResolver nameResolver = nameResolverFactory.buildNameResolver(nameResolverConvention);
        OTeleporterContext.getInstance().getStatistics().runningStepNumber = -1;
        this.mapper = this.createSchemaMapper(sourceDBInfo, outOrientGraphUri, chosenMapper, xmlPath, nameResolver, handler, includedTables, excludedTables, migrationConfig);
        this.executeImport(sourceDBInfo, outOrientGraphUri, this.mapper, handler);
        OTeleporterContext.getInstance().getStatistics().notifyListeners();
        OTeleporterContext.getInstance().getOutputManager().info("\n");
        OTeleporterContext.getInstance().getStatistics().runningStepNumber = -1;
        Date globalEnd = new Date();
        OTeleporterContext.getInstance().getOutputManager().info("\n\nImporting complete in %s\n", OFunctionsHandler.getHMSFormat(globalStart, globalEnd));
        OTeleporterContext.getInstance().getOutputManager().info(OTeleporterContext.getInstance().getStatistics().toString());
        OConfiguration configuredGraph = configurationHandler.buildConfigurationFromMapper(this.mapper);
        ODocument configuredGraphDoc = configurationHandler.buildJSONDocFromConfiguration(configuredGraph);
        return configuredGraphDoc;
    }

    protected abstract OConfigurationHandler buildConfigurationHandler();

    public abstract OER2GraphMapper createSchemaMapper(OSourceDatabaseInfo var1, String var2, String var3, String var4, ONameResolver var5, ODBMSDataTypeHandler var6, List<String> var7, List<String> var8, OConfiguration var9);

    public abstract void executeImport(OSourceDatabaseInfo var1, String var2, OSource2GraphMapper var3, ODBMSDataTypeHandler var4);

    protected void importRecordsFromEntitiesIntoVertexClass(List<OEntity> mappedEntities, String[][] aggregationColumns, OVertexType currentOutVertexType, ODBQueryEngine dbQueryEngine, OGraphEngineForDB graphEngine, OrientBaseGraph orientGraph) throws SQLException {
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        int numberOfAggregatedClasses = mappedEntities.size();
        OQueryResult queryResult = numberOfAggregatedClasses == 1 ? dbQueryEngine.getRecordsByEntity(mappedEntities.get(0)) : dbQueryEngine.getRecordsFromMultipleEntities(mappedEntities, aggregationColumns);
        ResultSet records = queryResult.getResult();
        ResultSet currentRecord = null;
        while (records.next()) {
            currentRecord = records;
            OrientVertex currentOutVertex = (OrientVertex)graphEngine.upsertVisitedVertex(orientGraph, currentRecord, currentOutVertexType, currentOutVertexType.getExternalKey());
            this.navigateRelationshipsAndInsertReachableVertices(orientGraph, graphEngine, mappedEntities, currentRecord, currentOutVertexType, currentOutVertex);
            statistics.analyzedRecords += 1 * numberOfAggregatedClasses;
        }
        queryResult.closeAll();
        currentOutVertexType.setAnalyzedInLastMigration(true);
    }

    private void navigateRelationshipsAndInsertReachableVertices(OrientBaseGraph orientGraph, OGraphEngineForDB graphEngine, List<OEntity> mappedEntities, ResultSet currentRecord, OVertexType outVertexType, OrientVertex outVertex) throws SQLException {
        for (OEntity entity : mappedEntities) {
            for (OCanonicalRelationship currentRelationship : entity.getOutCanonicalRelationships()) {
                OEntity currentParentEntity = this.mapper.getDataBaseSchema().getEntityByName(currentRelationship.getParentEntity().getName());
                OVertexType currentInVertexType = this.mapper.getVertexTypeByEntityAndRelationship(currentParentEntity, currentRelationship);
                OEdgeType edgeType = this.mapper.getRelationship2edgeType().get(currentRelationship);
                graphEngine.upsertReachedVertexWithEdge(orientGraph, currentRecord, currentRelationship, outVertex, currentInVertexType, edgeType.getName());
            }
        }
    }

    public void importRecordsFromSplitEntityIntoVertexClasses(List<OEntity> mappedEntities, List<OVertexType> mappedVertices, ODBQueryEngine dbQueryEngine, OGraphEngineForDB graphEngine, OrientBaseGraph orientGraph) throws SQLException {
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        OEntity entity = mappedEntities.get(0);
        OQueryResult queryResult = dbQueryEngine.getRecordsByEntity(entity);
        ResultSet records = queryResult.getResult();
        ResultSet currentRecord = null;
        while (records.next()) {
            int numberOfVertices;
            currentRecord = records;
            LinkedHashMap<String, OrientVertex> className2insertedVertex = new LinkedHashMap<String, OrientVertex>();
            for (OVertexType currentVertexType : mappedVertices) {
                OrientVertex currentOutVertex = (OrientVertex)graphEngine.upsertVisitedVertex(orientGraph, currentRecord, currentVertexType, currentVertexType.getExternalKey());
                boolean navigate = false;
                for (ORelationship oRelationship : entity.getAllOutCanonicalRelationships()) {
                    OEdgeType currEdgeType = this.mapper.getRelationship2edgeType().get(oRelationship);
                    if (currEdgeType == null) continue;
                    if (oRelationship.getDirection().equals("direct") && currentVertexType.getOutEdgesType().contains(currEdgeType)) {
                        navigate = true;
                        break;
                    }
                    if (!oRelationship.getDirection().equals("inverse") || !currentVertexType.getInEdgesType().contains(currEdgeType)) continue;
                    navigate = true;
                    break;
                }
                if (navigate) {
                    this.navigateRelationshipsAndInsertReachableVertices(orientGraph, graphEngine, mappedEntities, currentRecord, currentVertexType, currentOutVertex);
                }
                className2insertedVertex.put(currentVertexType.getName(), currentOutVertex);
            }
            List<OEEClassMapper> classMappers = this.mapper.getEEClassMappersByEntity(entity);
            int numberOfEdges = classMappers.size();
            if (numberOfEdges != (numberOfVertices = mappedVertices.size()) - 1) {
                OTeleporterContext.getInstance().getOutputManager().error("There are %s edges-type and %s vertices-type detected for the split entity %s. For a correct splitting you must have: total number of edges = number of mapped vertices -1.", numberOfEdges, numberOfVertices, entity.getName());
                throw new OTeleporterRuntimeException();
            }
            for (OEEClassMapper classMapper : classMappers) {
                OEdgeType oEdgeType = classMapper.getEdgeType();
                String currentOutVertexName = oEdgeType.getOutVertexType().getName();
                String currentInVertexName = oEdgeType.getInVertexType().getName();
                OrientVertex currentOutVertex = (OrientVertex)className2insertedVertex.get(currentOutVertexName);
                OrientVertex currentInVertex = (OrientVertex)className2insertedVertex.get(currentInVertexName);
                LinkedHashMap<String, Object> properties = new LinkedHashMap<String, Object>();
                for (OModelProperty currentProperty : oEdgeType.getAllProperties()) {
                    if (!currentProperty.isIncludedInMigration()) continue;
                    String currentPropertyName = currentProperty.getName();
                    String currentPropertyType = OTeleporterContext.getInstance().getDataTypeHandler().resolveType(currentProperty.getOriginalType().toLowerCase(Locale.ENGLISH)).toString();
                    String currentOriginalType = currentProperty.getOriginalType();
                    try {
                        graphEngine.extractPropertiesFromRecordIntoEdge(currentRecord, properties, currentPropertyType, currentPropertyName, currentOriginalType, oEdgeType);
                    }
                    catch (Exception e) {
                        String mess = "Problem encountered during the extraction of the values from the records. Edge Type: " + oEdgeType.getName() + ";\tProperty: " + currentPropertyName;
                        OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
                        OTeleporterContext.getInstance().printExceptionStackTrace(e, "debug");
                    }
                }
                graphEngine.upsertEdge(orientGraph, currentOutVertex, currentInVertex, oEdgeType.getName(), properties, "direct");
            }
            ++statistics.analyzedRecords;
        }
        queryResult.closeAll();
        for (OVertexType currentVertexType : mappedVertices) {
            currentVertexType.setAnalyzedInLastMigration(true);
        }
    }

    protected void importEntitiesBelongingToHierarchies(ODBQueryEngine dbQueryEngine, OGraphEngineForDB graphEngine, OrientBaseGraph orientGraph) {
        for (OHierarchicalBag bag : this.mapper.getDataBaseSchema().getHierarchicalBags()) {
            switch (bag.getInheritancePattern()) {
                case "table-per-hierarchy": {
                    this.tablePerHierarchyImport(bag, this.mapper, dbQueryEngine, graphEngine, orientGraph);
                    break;
                }
                case "table-per-type": {
                    this.tablePerTypeImport(bag, this.mapper, dbQueryEngine, graphEngine, orientGraph);
                    break;
                }
                case "table-per-concrete-type": {
                    this.tablePerConcreteTypeImport(bag, this.mapper, dbQueryEngine, graphEngine, orientGraph);
                }
            }
        }
    }

    protected void tablePerHierarchyImport(OHierarchicalBag bag, OER2GraphMapper mapper, ODBQueryEngine dbQueryEngine, OGraphEngineForDB graphDBCommandEngine, OrientBaseGraph orientGraph) {
        try {
            OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
            OEntity currentParentEntity = null;
            OVertexType currentOutVertexType = null;
            OVertexType currentInVertexType = null;
            OrientVertex currentOutVertex = null;
            OEdgeType edgeType = null;
            Iterator<OEntity> it = bag.getDepth2entities().get(0).iterator();
            OEntity physicalCurrentEntity = it.next();
            OQueryResult queryResult = null;
            ResultSet records = null;
            for (int i = bag.getDepth2entities().size() - 1; i >= 0; --i) {
                for (OEntity currentEntity : bag.getDepth2entities().get(i)) {
                    String currentDiscriminatorValue = bag.getEntityName2discriminatorValue().get(currentEntity.getName());
                    queryResult = dbQueryEngine.getRecordsFromSingleTableByDiscriminatorValue(bag.getDiscriminatorColumn(), currentDiscriminatorValue, physicalCurrentEntity);
                    records = queryResult.getResult();
                    ResultSet currentRecord = null;
                    currentOutVertexType = mapper.getVertexTypeByEntity(currentEntity);
                    while (records.next()) {
                        currentRecord = records;
                        currentOutVertex = (OrientVertex)graphDBCommandEngine.upsertVisitedVertex(orientGraph, currentRecord, currentOutVertexType, currentOutVertexType.getExternalKey());
                        for (OCanonicalRelationship currentRelation : currentEntity.getAllOutCanonicalRelationships()) {
                            currentParentEntity = mapper.getDataBaseSchema().getEntityByNameIgnoreCase(currentRelation.getParentEntity().getName());
                            if (currentParentEntity.getHierarchicalBag() == null) {
                                currentInVertexType = mapper.getVertexTypeByEntity(currentRelation.getParentEntity());
                            } else {
                                String[] propertyOfKey = new String[currentRelation.getFromColumns().size()];
                                String[] valueOfKey = new String[currentRelation.getFromColumns().size()];
                                int index = 0;
                                for (OAttribute foreignAttribute : currentRelation.getFromColumns()) {
                                    propertyOfKey[index] = currentRelation.getToColumns().get(index).getName();
                                    valueOfKey[index] = currentRecord.getString(foreignAttribute.getName());
                                    ++index;
                                }
                                boolean ok = true;
                                for (int j = 0; j < valueOfKey.length; ++j) {
                                    if (valueOfKey[j] != null) continue;
                                    ok = false;
                                    break;
                                }
                                if (ok) {
                                    it = currentParentEntity.getHierarchicalBag().getDepth2entities().get(0).iterator();
                                    OEntity physicalArrivalEntity = it.next();
                                    String currentArrivalEntityName = this.searchParentEntityType(currentParentEntity, propertyOfKey, valueOfKey, physicalArrivalEntity, dbQueryEngine);
                                    OEntity currentArrivalEntity = mapper.getDataBaseSchema().getEntityByName(currentArrivalEntityName);
                                    currentInVertexType = mapper.getVertexTypeByEntity(currentArrivalEntity);
                                }
                            }
                            if (currentInVertexType == null) continue;
                            edgeType = mapper.getRelationship2edgeType().get(currentRelation);
                            graphDBCommandEngine.upsertReachedVertexWithEdge(orientGraph, currentRecord, currentRelation, currentOutVertex, currentInVertexType, edgeType.getName());
                        }
                        ++statistics.analyzedRecords;
                    }
                    queryResult.closeAll();
                }
            }
            statistics.notifyListeners();
            statistics.runningStepNumber = -1;
            OTeleporterContext.getInstance().getOutputManager().info("\n");
            currentOutVertexType.setAnalyzedInLastMigration(true);
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
    }

    protected void tablePerTypeImport(OHierarchicalBag bag, OER2GraphMapper mapper, ODBQueryEngine dbQueryEngine, OGraphEngineForDB graphDBCommandEngine, OrientBaseGraph orientGraph) {
        try {
            OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
            ResultSet aggregateTableRecords = null;
            OEntity currentParentEntity = null;
            OVertexType currentOutVertexType = null;
            OVertexType currentInVertexType = null;
            OrientVertex currentOutVertex = null;
            OEdgeType edgeType = null;
            OQueryResult queryResult1 = null;
            OQueryResult queryResult2 = null;
            Iterator<OEntity> it = bag.getDepth2entities().get(0).iterator();
            OEntity rootEntity = it.next();
            for (int i = bag.getDepth2entities().size() - 1; i >= 0; --i) {
                for (OEntity currentEntity : bag.getDepth2entities().get(i)) {
                    queryResult1 = dbQueryEngine.getRecordsByEntity(currentEntity);
                    ResultSet records = queryResult1.getResult();
                    ResultSet currentRecord = null;
                    currentOutVertexType = mapper.getVertexTypeByEntity(currentEntity);
                    while (records.next()) {
                        Set<String> propertiesOfIndex;
                        int k;
                        queryResult2 = dbQueryEngine.buildAggregateTableFromHierarchicalBag(bag);
                        aggregateTableRecords = queryResult2.getResult();
                        currentRecord = records;
                        String[] propertyOfKey = new String[rootEntity.getPrimaryKey().getInvolvedAttributes().size()];
                        String[] valueOfKey = new String[rootEntity.getPrimaryKey().getInvolvedAttributes().size()];
                        String[] aggregateTablePropertyOfKey = new String[rootEntity.getPrimaryKey().getInvolvedAttributes().size()];
                        for (k = 0; k < propertyOfKey.length; ++k) {
                            propertyOfKey[k] = currentEntity.getPrimaryKey().getInvolvedAttributes().get(k).getName();
                        }
                        for (k = 0; k < propertyOfKey.length; ++k) {
                            valueOfKey[k] = currentRecord.getString(propertyOfKey[k]);
                        }
                        for (k = 0; k < aggregateTablePropertyOfKey.length; ++k) {
                            aggregateTablePropertyOfKey[k] = rootEntity.getPrimaryKey().getInvolvedAttributes().get(k).getName();
                        }
                        ResultSet fullRecord = this.getFullRecordByAggregateTable(aggregateTableRecords, aggregateTablePropertyOfKey, valueOfKey);
                        if (!graphDBCommandEngine.alreadyFullImportedInOrient(orientGraph, fullRecord, currentOutVertexType, propertiesOfIndex = this.transformAggregateTablePropertyOfKey(aggregateTablePropertyOfKey, currentEntity))) {
                            currentOutVertex = (OrientVertex)graphDBCommandEngine.upsertVisitedVertex(orientGraph, fullRecord, currentOutVertexType, propertiesOfIndex);
                            for (OCanonicalRelationship currentRelation : currentEntity.getAllOutCanonicalRelationships()) {
                                currentParentEntity = mapper.getDataBaseSchema().getEntityByNameIgnoreCase(currentRelation.getParentEntity().getName());
                                currentInVertexType = null;
                                if (currentParentEntity.getHierarchicalBag() == null) {
                                    currentInVertexType = mapper.getVertexTypeByEntity(currentRelation.getParentEntity());
                                } else if (!currentEntity.getHierarchicalBag().equals(currentParentEntity.getHierarchicalBag())) {
                                    propertyOfKey = new String[currentRelation.getFromColumns().size()];
                                    valueOfKey = new String[currentRelation.getFromColumns().size()];
                                    int index = 0;
                                    for (OAttribute foreignAttribute : currentRelation.getFromColumns()) {
                                        propertyOfKey[index] = currentRelation.getToColumns().get(index).getName();
                                        valueOfKey[index] = fullRecord.getString(foreignAttribute.getName());
                                        ++index;
                                    }
                                    boolean ok = true;
                                    for (int j = 0; j < valueOfKey.length; ++j) {
                                        if (valueOfKey[j] != null) continue;
                                        ok = false;
                                        break;
                                    }
                                    if (ok) {
                                        String currentArrivalEntityName = this.searchParentEntityType(currentParentEntity, propertyOfKey, valueOfKey, null, dbQueryEngine);
                                        OEntity currentArrivalEntity = mapper.getDataBaseSchema().getEntityByName(currentArrivalEntityName);
                                        currentInVertexType = mapper.getVertexTypeByEntity(currentArrivalEntity);
                                    }
                                }
                                if (currentInVertexType == null) continue;
                                edgeType = mapper.getRelationship2edgeType().get(currentRelation);
                                graphDBCommandEngine.upsertReachedVertexWithEdge(orientGraph, fullRecord, currentRelation, currentOutVertex, currentInVertexType, edgeType.getName());
                            }
                        }
                        queryResult2.closeAll();
                        ++statistics.analyzedRecords;
                    }
                    queryResult1.closeAll();
                }
            }
            statistics.notifyListeners();
            statistics.runningStepNumber = -1;
            OTeleporterContext.getInstance().getOutputManager().info("\n");
            currentOutVertexType.setAnalyzedInLastMigration(true);
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
    }

    protected void tablePerConcreteTypeImport(OHierarchicalBag bag, OER2GraphMapper mapper, ODBQueryEngine dbQueryEngine, OGraphEngineForDB graphDBCommandEngine, OrientBaseGraph orientGraph) {
        try {
            OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
            OEntity currentParentEntity = null;
            OVertexType currentOutVertexType = null;
            OVertexType currentInVertexType = null;
            OrientVertex currentOutVertex = null;
            OEdgeType edgeType = null;
            OQueryResult queryResult = null;
            for (int i = bag.getDepth2entities().size() - 1; i >= 0; --i) {
                for (OEntity currentEntity : bag.getDepth2entities().get(i)) {
                    queryResult = dbQueryEngine.getRecordsByEntity(currentEntity);
                    ResultSet records = queryResult.getResult();
                    ResultSet currentRecord = null;
                    currentOutVertexType = mapper.getVertexTypeByEntity(currentEntity);
                    while (records.next()) {
                        currentRecord = records;
                        String[] propertyOfKey = new String[currentEntity.getPrimaryKey().getInvolvedAttributes().size()];
                        for (int k = 0; k < propertyOfKey.length; ++k) {
                            propertyOfKey[k] = currentEntity.getPrimaryKey().getInvolvedAttributes().get(k).getName();
                        }
                        Set<String> propertiesOfIndex = this.transformAggregateTablePropertyOfKey(propertyOfKey, currentEntity);
                        if (!graphDBCommandEngine.alreadyFullImportedInOrient(orientGraph, currentRecord, currentOutVertexType, propertiesOfIndex)) {
                            currentOutVertex = (OrientVertex)graphDBCommandEngine.upsertVisitedVertex(orientGraph, currentRecord, currentOutVertexType, propertiesOfIndex);
                            for (OCanonicalRelationship currentRelation : currentEntity.getAllOutCanonicalRelationships()) {
                                currentParentEntity = mapper.getDataBaseSchema().getEntityByNameIgnoreCase(currentRelation.getParentEntity().getName());
                                currentInVertexType = null;
                                if (currentParentEntity.getHierarchicalBag() == null) {
                                    currentInVertexType = mapper.getVertexTypeByEntity(currentRelation.getParentEntity());
                                } else if (!currentEntity.getHierarchicalBag().equals(currentParentEntity.getHierarchicalBag())) {
                                    propertyOfKey = new String[currentRelation.getFromColumns().size()];
                                    String[] valueOfKey = new String[currentRelation.getFromColumns().size()];
                                    int index = 0;
                                    for (OAttribute foreignAttribute : currentRelation.getFromColumns()) {
                                        propertyOfKey[index] = currentRelation.getToColumns().get(index).getName();
                                        valueOfKey[index] = currentRecord.getString(foreignAttribute.getName());
                                        ++index;
                                    }
                                    boolean ok = true;
                                    for (int j = 0; j < valueOfKey.length; ++j) {
                                        if (valueOfKey[j] != null) continue;
                                        ok = false;
                                        break;
                                    }
                                    if (ok) {
                                        String currentArrivalEntityName = this.searchParentEntityType(currentParentEntity, propertyOfKey, valueOfKey, null, dbQueryEngine);
                                        OEntity currentArrivalEntity = mapper.getDataBaseSchema().getEntityByName(currentArrivalEntityName);
                                        currentInVertexType = mapper.getVertexTypeByEntity(currentArrivalEntity);
                                    }
                                }
                                if (currentInVertexType == null) continue;
                                edgeType = mapper.getRelationship2edgeType().get(currentRelation);
                                graphDBCommandEngine.upsertReachedVertexWithEdge(orientGraph, currentRecord, currentRelation, currentOutVertex, currentInVertexType, edgeType.getName());
                            }
                        }
                        ++statistics.analyzedRecords;
                    }
                    queryResult.closeAll();
                }
            }
            statistics.notifyListeners();
            statistics.runningStepNumber = -1;
            OTeleporterContext.getInstance().getOutputManager().info("\n");
            currentOutVertexType.setAnalyzedInLastMigration(true);
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
    }

    private Set<String> transformAggregateTablePropertyOfKey(String[] aggregateTablePropertyOfKey, OEntity currentEntity) {
        LinkedHashSet<String> propertiesOfKey = new LinkedHashSet<String>();
        for (String tableKey : aggregateTablePropertyOfKey) {
            String correspondentProperty = this.mapper.getPropertyNameByEntityAndAttribute(currentEntity, tableKey);
            propertiesOfKey.add(correspondentProperty);
        }
        return propertiesOfKey;
    }

    private String searchParentEntityType(OEntity currentParentEntity, String[] propertyOfKey, String[] valueOfKey, OEntity physicalArrivalEntity, ODBQueryEngine dbQueryEngine) {
        switch (currentParentEntity.getHierarchicalBag().getInheritancePattern()) {
            case "table-per-hierarchy": {
                return this.searchParentEntityTypeFromSingleTable(currentParentEntity, propertyOfKey, valueOfKey, physicalArrivalEntity, dbQueryEngine);
            }
            case "table-per-type": {
                return this.searchParentEntityTypeFromSubclassTable(currentParentEntity, propertyOfKey, valueOfKey, dbQueryEngine);
            }
            case "table-per-concrete-type": {
                return this.searchParentEntityTypeFromConcreteTable(currentParentEntity, propertyOfKey, valueOfKey, dbQueryEngine);
            }
        }
        return null;
    }

    private String searchParentEntityTypeFromSingleTable(OEntity currentParentEntity, String[] propertyOfKey, String[] valueOfKey, OEntity physicalEntity, ODBQueryEngine dbQueryEngine) {
        OHierarchicalBag hierarchicalBag = currentParentEntity.getHierarchicalBag();
        String discriminatorColumn = hierarchicalBag.getDiscriminatorColumn();
        String entityName = null;
        try {
            OQueryResult queryResult = dbQueryEngine.getEntityTypeFromSingleTable(discriminatorColumn, physicalEntity, propertyOfKey, valueOfKey);
            ResultSet result = queryResult.getResult();
            result.next();
            String discriminatorValue = result.getString(discriminatorColumn);
            for (String currentEntityName : hierarchicalBag.getEntityName2discriminatorValue().keySet()) {
                if (!hierarchicalBag.getEntityName2discriminatorValue().get(currentEntityName).equals(discriminatorValue)) continue;
                entityName = currentEntityName;
                break;
            }
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        return entityName;
    }

    private String searchParentEntityTypeFromSubclassTable(OEntity currentParentEntity, String[] propertyOfKey, String[] valueOfKey, ODBQueryEngine dbQueryEngine) {
        OHierarchicalBag hierarchicalBag = currentParentEntity.getHierarchicalBag();
        String entityName = null;
        try {
            OQueryResult queryResult = null;
            ResultSet result = null;
            for (int i = hierarchicalBag.getDepth2entities().size() - 1; i >= 0; --i) {
                for (OEntity currentEntity : hierarchicalBag.getDepth2entities().get(i)) {
                    for (int j = 0; j < currentEntity.getPrimaryKey().getInvolvedAttributes().size(); ++j) {
                        propertyOfKey[j] = currentEntity.getPrimaryKey().getInvolvedAttributes().get(j).getName();
                    }
                    queryResult = dbQueryEngine.getRecordById(currentEntity, propertyOfKey, valueOfKey);
                    result = queryResult.getResult();
                    if (result == null) continue;
                    entityName = currentEntity.getName();
                    break;
                }
                if (result == null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        return entityName;
    }

    private String searchParentEntityTypeFromConcreteTable(OEntity currentParentEntity, String[] propertyOfKey, String[] valueOfKey, ODBQueryEngine dbQueryEngine) {
        OHierarchicalBag hierarchicalBag = currentParentEntity.getHierarchicalBag();
        String entityName = null;
        try {
            OQueryResult queryResult = null;
            ResultSet result = null;
            for (int i = hierarchicalBag.getDepth2entities().size() - 1; i >= 0; --i) {
                for (OEntity currentEntity : hierarchicalBag.getDepth2entities().get(i)) {
                    for (int j = 0; j < currentEntity.getPrimaryKey().getInvolvedAttributes().size(); ++j) {
                        propertyOfKey[j] = currentEntity.getPrimaryKey().getInvolvedAttributes().get(j).getName();
                    }
                    queryResult = dbQueryEngine.getRecordById(currentEntity, propertyOfKey, valueOfKey);
                    result = queryResult.getResult();
                    if (result == null) continue;
                    entityName = currentEntity.getName();
                    break;
                }
                if (result == null) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        return entityName;
    }

    private ResultSet getFullRecordByAggregateTable(ResultSet aggregateTableRecords, String[] aggregateTablePropertyOfKey, String[] valueOfKey) {
        ResultSet fullRecord = null;
        String[] currentValueOfKey = new String[aggregateTablePropertyOfKey.length];
        try {
            while (aggregateTableRecords.next()) {
                for (int i = 0; i < aggregateTablePropertyOfKey.length; ++i) {
                    currentValueOfKey[i] = aggregateTableRecords.getString(aggregateTablePropertyOfKey[i]);
                }
                boolean equals = true;
                for (int j = 0; j < valueOfKey.length; ++j) {
                    if (valueOfKey[j].equals(currentValueOfKey[j])) continue;
                    equals = false;
                    break;
                }
                if (!equals) continue;
                fullRecord = aggregateTableRecords;
                return fullRecord;
            }
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        return fullRecord;
    }

    protected boolean hasGeospatialAttributes(OEntity entity, ODBMSDataTypeHandler handler) {
        for (OAttribute currentAttribute : entity.getAllAttributes()) {
            if (!handler.isGeospatial(currentAttribute.getDataType())) continue;
            return true;
        }
        return false;
    }

    protected String[][] buildAggregationColumnsFromAggregatedVertex(OConfiguredVertexClass configuredVertex) {
        List<OSourceTable> sourceTables = configuredVertex.getMapping().getSourceTables();
        String[][] columns = new String[sourceTables.size()][sourceTables.get(0).getAggregationColumns().size()];
        int j = 0;
        for (OSourceTable currentSourceTable : sourceTables) {
            List<String> aggregationColumns = currentSourceTable.getAggregationColumns();
            if (aggregationColumns != null) {
                int k = 0;
                Iterator<String> iterator = aggregationColumns.iterator();
                while (iterator.hasNext()) {
                    String attribute;
                    columns[j][k] = attribute = iterator.next();
                    ++k;
                }
            }
            ++j;
        }
        return columns;
    }
}

