/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.strategy.rdbms;

import com.orientechnologies.orient.core.intent.OIntent;
import com.orientechnologies.orient.core.intent.OIntentMassiveInsert;
import com.orientechnologies.teleporter.configuration.OConfigurationHandler;
import com.orientechnologies.teleporter.configuration.api.OConfiguration;
import com.orientechnologies.teleporter.configuration.api.OConfiguredVertexClass;
import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.context.OTeleporterStatistics;
import com.orientechnologies.teleporter.exception.OTeleporterRuntimeException;
import com.orientechnologies.teleporter.factory.OMapperFactory;
import com.orientechnologies.teleporter.importengine.rdbms.dbengine.ODBQueryEngine;
import com.orientechnologies.teleporter.importengine.rdbms.graphengine.OGraphEngineForDB;
import com.orientechnologies.teleporter.mapper.OSource2GraphMapper;
import com.orientechnologies.teleporter.mapper.rdbms.OAggregatorEdge;
import com.orientechnologies.teleporter.mapper.rdbms.OER2GraphMapper;
import com.orientechnologies.teleporter.mapper.rdbms.classmapper.OEVClassMapper;
import com.orientechnologies.teleporter.model.dbschema.OEntity;
import com.orientechnologies.teleporter.model.dbschema.OSourceDatabaseInfo;
import com.orientechnologies.teleporter.model.graphmodel.OGraphModel;
import com.orientechnologies.teleporter.model.graphmodel.OVertexType;
import com.orientechnologies.teleporter.nameresolver.ONameResolver;
import com.orientechnologies.teleporter.persistence.handler.ODBMSDataTypeHandler;
import com.orientechnologies.teleporter.persistence.util.OQueryResult;
import com.orientechnologies.teleporter.strategy.rdbms.OAbstractDBMSImportStrategy;
import com.orientechnologies.teleporter.writer.OGraphModelWriter;
import com.tinkerpop.blueprints.impls.orient.OrientBaseGraph;
import com.tinkerpop.blueprints.impls.orient.OrientGraphFactory;
import com.tinkerpop.blueprints.impls.orient.OrientGraphNoTx;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;

public class ODBMSNaiveAggregationStrategy
extends OAbstractDBMSImportStrategy {
    @Override
    protected OConfigurationHandler buildConfigurationHandler() {
        return new OConfigurationHandler(true);
    }

    @Override
    public OER2GraphMapper createSchemaMapper(OSourceDatabaseInfo sourceDBInfo, String outOrientGraphUri, String chosenMapper, String xmlPath, ONameResolver nameResolver, ODBMSDataTypeHandler handler, List<String> includedTables, List<String> excludedTables, OConfiguration migrationConfig) {
        OMapperFactory mapperFactory = new OMapperFactory();
        OER2GraphMapper mapper = (OER2GraphMapper)mapperFactory.buildMapper(chosenMapper, sourceDBInfo, xmlPath, includedTables, excludedTables, migrationConfig);
        mapper.buildSourceDatabaseSchema();
        OTeleporterContext.getInstance().getStatistics().notifyListeners();
        OTeleporterContext.getInstance().getOutputManager().info("\n");
        if (OTeleporterContext.getInstance().getOutputManager().getLevel() == 1) {
            OTeleporterContext.getInstance().getOutputManager().debug("\n%s\n", mapper.getDataBaseSchema().toString());
        }
        mapper.buildGraphModel(nameResolver);
        OTeleporterContext.getInstance().getStatistics().notifyListeners();
        OTeleporterContext.getInstance().getOutputManager().info("\n");
        if (OTeleporterContext.getInstance().getOutputManager().getLevel() == 1) {
            OTeleporterContext.getInstance().getOutputManager().debug("\n%s\n", mapper.getGraphModel().toString());
        }
        mapper.applyImportConfiguration();
        mapper.performAggregations();
        if (OTeleporterContext.getInstance().getOutputManager().getLevel() == 1) {
            OTeleporterContext.getInstance().getOutputManager().debug("\n'Junction-Entity' aggregation complete.\n");
            OTeleporterContext.getInstance().getOutputManager().debug("\n%s\n", mapper.getGraphModel().toString());
        }
        OGraphModelWriter graphModelWriter = new OGraphModelWriter(migrationConfig);
        OGraphModel graphModel = mapper.getGraphModel();
        boolean success = graphModelWriter.writeModelOnOrient(mapper, handler, outOrientGraphUri);
        if (!success) {
            OTeleporterContext.getInstance().getOutputManager().error("Writing not complete. Something gone wrong.\n");
            throw new OTeleporterRuntimeException();
        }
        OTeleporterContext.getInstance().getStatistics().notifyListeners();
        if (OTeleporterContext.getInstance().getOutputManager().getLevel() == 1) {
            OTeleporterContext.getInstance().getOutputManager().debug("\nOrientDB Schema writing complete.\n");
        }
        OTeleporterContext.getInstance().getOutputManager().info("\n");
        return mapper;
    }

    @Override
    public void executeImport(OSourceDatabaseInfo sourceDBInfo, String outOrientGraphUri, OSource2GraphMapper genericMapper, ODBMSDataTypeHandler handler) {
        try {
            OEntity currentEntity;
            LinkedList<OEntity> mappedEntities;
            OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
            statistics.startWork4Time = new Date();
            statistics.runningStepNumber = 4;
            OER2GraphMapper mapper = (OER2GraphMapper)genericMapper;
            ODBQueryEngine dbQueryEngine = OTeleporterContext.getInstance().getDbQueryEngine();
            OGraphEngineForDB graphEngine = new OGraphEngineForDB(mapper, handler);
            OrientGraphNoTx orientGraph = null;
            OrientGraphFactory factory = new OrientGraphFactory(outOrientGraphUri, "admin", "admin");
            orientGraph = factory.getNoTx();
            orientGraph.getRawGraph().declareIntent((OIntent)new OIntentMassiveInsert());
            orientGraph.setStandardElementConstraints(false);
            super.importEntitiesBelongingToHierarchies(dbQueryEngine, graphEngine, (OrientBaseGraph)orientGraph);
            for (OVertexType currentOutVertexType : mapper.getVertexType2EVClassMappers().keySet()) {
                List<OEVClassMapper> classMappersByVertex = this.mapper.getEVClassMappersByVertex(currentOutVertexType);
                mappedEntities = new LinkedList<OEntity>();
                boolean allEntitiesNotAggregableAndNotBelongingToHierarchies = true;
                for (OEVClassMapper classMapper : classMappersByVertex) {
                    currentEntity = classMapper.getEntity();
                    if (currentEntity.getHierarchicalBag() != null || currentEntity.isAggregableJoinTable()) {
                        allEntitiesNotAggregableAndNotBelongingToHierarchies = false;
                        break;
                    }
                    mappedEntities.add(currentEntity);
                }
                if (!allEntitiesNotAggregableAndNotBelongingToHierarchies) continue;
                String[][] aggregationColumns = null;
                if (mappedEntities.size() > 1) {
                    OConfiguredVertexClass configuredVertex = mapper.getMigrationConfig().getVertexByMappedEntities(mappedEntities);
                    aggregationColumns = super.buildAggregationColumnsFromAggregatedVertex(configuredVertex);
                    if (currentOutVertexType.isAnalyzedInLastMigration()) continue;
                    super.importRecordsFromEntitiesIntoVertexClass(mappedEntities, aggregationColumns, currentOutVertexType, dbQueryEngine, graphEngine, (OrientBaseGraph)orientGraph);
                    continue;
                }
                if (mappedEntities.size() != 1) continue;
                List<OEVClassMapper> classMappersByEntity = this.mapper.getEVClassMappersByEntity((OEntity)mappedEntities.get(0));
                if (classMappersByEntity.size() == 1) {
                    if (currentOutVertexType.isAnalyzedInLastMigration()) continue;
                    super.importRecordsFromEntitiesIntoVertexClass(mappedEntities, aggregationColumns, currentOutVertexType, dbQueryEngine, graphEngine, (OrientBaseGraph)orientGraph);
                    continue;
                }
                if (classMappersByEntity.size() <= 1) continue;
                LinkedList<OVertexType> mappedVertices = new LinkedList<OVertexType>();
                for (OEVClassMapper classMapper : classMappersByVertex) {
                    mappedVertices.add(classMapper.getVertexType());
                }
                if (currentOutVertexType.isAnalyzedInLastMigration()) continue;
                super.importRecordsFromSplitEntityIntoVertexClasses(mappedEntities, mappedVertices, dbQueryEngine, graphEngine, (OrientBaseGraph)orientGraph);
            }
            for (OVertexType currentOutVertexType : mapper.getVertexType2EVClassMappers().keySet()) {
                List<OEVClassMapper> classMappers = this.mapper.getEVClassMappersByVertex(currentOutVertexType);
                mappedEntities = new LinkedList();
                boolean allEntitiesAggregableAndNotBelongingToHierarchies = true;
                for (OEVClassMapper classMapper : classMappers) {
                    currentEntity = classMapper.getEntity();
                    if (currentEntity.getHierarchicalBag() != null || !currentEntity.isAggregableJoinTable()) {
                        allEntitiesAggregableAndNotBelongingToHierarchies = false;
                        break;
                    }
                    mappedEntities.add(currentEntity);
                }
                if (mappedEntities.size() > 1) {
                    OTeleporterContext.getInstance().getOutputManager().error("The '%s' vertex type is mapped with several join tables: you cannot aggregate multiple join tables.");
                    break;
                }
                if (!allEntitiesAggregableAndNotBelongingToHierarchies) continue;
                this.importJoinTableRecordIntoEdgeClass(mappedEntities, dbQueryEngine, graphEngine, (OrientBaseGraph)orientGraph);
            }
            statistics.notifyListeners();
            statistics.runningStepNumber = -1;
            orientGraph.shutdown();
            OTeleporterContext.getInstance().getOutputManager().info("\n");
        }
        catch (OTeleporterRuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "debug");
        }
    }

    protected void importJoinTableRecordIntoEdgeClass(List<OEntity> mappedEntities, ODBQueryEngine dbQueryEngine, OGraphEngineForDB graphEngine, OrientBaseGraph orientGraph) throws SQLException {
        OTeleporterStatistics statistics = OTeleporterContext.getInstance().getStatistics();
        OEntity joinTable = mappedEntities.get(0);
        OQueryResult queryResult = dbQueryEngine.getRecordsByEntity(joinTable);
        ResultSet records = queryResult.getResult();
        ResultSet currentRecord = null;
        OAggregatorEdge aggregatorEdge = this.mapper.getAggregatorEdgeByJoinVertexTypeName(this.mapper.getVertexTypeByEntity(joinTable).getName());
        while (records.next()) {
            currentRecord = records;
            graphEngine.upsertAggregatorEdge(orientGraph, currentRecord, joinTable, aggregatorEdge);
            ++statistics.analyzedRecords;
        }
        queryResult.closeAll();
    }
}

