/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.ui;

import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.context.OTeleporterStatistics;
import com.orientechnologies.teleporter.ui.OStatisticsListener;
import com.orientechnologies.teleporter.util.OFunctionsHandler;
import java.util.Date;

public class OProgressMonitor
implements OStatisticsListener {
    private final String work1Title = String.format("%-35s", "(1/4) Source DB Schema building:");
    private final String work2Title = String.format("%-35s", "(2/4) Graph Model building:");
    private final String work3Title = String.format("%-35s", "(3/4) OrientDB Schema writing:");
    private final String work4Title = String.format("%-35s", "(4/4) OrientDB importing:");
    private final String work5Title = String.format("%-35s", "Building accessory edges in OrientDB:");
    private boolean firstPrint = true;

    @Override
    public String updateOnEvent(OTeleporterStatistics statistics) {
        if (this.firstPrint) {
            OTeleporterContext.getInstance().getOutputManager().info("\n");
            this.firstPrint = false;
        }
        String message = null;
        switch (statistics.runningStepNumber) {
            case 1: {
                message = this.updateWork1OnEvent(statistics);
                break;
            }
            case 2: {
                message = this.updateWork2OnEvent(statistics);
                break;
            }
            case 3: {
                message = this.updateWork3OnEvent(statistics);
                break;
            }
            case 4: {
                message = this.updateWork4OnEvent(statistics);
                break;
            }
            case 5: {
                message = this.updateWork5OnEvent(statistics);
            }
        }
        return message;
    }

    public String updateWork1OnEvent(OTeleporterStatistics statistics) {
        Date currentTime = new Date();
        int work1DonePercentage = (int)((double)statistics.builtEntities / (double)statistics.totalNumberOfEntities * 0.25 * 100.0 + (double)statistics.entitiesAnalyzedForRelationship / (double)statistics.totalNumberOfEntities * 0.75 * 100.0);
        String progressBarWork1 = this.getProgressBar(work1DonePercentage);
        long elapsedTime = currentTime.getTime() - statistics.startWork1Time.getTime();
        return this.printProgressBar(this.work1Title, work1DonePercentage, progressBarWork1, elapsedTime, statistics.warningMessages.size(), -1, -1);
    }

    public String updateWork2OnEvent(OTeleporterStatistics statistics) {
        int work2DonePercentage;
        Date currentTime = new Date();
        if (statistics.totalNumberOfModelVertices > 0 && statistics.totalNumberOfModelEdges > 0) {
            work2DonePercentage = (int)((double)statistics.builtModelVertexTypes / (double)statistics.totalNumberOfModelVertices * 100.0 / 2.0);
            work2DonePercentage += (int)((double)statistics.builtModelEdgeTypes / (double)statistics.totalNumberOfModelEdges * 100.0 / 2.0);
        } else {
            work2DonePercentage = statistics.totalNumberOfModelVertices > 0 && statistics.totalNumberOfModelEdges == 0 ? (int)((double)statistics.builtModelVertexTypes / (double)statistics.totalNumberOfModelVertices * 100.0) : 0;
        }
        String progressBarWork2 = this.getProgressBar(work2DonePercentage);
        long elapsedTime = currentTime.getTime() - statistics.startWork2Time.getTime();
        return this.printProgressBar(this.work2Title, work2DonePercentage, progressBarWork2, elapsedTime, statistics.warningMessages.size(), -1, -1);
    }

    public String updateWork3OnEvent(OTeleporterStatistics statistics) {
        int work3DonePercentage;
        Date currentTime = new Date();
        if (statistics.totalNumberOfVertexTypes > 0 && statistics.totalNumberOfEdgeTypes > 0 && statistics.totalNumberOfIndices > 0) {
            work3DonePercentage = (int)((double)statistics.wroteVertexType / (double)statistics.totalNumberOfVertexTypes * 0.35 * 100.0);
            work3DonePercentage += (int)((double)statistics.wroteEdgeType / (double)statistics.totalNumberOfEdgeTypes * 0.35 * 100.0);
            work3DonePercentage += (int)((double)statistics.wroteIndexes / (double)statistics.totalNumberOfIndices * 0.3 * 100.0);
        } else if (statistics.totalNumberOfVertexTypes > 0 && statistics.totalNumberOfEdgeTypes > 0 && statistics.totalNumberOfIndices == 0) {
            work3DonePercentage = (int)((double)statistics.wroteVertexType / (double)statistics.totalNumberOfVertexTypes * 100.0 / 2.0);
            work3DonePercentage += (int)((double)statistics.wroteEdgeType / (double)statistics.totalNumberOfEdgeTypes * 100.0 / 2.0);
        } else if (statistics.totalNumberOfVertexTypes > 0 && statistics.totalNumberOfEdgeTypes == 0 && statistics.totalNumberOfIndices > 0) {
            work3DonePercentage = (int)((double)statistics.wroteVertexType / (double)statistics.totalNumberOfVertexTypes * 100.0 / 2.0);
            work3DonePercentage += (int)((double)statistics.wroteIndexes / (double)statistics.totalNumberOfIndices * 100.0 / 2.0);
        } else {
            work3DonePercentage = statistics.totalNumberOfVertexTypes > 0 && statistics.totalNumberOfEdgeTypes == 0 && statistics.totalNumberOfIndices == 0 ? (int)((double)statistics.wroteVertexType / (double)statistics.totalNumberOfVertexTypes * 100.0) : 0;
        }
        String progressBarWork3 = this.getProgressBar(work3DonePercentage);
        long elapsedTime = currentTime.getTime() - statistics.startWork3Time.getTime();
        return this.printProgressBar(this.work3Title, work3DonePercentage, progressBarWork3, elapsedTime, statistics.warningMessages.size(), -1, -1);
    }

    public String updateWork4OnEvent(OTeleporterStatistics statistics) {
        Date currentTime = new Date();
        int work4DonePercentage = statistics.totalNumberOfEntities > 0 ? (int)((double)statistics.analyzedRecords / (double)statistics.totalNumberOfRecords * 100.0) : 0;
        String progressBarWork4 = this.getProgressBar(work4DonePercentage);
        long elapsedTime = currentTime.getTime() - statistics.startWork4Time.getTime();
        return this.printProgressBar(this.work4Title, work4DonePercentage, progressBarWork4, elapsedTime, statistics.warningMessages.size(), statistics.analyzedRecords, statistics.totalNumberOfRecords);
    }

    public String updateWork5OnEvent(OTeleporterStatistics statistics) {
        int work5DonePercentage;
        Date currentTime = new Date();
        int numberOfLogicalRelationships = statistics.totalNumberOfLogicalRelationships;
        if (numberOfLogicalRelationships > 0) {
            int work5percentage1 = statistics.leftVerticesCurrentLogicalRelationship > 0 ? statistics.doneLeftVerticesCurrentLogicalRelationship / statistics.leftVerticesCurrentLogicalRelationship : 0;
            int work5percentage2 = statistics.doneLogicalRelationships / statistics.totalNumberOfLogicalRelationships;
            work5DonePercentage = work5percentage2 == 1 ? 100 : (work5percentage2 + work5percentage1 / numberOfLogicalRelationships) * 100;
        } else {
            work5DonePercentage = 0;
        }
        String progressBarWork5 = this.getProgressBar(work5DonePercentage);
        long elapsedTime = currentTime.getTime() - statistics.startWork5Time.getTime();
        return this.printProgressBar(this.work5Title, work5DonePercentage, progressBarWork5, elapsedTime, statistics.warningMessages.size(), -1, -1);
    }

    public void initialize() {
        OTeleporterContext.getInstance().getStatistics().registerListener(this);
    }

    public String printProgressBar(String workTitle, int workDonePercentage, String progressBarWork, long elapsedTime, int occurredWarnings, int importedRecords, int totalRecords) {
        String format = importedRecords == -1 && totalRecords == -1 ? "\r%s %3d%% %s %s %s %s %s %s %s" : "\r%s %3d%% %s %s %s %s %s %s %s %s %s";
        String elapsedHMSTime = OFunctionsHandler.getHMSFormat(elapsedTime);
        long remainingTime = workDonePercentage > 0 ? elapsedTime * (long)(100 - workDonePercentage) / (long)workDonePercentage : 0L;
        String remainingHMSTime = OFunctionsHandler.getHMSFormat(remainingTime);
        String message = String.format(format, workTitle, workDonePercentage, progressBarWork, " Elapsed:", elapsedHMSTime, " Remaining:", remainingHMSTime, " Warnings:", occurredWarnings, " Records:", importedRecords + "/" + totalRecords);
        OTeleporterContext.getInstance().getOutputManager().info(message);
        if (message.length() > 500) {
            System.out.println();
        }
        return message;
    }

    public String getProgressBar(int workDonePercentage) {
        int pointCharsWork;
        int emptyCharsWork = 20 - pointCharsWork;
        String progressBarWork = "[";
        for (pointCharsWork = workDonePercentage / 5; pointCharsWork > 0; --pointCharsWork) {
            progressBarWork = progressBarWork + '.';
        }
        while (emptyCharsWork > 0) {
            progressBarWork = progressBarWork + ' ';
            --emptyCharsWork;
        }
        progressBarWork = progressBarWork + "]";
        return progressBarWork;
    }
}

