/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.teleporter.util;

import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.teleporter.context.OTeleporterContext;
import com.orientechnologies.teleporter.exception.OTeleporterRuntimeException;
import com.orientechnologies.teleporter.persistence.util.ODBSourceConnection;
import com.orientechnologies.teleporter.util.OFileManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class ODriverConfigurator {
    public static final String DRIVERS = "http://orientdb.com/jdbc-drivers.json";
    private final String localJsonPath = "../config/jdbc-drivers.json";
    private final String driverClassPath = "../lib/";
    private ODocument driverInfo;
    private Map<String, List<String>> driver2filesIdentifier = new LinkedHashMap<String, List<String>>();

    public ODriverConfigurator() {
        this.fillMap();
    }

    private void fillMap() {
        LinkedList<String> oracleIdentifiers = new LinkedList<String>();
        oracleIdentifiers.add("ojdbc");
        this.driver2filesIdentifier.put("oracle", oracleIdentifiers);
        LinkedList<String> sqlserverIdentifiers = new LinkedList<String>();
        sqlserverIdentifiers.add("sqljdbc");
        sqlserverIdentifiers.add("jtds");
        this.driver2filesIdentifier.put("sqlserver", sqlserverIdentifiers);
        LinkedList<String> mysqlIdentifiers = new LinkedList<String>();
        mysqlIdentifiers.add("mysql");
        this.driver2filesIdentifier.put("mysql", mysqlIdentifiers);
        LinkedList<String> postgresqlIdentifiers = new LinkedList<String>();
        postgresqlIdentifiers.add("postgresql");
        this.driver2filesIdentifier.put("postgresql", postgresqlIdentifiers);
        LinkedList<String> hypersqlIdentifiers = new LinkedList<String>();
        hypersqlIdentifiers.add("hsqldb");
        this.driver2filesIdentifier.put("hypersql", hypersqlIdentifiers);
    }

    public String fetchDriverClassName(String driverName) {
        String driverClassName = null;
        driverName = driverName.toLowerCase(Locale.ENGLISH);
        try {
            if (this.driverInfo == null) {
                this.driverInfo = this.readJsonFromRemoteUrl(DRIVERS);
            }
            ODocument fields = null;
            if (driverName.equals("oracle")) {
                fields = (ODocument)this.driverInfo.field("Oracle");
            }
            if (driverName.equals("sqlserver")) {
                fields = (ODocument)this.driverInfo.field("SQLServer");
            } else if (driverName.equals("mysql")) {
                fields = (ODocument)this.driverInfo.field("MySQL");
            } else if (driverName.equals("postgresql")) {
                fields = (ODocument)this.driverInfo.field("PostgreSQL");
            } else if (driverName.equals("hypersql")) {
                fields = (ODocument)this.driverInfo.field("HyperSQL");
            }
            driverClassName = (String)fields.field("className");
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        return driverClassName;
    }

    public void checkDriverConfiguration(String driverName) {
        this.checkDriverConfiguration(driverName, this.driverClassPath);
    }

    public void checkDriverConfiguration(String driverName, String driverClassPath) {
        driverName = driverName.toLowerCase(Locale.ENGLISH);
        try {
            if (this.driverInfo == null) {
                this.driverInfo = this.readJsonFromRemoteUrl(DRIVERS);
            }
            ODocument fields = null;
            if (driverName.equals("oracle")) {
                fields = (ODocument)this.driverInfo.field("Oracle");
            }
            if (driverName.equals("sqlserver")) {
                fields = (ODocument)this.driverInfo.field("SQLServer");
            } else if (driverName.equals("mysql")) {
                fields = (ODocument)this.driverInfo.field("MySQL");
            } else if (driverName.equals("postgresql")) {
                fields = (ODocument)this.driverInfo.field("PostgreSQL");
            } else if (driverName.equals("hypersql")) {
                fields = (ODocument)this.driverInfo.field("HyperSQL");
            }
            String driverPath = this.isDriverAlreadyPresent(driverName, driverClassPath);
            if (driverPath == null) {
                OTeleporterContext.getInstance().getOutputManager().info("\nDownloading the necessary JDBC driver in ORIENTDB_HOME/lib ...\n");
                String driverDownldUrl = (String)fields.field("url");
                URL website = new URL(driverDownldUrl);
                String fileName = driverDownldUrl.substring(driverDownldUrl.lastIndexOf(47) + 1, driverDownldUrl.length());
                ReadableByteChannel rbc = Channels.newChannel(website.openStream());
                FileOutputStream fos = new FileOutputStream(driverClassPath + fileName);
                fos.getChannel().transferFrom(rbc, 0L, Long.MAX_VALUE);
                driverPath = driverClassPath + fileName;
                if (driverName.equalsIgnoreCase("SQLServer")) {
                    OFileManager.extractAll(driverPath, driverClassPath);
                    try {
                        OFileManager.deleteResource(driverPath);
                    }
                    catch (IOException e) {
                        OTeleporterContext.getInstance().getOutputManager().info("The %s package file was not correctly deleted from the %s path.", driverPath, driverClassPath);
                    }
                    String[] split = driverPath.split(".jar");
                    driverPath = split[0] + ".jar";
                }
                OTeleporterContext.getInstance().getOutputManager().info("Driver JDBC downloaded.\n");
            }
            OTeleporterContext.getInstance().setDriverDependencyPath(driverPath);
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
    }

    private String isDriverAlreadyPresent(String driverName, String classPath) {
        File dir = new File(classPath);
        File[] files = dir.listFiles();
        if (files == null) {
            dir.mkdirs();
            files = dir.listFiles();
        }
        for (String identifier : this.driver2filesIdentifier.get(driverName)) {
            for (int i = 0; i < files.length; ++i) {
                if (!files[i].getName().startsWith(identifier)) continue;
                return files[i].getPath();
            }
        }
        return null;
    }

    public ODocument readJsonFromRemoteUrl(String url) {
        InputStream is = null;
        ODocument json = null;
        try {
            URL urlObj = new URL(url);
            URLConnection urlConn = urlObj.openConnection();
            urlConn.setRequestProperty("User-Agent", "Teleporter");
            boolean downloadedNewJsonDrivers = true;
            try {
                is = urlConn.getInputStream();
            }
            catch (IOException e1) {
                downloadedNewJsonDrivers = false;
                try {
                    is = new FileInputStream(new File(this.localJsonPath));
                }
                catch (IOException e2) {
                    String mess = "The jdbc-drivers json cannot be found. The connection to http://orientdb.com/jdbc-drivers.json did not succeed, and the \"jdbc-drivers.json\" file is not present in ORIENTDB_HOME/config neither.\n";
                    OTeleporterContext.getInstance().printExceptionMessage(e2, mess, "error");
                    OTeleporterContext.getInstance().printExceptionStackTrace(e2, "error");
                    throw new OTeleporterRuntimeException(e2);
                }
            }
            json = new ODocument();
            BufferedReader rd = new BufferedReader(new InputStreamReader(is, Charset.forName("UTF-8")));
            String jsonText = OFileManager.readAllTextFile(rd);
            json.fromJSON(jsonText, "noMap");
            if (downloadedNewJsonDrivers) {
                OFileManager.writeFileFromText(jsonText, this.localJsonPath, false);
            }
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception e) {
                String mess = "";
                OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
                OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
                throw new OTeleporterRuntimeException(e);
            }
        }
        return json;
    }

    public void checkConnection(String driver, String uri, String username, String password) throws Exception {
        this.checkDriverConfiguration(driver);
        this.checkConnectionSubRoutine(driver, uri, username, password);
    }

    public void checkConnection(String driver, String uri, String username, String password, String driverClassPath) throws Exception {
        this.checkDriverConfiguration(driver, driverClassPath);
        this.checkConnectionSubRoutine(driver, uri, username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkConnectionSubRoutine(String driver, String uri, String username, String password) throws SQLException {
        String driverName = this.fetchDriverClassName(driver);
        try (Connection connection = null;){
            connection = ODBSourceConnection.getConnection(driverName, uri, username, password);
        }
    }

    public Connection getDBMSConnection(String driver, String uri, String username, String password) throws SQLException {
        String driverName = this.fetchDriverClassName(driver);
        Connection connection = null;
        try {
            connection = ODBSourceConnection.getConnection(driverName, uri, username, password);
        }
        catch (Exception e) {
            String mess = "";
            OTeleporterContext.getInstance().printExceptionMessage(e, mess, "error");
            OTeleporterContext.getInstance().printExceptionStackTrace(e, "error");
            throw new OTeleporterRuntimeException(e);
        }
        return connection;
    }
}

