/*
 * Decompiled with CFR 0.152.
 */
package com.tinkerpop.gremlin.java;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.Tokens;
import com.tinkerpop.gremlin.java.GremlinFluentPipeline;
import com.tinkerpop.gremlin.java.GremlinFluentUtility;
import com.tinkerpop.gremlin.java.GremlinStartPipe;
import com.tinkerpop.pipes.FunctionPipe;
import com.tinkerpop.pipes.IdentityPipe;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.branch.CopySplitPipe;
import com.tinkerpop.pipes.branch.ExhaustMergePipe;
import com.tinkerpop.pipes.branch.FairMergePipe;
import com.tinkerpop.pipes.branch.IfThenElsePipe;
import com.tinkerpop.pipes.branch.LoopPipe;
import com.tinkerpop.pipes.filter.AndFilterPipe;
import com.tinkerpop.pipes.filter.BackFilterPipe;
import com.tinkerpop.pipes.filter.CyclicPathFilterPipe;
import com.tinkerpop.pipes.filter.DuplicateFilterPipe;
import com.tinkerpop.pipes.filter.ExceptFilterPipe;
import com.tinkerpop.pipes.filter.FilterFunctionPipe;
import com.tinkerpop.pipes.filter.IdFilterPipe;
import com.tinkerpop.pipes.filter.IntervalFilterPipe;
import com.tinkerpop.pipes.filter.LabelFilterPipe;
import com.tinkerpop.pipes.filter.OrFilterPipe;
import com.tinkerpop.pipes.filter.PropertyFilterPipe;
import com.tinkerpop.pipes.filter.RandomFilterPipe;
import com.tinkerpop.pipes.filter.RangeFilterPipe;
import com.tinkerpop.pipes.filter.RetainFilterPipe;
import com.tinkerpop.pipes.sideeffect.AggregatePipe;
import com.tinkerpop.pipes.sideeffect.GroupByPipe;
import com.tinkerpop.pipes.sideeffect.GroupByReducePipe;
import com.tinkerpop.pipes.sideeffect.GroupCountFunctionPipe;
import com.tinkerpop.pipes.sideeffect.GroupCountPipe;
import com.tinkerpop.pipes.sideeffect.LinkPipe;
import com.tinkerpop.pipes.sideeffect.OptionalPipe;
import com.tinkerpop.pipes.sideeffect.SideEffectFunctionPipe;
import com.tinkerpop.pipes.sideeffect.SideEffectPipe;
import com.tinkerpop.pipes.sideeffect.StorePipe;
import com.tinkerpop.pipes.sideeffect.TablePipe;
import com.tinkerpop.pipes.sideeffect.TreePipe;
import com.tinkerpop.pipes.transform.BothEdgesPipe;
import com.tinkerpop.pipes.transform.BothPipe;
import com.tinkerpop.pipes.transform.BothVerticesPipe;
import com.tinkerpop.pipes.transform.GatherFunctionPipe;
import com.tinkerpop.pipes.transform.GatherPipe;
import com.tinkerpop.pipes.transform.GraphQueryPipe;
import com.tinkerpop.pipes.transform.IdEdgePipe;
import com.tinkerpop.pipes.transform.IdPipe;
import com.tinkerpop.pipes.transform.IdVertexPipe;
import com.tinkerpop.pipes.transform.InEdgesPipe;
import com.tinkerpop.pipes.transform.InPipe;
import com.tinkerpop.pipes.transform.InVertexPipe;
import com.tinkerpop.pipes.transform.LabelPipe;
import com.tinkerpop.pipes.transform.MemoizePipe;
import com.tinkerpop.pipes.transform.OrderMapPipe;
import com.tinkerpop.pipes.transform.OrderPipe;
import com.tinkerpop.pipes.transform.OutEdgesPipe;
import com.tinkerpop.pipes.transform.OutPipe;
import com.tinkerpop.pipes.transform.OutVertexPipe;
import com.tinkerpop.pipes.transform.PathPipe;
import com.tinkerpop.pipes.transform.PropertyMapPipe;
import com.tinkerpop.pipes.transform.PropertyPipe;
import com.tinkerpop.pipes.transform.ScatterPipe;
import com.tinkerpop.pipes.transform.SelectPipe;
import com.tinkerpop.pipes.transform.ShufflePipe;
import com.tinkerpop.pipes.transform.SideEffectCapPipe;
import com.tinkerpop.pipes.transform.TransformFunctionPipe;
import com.tinkerpop.pipes.transform.TransformPipe;
import com.tinkerpop.pipes.transform.VertexQueryPipe;
import com.tinkerpop.pipes.util.AsPipe;
import com.tinkerpop.pipes.util.FluentUtility;
import com.tinkerpop.pipes.util.MetaPipe;
import com.tinkerpop.pipes.util.PipeHelper;
import com.tinkerpop.pipes.util.Pipeline;
import com.tinkerpop.pipes.util.StartPipe;
import com.tinkerpop.pipes.util.structures.AsMap;
import com.tinkerpop.pipes.util.structures.Pair;
import com.tinkerpop.pipes.util.structures.Row;
import com.tinkerpop.pipes.util.structures.Table;
import com.tinkerpop.pipes.util.structures.Tree;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class GremlinPipeline<S, E>
extends Pipeline<S, E>
implements GremlinFluentPipeline<S, E> {
    private boolean doQueryOptimization = true;
    protected final AsMap asMap = new AsMap((MetaPipe)this);

    public GremlinPipeline() {
    }

    public GremlinPipeline(Object starts, boolean doQueryOptimization) {
        super(new Pipe[]{new GremlinStartPipe(starts)});
        this.doQueryOptimization = doQueryOptimization;
        FluentUtility.setStarts((Pipeline)this, (Object)starts);
    }

    public GremlinPipeline(Object starts) {
        this(starts, true);
    }

    public <T> GremlinPipeline<S, T> add(Pipe<?, T> pipe) {
        this.addPipe(pipe);
        return this;
    }

    public GremlinPipeline<S, Vertex> V() {
        return this.add((Pipe)new GraphQueryPipe(Vertex.class));
    }

    public GremlinPipeline<S, Edge> E() {
        return this.add((Pipe)new GraphQueryPipe(Edge.class));
    }

    public GremlinPipeline<S, Vertex> V(String key, Object value) {
        return this.add((Pipe)new GraphQueryPipe(Vertex.class)).has(key, value);
    }

    public GremlinPipeline<S, Edge> E(String key, Object value) {
        return this.add((Pipe)new GraphQueryPipe(Edge.class)).has(key, value);
    }

    @Override
    public GremlinPipeline<S, ? extends Element> has(String key) {
        return this.has(key, Tokens.T.neq, null);
    }

    @Override
    public GremlinPipeline<S, ? extends Element> has(String key, Object value) {
        return this.has(key, Tokens.T.eq, value);
    }

    @Override
    public GremlinPipeline<S, ? extends Element> has(String key, Tokens.T compareToken, Object value) {
        return this.has(key, Tokens.mapPredicate(compareToken), value);
    }

    @Override
    public GremlinPipeline<S, ? extends Element> has(String key, Predicate predicate, Object value) {
        if (key.equals("id")) {
            return this.add((Pipe)new IdFilterPipe(predicate, value));
        }
        if (key.equals("label")) {
            return this.add((Pipe)new LabelFilterPipe(predicate, value));
        }
        PropertyFilterPipe pipe = new PropertyFilterPipe(key, predicate, value);
        return this.doQueryOptimization ? GremlinFluentUtility.optimizePipelineForQuery(this, (Pipe)pipe) : this.add((Pipe)pipe);
    }

    @Override
    public GremlinPipeline<S, ? extends Element> hasNot(String key) {
        return this.has(key, Tokens.T.eq, null);
    }

    @Override
    public GremlinPipeline<S, ? extends Element> hasNot(String key, Object value) {
        return this.has(key, Tokens.T.neq, value);
    }

    @Override
    public GremlinPipeline<S, ? extends Element> interval(String key, Comparable startValue, Comparable endValue) {
        IntervalFilterPipe pipe = new IntervalFilterPipe(key, startValue, endValue);
        return this.doQueryOptimization ? GremlinFluentUtility.optimizePipelineForQuery(this, (Pipe)pipe) : this.add((Pipe)pipe);
    }

    @Override
    public GremlinPipeline<S, Edge> bothE(String ... labels) {
        return this.bothE(Integer.MAX_VALUE, labels);
    }

    @Override
    public GremlinPipeline<S, Edge> bothE(int branchFactor, String ... labels) {
        return this.doQueryOptimization ? this.add((Pipe)new VertexQueryPipe(Edge.class, Direction.BOTH, null, null, branchFactor, 0, Integer.MAX_VALUE, labels)) : this.add((Pipe)new BothEdgesPipe(branchFactor, labels));
    }

    @Override
    public GremlinPipeline<S, Vertex> both(String ... labels) {
        return this.both(Integer.MAX_VALUE, labels);
    }

    @Override
    public GremlinPipeline<S, Vertex> both(int branchFactor, String ... labels) {
        return this.doQueryOptimization ? this.add((Pipe)new VertexQueryPipe(Vertex.class, Direction.BOTH, null, null, branchFactor, 0, Integer.MAX_VALUE, labels)) : this.add((Pipe)new BothPipe(branchFactor, labels));
    }

    @Override
    public GremlinPipeline<S, Vertex> bothV() {
        return this.add((Pipe)new BothVerticesPipe());
    }

    @Override
    public GremlinPipeline<S, Edge> idEdge(Graph graph) {
        return this.add((Pipe)new IdEdgePipe(graph));
    }

    @Override
    public GremlinPipeline<S, Object> id() {
        return this.add((Pipe)new IdPipe());
    }

    @Override
    public GremlinPipeline<S, Vertex> idVertex(Graph graph) {
        return this.add((Pipe)new IdVertexPipe(graph));
    }

    @Override
    public GremlinPipeline<S, Edge> inE(String ... labels) {
        return this.inE(Integer.MAX_VALUE, labels);
    }

    @Override
    public GremlinPipeline<S, Edge> inE(int branchFactor, String ... labels) {
        return this.doQueryOptimization ? this.add((Pipe)new VertexQueryPipe(Edge.class, Direction.IN, null, null, branchFactor, 0, Integer.MAX_VALUE, labels)) : this.add((Pipe)new InEdgesPipe(branchFactor, labels));
    }

    @Override
    public GremlinPipeline<S, Vertex> in(String ... labels) {
        return this.in(Integer.MAX_VALUE, labels);
    }

    @Override
    public GremlinPipeline<S, Vertex> in(int branchFactor, String ... labels) {
        return this.doQueryOptimization ? this.add((Pipe)new VertexQueryPipe(Vertex.class, Direction.IN, null, null, branchFactor, 0, Integer.MAX_VALUE, labels)) : this.add((Pipe)new InPipe(branchFactor, labels));
    }

    @Override
    public GremlinPipeline<S, Vertex> inV() {
        return this.add((Pipe)new InVertexPipe());
    }

    @Override
    public GremlinPipeline<S, String> label() {
        return this.add((Pipe)new LabelPipe());
    }

    @Override
    public GremlinPipeline<S, Edge> outE(String ... labels) {
        return this.outE(Integer.MAX_VALUE, labels);
    }

    @Override
    public GremlinPipeline<S, Edge> outE(int branchFactor, String ... labels) {
        return this.doQueryOptimization ? this.add((Pipe)new VertexQueryPipe(Edge.class, Direction.OUT, null, null, branchFactor, 0, Integer.MAX_VALUE, labels)) : this.add((Pipe)new OutEdgesPipe(branchFactor, labels));
    }

    @Override
    public GremlinPipeline<S, Vertex> out(String ... labels) {
        return this.out(Integer.MAX_VALUE, labels);
    }

    @Override
    public GremlinPipeline<S, Vertex> out(int branchFactor, String ... labels) {
        return this.doQueryOptimization ? this.add((Pipe)new VertexQueryPipe(Vertex.class, Direction.OUT, null, null, branchFactor, 0, Integer.MAX_VALUE, labels)) : this.add((Pipe)new OutPipe(branchFactor, labels));
    }

    @Override
    public GremlinPipeline<S, Vertex> outV() {
        return this.add((Pipe)new OutVertexPipe());
    }

    @Override
    public GremlinPipeline<S, Map<String, Object>> map(String ... keys) {
        return this.add((Pipe)new PropertyMapPipe(keys));
    }

    @Override
    public GremlinPipeline<S, Object> property(String key) {
        return this.add((Pipe)new PropertyPipe(key));
    }

    @Override
    public GremlinPipeline<S, ?> step(PipeFunction function) {
        return this.add((Pipe)new FunctionPipe(FluentUtility.prepareFunction((AsMap)this.asMap, (PipeFunction)function)));
    }

    @Override
    public <T> GremlinPipeline<S, T> step(Pipe<E, T> pipe) {
        return this.add(pipe);
    }

    @Override
    public GremlinPipeline<S, ?> copySplit(Pipe<E, ?> ... pipes) {
        return this.add((Pipe)new CopySplitPipe(pipes));
    }

    @Override
    public GremlinPipeline<S, ?> exhaustMerge() {
        return this.add((Pipe)new ExhaustMergePipe(((MetaPipe)FluentUtility.getPreviousPipe((Pipeline)this)).getPipes()));
    }

    @Override
    public GremlinPipeline<S, ?> fairMerge() {
        return this.add((Pipe)new FairMergePipe(((MetaPipe)FluentUtility.getPreviousPipe((Pipeline)this)).getPipes()));
    }

    @Override
    public GremlinPipeline<S, ?> ifThenElse(PipeFunction<E, Boolean> ifFunction, PipeFunction<E, ?> thenFunction, PipeFunction<E, ?> elseFunction) {
        return this.add((Pipe)new IfThenElsePipe(FluentUtility.prepareFunction((AsMap)this.asMap, ifFunction), FluentUtility.prepareFunction((AsMap)this.asMap, thenFunction), FluentUtility.prepareFunction((AsMap)this.asMap, elseFunction)));
    }

    @Override
    @Deprecated
    public GremlinPipeline<S, E> loop(int numberedStep, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> whileFunction) {
        return this.add((Pipe)new LoopPipe((Pipe)new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, (int)numberedStep)), FluentUtility.prepareFunction((AsMap)this.asMap, whileFunction)));
    }

    @Override
    public GremlinPipeline<S, E> loop(String namedStep, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> whileFunction) {
        return this.add((Pipe)new LoopPipe((Pipe)new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, (String)namedStep)), FluentUtility.prepareFunction((AsMap)this.asMap, whileFunction)));
    }

    @Override
    @Deprecated
    public GremlinPipeline<S, E> loop(int numberedStep, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> whileFunction, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> emitFunction) {
        return this.add((Pipe)new LoopPipe((Pipe)new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, (int)numberedStep)), FluentUtility.prepareFunction((AsMap)this.asMap, whileFunction), FluentUtility.prepareFunction((AsMap)this.asMap, emitFunction)));
    }

    @Override
    public GremlinPipeline<S, E> loop(String namedStep, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> whileFunction, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> emitFunction) {
        return this.add((Pipe)new LoopPipe((Pipe)new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, (String)namedStep)), FluentUtility.prepareFunction((AsMap)this.asMap, whileFunction), FluentUtility.prepareFunction((AsMap)this.asMap, emitFunction)));
    }

    @Override
    public GremlinPipeline<S, E> and(Pipe<E, ?> ... pipes) {
        return this.add((Pipe)new AndFilterPipe(pipes));
    }

    @Override
    @Deprecated
    public GremlinPipeline<S, ?> back(int numberedStep) {
        return this.add((Pipe)new BackFilterPipe((Pipe)new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, (int)numberedStep))));
    }

    @Override
    public GremlinPipeline<S, ?> back(String namedStep) {
        return this.add((Pipe)new BackFilterPipe((Pipe)new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, (String)namedStep))));
    }

    @Override
    public GremlinPipeline<S, E> dedup() {
        return this.add((Pipe)new DuplicateFilterPipe());
    }

    @Override
    public GremlinPipeline<S, E> dedup(PipeFunction<E, ?> dedupFunction) {
        return this.add((Pipe)new DuplicateFilterPipe(FluentUtility.prepareFunction((AsMap)this.asMap, dedupFunction)));
    }

    @Override
    public GremlinPipeline<S, E> except(Collection<E> collection) {
        return this.add((Pipe)new ExceptFilterPipe(collection));
    }

    @Override
    public GremlinPipeline<S, E> except(String ... namedSteps) {
        return this.add((Pipe)new ExceptFilterPipe(this.asMap, namedSteps));
    }

    @Override
    public GremlinPipeline<S, E> filter(PipeFunction<E, Boolean> filterFunction) {
        return this.add((Pipe)new FilterFunctionPipe(FluentUtility.prepareFunction((AsMap)this.asMap, filterFunction)));
    }

    @Override
    public GremlinPipeline<S, E> or(Pipe<E, ?> ... pipes) {
        return this.add((Pipe)new OrFilterPipe(pipes));
    }

    @Override
    public GremlinPipeline<S, E> random(Double bias) {
        return this.add((Pipe)new RandomFilterPipe(bias.doubleValue()));
    }

    @Override
    public GremlinPipeline<S, E> range(int low, int high) {
        RangeFilterPipe pipe = new RangeFilterPipe(low, high);
        if (!this.doQueryOptimization) {
            return this.add((Pipe)pipe);
        }
        return GremlinFluentUtility.optimizePipelineForQuery(this, (Pipe)pipe);
    }

    @Override
    public GremlinPipeline<S, E> retain(Collection<E> collection) {
        return this.add((Pipe)new RetainFilterPipe(collection));
    }

    @Override
    public GremlinPipeline<S, E> retain(String ... namedSteps) {
        return this.add((Pipe)new RetainFilterPipe(this.asMap, namedSteps));
    }

    @Override
    public GremlinPipeline<S, E> simplePath() {
        return this.add((Pipe)new CyclicPathFilterPipe());
    }

    @Override
    public GremlinPipeline<S, E> aggregate() {
        return this.aggregate((Collection)new ArrayList());
    }

    @Override
    public GremlinPipeline<S, E> aggregate(Collection<E> aggregate) {
        return this.add((Pipe)new AggregatePipe(aggregate));
    }

    @Override
    public GremlinPipeline<S, E> aggregate(Collection aggregate, PipeFunction<E, ?> aggregateFunction) {
        return this.add((Pipe)new AggregatePipe(aggregate, FluentUtility.prepareFunction((AsMap)this.asMap, aggregateFunction)));
    }

    @Override
    public GremlinPipeline<S, E> aggregate(PipeFunction<E, ?> aggregateFunction) {
        return this.aggregate((Collection)new ArrayList(), FluentUtility.prepareFunction((AsMap)this.asMap, aggregateFunction));
    }

    @Override
    @Deprecated
    public GremlinPipeline<S, ?> optional(int numberedStep) {
        return this.add((Pipe)new OptionalPipe((Pipe)new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, (int)numberedStep))));
    }

    @Override
    public GremlinPipeline<S, ?> optional(String namedStep) {
        return this.add((Pipe)new OptionalPipe((Pipe)new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, (String)namedStep))));
    }

    @Override
    public GremlinPipeline<S, E> groupBy(Map<?, List<?>> map, PipeFunction keyFunction, PipeFunction valueFunction) {
        return this.add((Pipe)new GroupByPipe(map, FluentUtility.prepareFunction((AsMap)this.asMap, (PipeFunction)keyFunction), FluentUtility.prepareFunction((AsMap)this.asMap, (PipeFunction)valueFunction)));
    }

    @Override
    public GremlinPipeline<S, E> groupBy(PipeFunction keyFunction, PipeFunction valueFunction) {
        return this.add((Pipe)new GroupByPipe(FluentUtility.prepareFunction((AsMap)this.asMap, (PipeFunction)keyFunction), FluentUtility.prepareFunction((AsMap)this.asMap, (PipeFunction)valueFunction)));
    }

    @Override
    public GremlinPipeline<S, E> groupBy(Map reduceMap, PipeFunction keyFunction, PipeFunction valueFunction, PipeFunction reduceFunction) {
        return this.add((Pipe)new GroupByReducePipe(reduceMap, FluentUtility.prepareFunction((AsMap)this.asMap, (PipeFunction)keyFunction), FluentUtility.prepareFunction((AsMap)this.asMap, (PipeFunction)valueFunction), FluentUtility.prepareFunction((AsMap)this.asMap, (PipeFunction)reduceFunction)));
    }

    @Override
    public GremlinPipeline<S, E> groupBy(PipeFunction keyFunction, PipeFunction valueFunction, PipeFunction reduceFunction) {
        return this.add((Pipe)new GroupByReducePipe(FluentUtility.prepareFunction((AsMap)this.asMap, (PipeFunction)keyFunction), FluentUtility.prepareFunction((AsMap)this.asMap, (PipeFunction)valueFunction), FluentUtility.prepareFunction((AsMap)this.asMap, (PipeFunction)reduceFunction)));
    }

    @Override
    public GremlinPipeline<S, E> groupCount(Map<?, Number> map, PipeFunction keyFunction, PipeFunction<Pair<?, Number>, Number> valueFunction) {
        return this.add((Pipe)new GroupCountFunctionPipe(map, FluentUtility.prepareFunction((AsMap)this.asMap, (PipeFunction)keyFunction), FluentUtility.prepareFunction((AsMap)this.asMap, valueFunction)));
    }

    @Override
    public GremlinPipeline<S, E> groupCount(PipeFunction keyFunction, PipeFunction<Pair<?, Number>, Number> valueFunction) {
        return this.add((Pipe)new GroupCountFunctionPipe(FluentUtility.prepareFunction((AsMap)this.asMap, (PipeFunction)keyFunction), FluentUtility.prepareFunction((AsMap)this.asMap, valueFunction)));
    }

    @Override
    public GremlinPipeline<S, E> groupCount(Map<?, Number> map, PipeFunction keyFunction) {
        return this.add((Pipe)new GroupCountFunctionPipe(map, FluentUtility.prepareFunction((AsMap)this.asMap, (PipeFunction)keyFunction), null));
    }

    @Override
    public GremlinPipeline<S, E> groupCount(PipeFunction keyFunction) {
        return this.add((Pipe)new GroupCountFunctionPipe(FluentUtility.prepareFunction((AsMap)this.asMap, (PipeFunction)keyFunction), null));
    }

    @Override
    public GremlinPipeline<S, E> groupCount(Map<?, Number> map) {
        return this.add((Pipe)new GroupCountPipe(map));
    }

    @Override
    public GremlinPipeline<S, E> groupCount() {
        return this.add((Pipe)new GroupCountPipe());
    }

    @Override
    public GremlinPipeline<S, Vertex> linkOut(String label, String namedStep) {
        return this.add((Pipe)new LinkPipe(Direction.OUT, label, FluentUtility.getAsPipe((MetaPipe)this, (String)namedStep)));
    }

    @Override
    public GremlinPipeline<S, Vertex> linkIn(String label, String namedStep) {
        return this.add((Pipe)new LinkPipe(Direction.IN, label, FluentUtility.getAsPipe((MetaPipe)this, (String)namedStep)));
    }

    @Override
    public GremlinPipeline<S, Vertex> linkBoth(String label, String namedStep) {
        return this.add((Pipe)new LinkPipe(Direction.BOTH, label, FluentUtility.getAsPipe((MetaPipe)this, (String)namedStep)));
    }

    @Override
    public GremlinPipeline<S, Vertex> linkOut(String label, Vertex other) {
        return this.add((Pipe)new LinkPipe(Direction.OUT, label, other));
    }

    @Override
    public GremlinPipeline<S, Vertex> linkIn(String label, Vertex other) {
        return this.add((Pipe)new LinkPipe(Direction.IN, label, other));
    }

    @Override
    public GremlinPipeline<S, Vertex> linkBoth(String label, Vertex other) {
        return this.add((Pipe)new LinkPipe(Direction.BOTH, label, other));
    }

    @Override
    public GremlinPipeline<S, E> sideEffect(PipeFunction<E, ?> sideEffectFunction) {
        return this.add((Pipe)new SideEffectFunctionPipe(FluentUtility.prepareFunction((AsMap)this.asMap, sideEffectFunction)));
    }

    @Override
    public GremlinPipeline<S, E> store(Collection<E> storage) {
        return this.add((Pipe)new StorePipe(storage));
    }

    @Override
    public GremlinPipeline<S, E> store(Collection storage, PipeFunction<E, ?> storageFunction) {
        return this.add((Pipe)new StorePipe(storage, FluentUtility.prepareFunction((AsMap)this.asMap, storageFunction)));
    }

    @Override
    public GremlinPipeline<S, E> store() {
        return this.store((Collection)new ArrayList());
    }

    @Override
    public GremlinPipeline<S, E> store(PipeFunction<E, ?> storageFunction) {
        return this.store((Collection)new ArrayList(), FluentUtility.prepareFunction((AsMap)this.asMap, storageFunction));
    }

    @Override
    public GremlinPipeline<S, E> table(Table table, Collection<String> stepNames, PipeFunction ... columnFunctions) {
        return this.add((Pipe)new TablePipe(table, stepNames, FluentUtility.getAsPipes((MetaPipe)this), FluentUtility.prepareFunctions((AsMap)this.asMap, (PipeFunction[])columnFunctions)));
    }

    @Override
    public GremlinPipeline<S, E> table(Table table, PipeFunction ... columnFunctions) {
        return this.add((Pipe)new TablePipe(table, null, FluentUtility.getAsPipes((MetaPipe)this), FluentUtility.prepareFunctions((AsMap)this.asMap, (PipeFunction[])columnFunctions)));
    }

    @Override
    public GremlinPipeline<S, E> table(PipeFunction ... columnFunctions) {
        return this.add((Pipe)new TablePipe(new Table(), null, FluentUtility.getAsPipes((MetaPipe)this), FluentUtility.prepareFunctions((AsMap)this.asMap, (PipeFunction[])columnFunctions)));
    }

    @Override
    public GremlinPipeline<S, E> table(Table table) {
        return this.add((Pipe)new TablePipe(table, null, FluentUtility.getAsPipes((MetaPipe)this), new PipeFunction[0]));
    }

    @Override
    public GremlinPipeline<S, E> table() {
        return this.add((Pipe)new TablePipe(new Table(), null, FluentUtility.getAsPipes((MetaPipe)this), new PipeFunction[0]));
    }

    @Override
    public GremlinPipeline<S, E> tree(Tree tree, PipeFunction ... branchFunctions) {
        return this.add((Pipe)new TreePipe(tree, FluentUtility.prepareFunctions((AsMap)this.asMap, (PipeFunction[])branchFunctions)));
    }

    @Override
    public GremlinPipeline<S, E> tree(PipeFunction ... branchFunctions) {
        return this.add((Pipe)new TreePipe(FluentUtility.prepareFunctions((AsMap)this.asMap, (PipeFunction[])branchFunctions)));
    }

    @Override
    public GremlinPipeline<S, List> gather() {
        return this.add((Pipe)new GatherPipe());
    }

    @Override
    public GremlinPipeline<S, ?> gather(PipeFunction<List, ?> function) {
        return this.add((Pipe)new GatherFunctionPipe(FluentUtility.prepareFunction((AsMap)this.asMap, function)));
    }

    @Override
    public GremlinPipeline<S, E> _() {
        return this.add((Pipe)new IdentityPipe());
    }

    @Override
    public GremlinPipeline<S, E> memoize(String namedStep) {
        return this.add((Pipe)new MemoizePipe((Pipe)new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, (String)namedStep))));
    }

    @Override
    @Deprecated
    public GremlinPipeline<S, E> memoize(int numberedStep) {
        return this.add((Pipe)new MemoizePipe((Pipe)new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, (int)numberedStep))));
    }

    @Override
    public GremlinPipeline<S, E> memoize(String namedStep, Map map) {
        return this.add((Pipe)new MemoizePipe((Pipe)new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, (String)namedStep)), map));
    }

    @Override
    @Deprecated
    public GremlinPipeline<S, E> memoize(int numberedStep, Map map) {
        return this.add((Pipe)new MemoizePipe((Pipe)new Pipeline(FluentUtility.removePreviousPipes((Pipeline)this, (int)numberedStep)), map));
    }

    @Override
    public GremlinPipeline<S, E> order() {
        return this.add((Pipe)new OrderPipe());
    }

    @Override
    public GremlinPipeline<S, E> order(TransformPipe.Order order) {
        return this.add((Pipe)new OrderPipe(order));
    }

    public GremlinPipeline<S, E> order(Tokens.T order) {
        return this.add((Pipe)new OrderPipe(Tokens.mapOrder(order)));
    }

    @Override
    public GremlinPipeline<S, E> order(PipeFunction<Pair<E, E>, Integer> compareFunction) {
        return this.add((Pipe)new OrderPipe(FluentUtility.prepareFunction((AsMap)this.asMap, compareFunction)));
    }

    @Override
    public GremlinPipeline<S, List> path(PipeFunction ... pathFunctions) {
        return this.add((Pipe)new PathPipe(FluentUtility.prepareFunctions((AsMap)this.asMap, (PipeFunction[])pathFunctions)));
    }

    @Override
    public GremlinPipeline<S, ?> scatter() {
        return this.add((Pipe)new ScatterPipe());
    }

    @Override
    public GremlinPipeline<S, Row> select(Collection<String> stepNames, PipeFunction ... columnFunctions) {
        return this.add((Pipe)new SelectPipe(stepNames, FluentUtility.getAsPipes((MetaPipe)this), FluentUtility.prepareFunctions((AsMap)this.asMap, (PipeFunction[])columnFunctions)));
    }

    @Override
    public GremlinPipeline<S, Row> select(PipeFunction ... columnFunctions) {
        return this.add((Pipe)new SelectPipe(null, FluentUtility.getAsPipes((MetaPipe)this), FluentUtility.prepareFunctions((AsMap)this.asMap, (PipeFunction[])columnFunctions)));
    }

    @Override
    public GremlinPipeline<S, Row> select() {
        return this.add((Pipe)new SelectPipe(null, FluentUtility.getAsPipes((MetaPipe)this), new PipeFunction[0]));
    }

    @Override
    public GremlinPipeline<S, List> shuffle() {
        return this.add((Pipe)new ShufflePipe());
    }

    @Override
    public GremlinPipeline<S, ?> cap() {
        return this.add((Pipe)new SideEffectCapPipe((SideEffectPipe)FluentUtility.removePreviousPipes((Pipeline)this, (int)1).get(0)));
    }

    @Override
    public GremlinPipeline<S, ?> orderMap(TransformPipe.Order order) {
        return this.add((Pipe)new OrderMapPipe(order));
    }

    public GremlinPipeline<S, ?> orderMap(Tokens.T order) {
        return this.orderMap(Tokens.mapOrder(order));
    }

    @Override
    public GremlinPipeline<S, ?> orderMap(PipeFunction<Pair<Map.Entry, Map.Entry>, Integer> compareFunction) {
        return this.add((Pipe)new OrderMapPipe(FluentUtility.prepareFunction((AsMap)this.asMap, compareFunction)));
    }

    @Override
    public <T> GremlinPipeline<S, T> transform(PipeFunction<E, T> function) {
        return this.add((Pipe<?, T>)new TransformFunctionPipe(FluentUtility.prepareFunction((AsMap)this.asMap, function)));
    }

    @Override
    public GremlinPipeline<S, E> as(String name) {
        GremlinPipeline pipeline = this.add((Pipe)new AsPipe(name, (Pipe)FluentUtility.removePreviousPipes((Pipeline)this, (int)1).get(0)));
        this.asMap.refresh();
        return pipeline;
    }

    @Override
    public GremlinPipeline<S, S> start(S object) {
        this.add((Pipe)new StartPipe(object));
        FluentUtility.setStarts((Pipeline)this, object);
        return this;
    }

    @Override
    public long count() {
        return PipeHelper.counter((Iterator)((Object)this));
    }

    @Override
    public void iterate() {
        PipeHelper.iterate((Iterator)((Object)this));
    }

    @Override
    public List<E> next(int number) {
        ArrayList list = new ArrayList(number);
        PipeHelper.fillCollection((Iterator)((Object)this), list, (int)number);
        return list;
    }

    @Override
    public List<E> toList() {
        ArrayList list = new ArrayList();
        PipeHelper.fillCollection((Iterator)((Object)this), list);
        return list;
    }

    @Override
    public Collection<E> fill(Collection<E> collection) {
        PipeHelper.fillCollection((Iterator)((Object)this), collection);
        return collection;
    }

    @Override
    public GremlinPipeline<S, E> enablePath() {
        this.enablePath(true);
        return this;
    }

    public GremlinPipeline<S, E> optimize(boolean optimize) {
        this.doQueryOptimization = optimize;
        return this;
    }

    public void remove() {
        Iterator i$ = this.iterator();
        while (i$.hasNext()) {
            Object object = i$.next();
            ((Element)object).remove();
        }
    }

    @Override
    public <E> GremlinPipeline<S, E> cast(Class<E> end) {
        return this;
    }
}

