/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.nearcache;

import com.hazelcast.core.EntryEventType;
import com.hazelcast.core.HazelcastInstance;
import com.hazelcast.core.LifecycleEvent;
import com.hazelcast.core.LifecycleListener;
import com.hazelcast.core.LifecycleService;
import com.hazelcast.core.Member;
import com.hazelcast.instance.GroupProperties;
import com.hazelcast.instance.GroupProperty;
import com.hazelcast.map.impl.EventListenerFilter;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.nearcache.AbstractNearCacheInvalidator;
import com.hazelcast.map.impl.nearcache.BatchNearCacheInvalidation;
import com.hazelcast.map.impl.nearcache.CleaningNearCacheInvalidation;
import com.hazelcast.map.impl.nearcache.Invalidation;
import com.hazelcast.map.impl.nearcache.NearCacheProvider;
import com.hazelcast.map.impl.nearcache.SingleNearCacheInvalidation;
import com.hazelcast.map.impl.operation.MapOperation;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.spi.EventFilter;
import com.hazelcast.spi.EventRegistration;
import com.hazelcast.spi.ExecutionService;
import com.hazelcast.util.ConcurrencyUtil;
import com.hazelcast.util.ConstructorFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class BatchInvalidator
extends AbstractNearCacheInvalidator {
    private static final String INVALIDATION_EXECUTOR_NAME = BatchInvalidator.class.getName();
    private final ConstructorFunction<String, InvalidationQueue> invalidationQueueConstructor = new ConstructorFunction<String, InvalidationQueue>(){

        @Override
        public InvalidationQueue createNew(String mapName) {
            return new InvalidationQueue();
        }
    };
    private final ConcurrentMap<String, InvalidationQueue> invalidationQueues = new ConcurrentHashMap<String, InvalidationQueue>();
    private String listenerRegistrationId;
    private final int batchSize = this.getBatchSize();

    BatchInvalidator(MapServiceContext mapServiceContext, NearCacheProvider nearCacheProvider) {
        super(mapServiceContext, nearCacheProvider);
        this.startBackgroundBatchProcessor();
        this.handleBatchesOnNodeShutdown();
    }

    @Override
    public void invalidate(String mapName, Data key, String sourceUuid) {
        this.invalidateInternal(mapName, key, null, sourceUuid);
    }

    @Override
    public void invalidate(String mapName, List<Data> keys, String sourceUuid) {
        this.invalidateInternal(mapName, null, keys, sourceUuid);
    }

    @Override
    public void sendClientNearCacheClearEvent(String mapName, String sourceUuid) {
        this.invalidateClient(new CleaningNearCacheInvalidation(mapName, sourceUuid));
    }

    private void invalidateInternal(String mapName, Data key, List<Data> keys, String sourceUuid) {
        this.accumulateOrInvalidate(mapName, key, keys, sourceUuid);
        this.invalidateLocal(mapName, key, keys);
    }

    @Override
    public void destroy(String mapName) {
        InvalidationQueue invalidationQueue = (InvalidationQueue)this.invalidationQueues.remove(mapName);
        if (invalidationQueue != null) {
            this.invalidateClient(new CleaningNearCacheInvalidation(mapName, null));
        }
    }

    @Override
    public void shutdown() {
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        executionService.shutdownExecutor(INVALIDATION_EXECUTOR_NAME);
        HazelcastInstance node = this.nodeEngine.getHazelcastInstance();
        LifecycleService lifecycleService = node.getLifecycleService();
        lifecycleService.removeLifecycleListener(this.listenerRegistrationId);
        this.invalidationQueues.clear();
    }

    @Override
    public void reset() {
        this.invalidationQueues.clear();
    }

    public void accumulateOrInvalidate(String mapName, Data key, List<Data> keys, String sourceUuid) {
        if (!this.mapServiceContext.getMapContainer(mapName).isInvalidationEnabled()) {
            return;
        }
        InvalidationQueue invalidationQueue = ConcurrencyUtil.getOrPutIfAbsent(this.invalidationQueues, mapName, this.invalidationQueueConstructor);
        if (key != null) {
            invalidationQueue.offer(new SingleNearCacheInvalidation(mapName, this.toHeapData(key), sourceUuid));
        }
        if (keys != null) {
            for (Data data : keys) {
                invalidationQueue.offer(new SingleNearCacheInvalidation(mapName, this.toHeapData(data), sourceUuid));
            }
        }
        if (invalidationQueue.size() >= this.batchSize) {
            this.sendBatch(mapName, invalidationQueue);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendBatch(String mapName, InvalidationQueue invalidationQueue) {
        SingleNearCacheInvalidation invalidation;
        if (invalidationQueue == null) {
            return;
        }
        if (!invalidationQueue.tryAcquire()) {
            return;
        }
        int size = Math.min(this.batchSize, invalidationQueue.size());
        BatchNearCacheInvalidation batch = new BatchNearCacheInvalidation(mapName, size);
        for (int i = 0; i < size && (invalidation = invalidationQueue.poll()) != null; ++i) {
            batch.add(invalidation);
        }
        try {
            this.invalidateMember(batch);
            this.invalidateClient(batch);
        }
        finally {
            invalidationQueue.release();
        }
    }

    private void invalidateClient(Invalidation invalidation) {
        String mapName = invalidation.getName();
        if (!this.hasInvalidationListener(mapName)) {
            return;
        }
        Collection<EventRegistration> registrations = this.eventService.getRegistrations("hz:impl:mapService", mapName);
        for (EventRegistration registration : registrations) {
            EventFilter filter = registration.getFilter();
            if (!(filter instanceof EventListenerFilter) || !filter.eval(EntryEventType.INVALIDATION.getType())) continue;
            Object orderKey = BatchInvalidator.getOrderKey(mapName, invalidation);
            this.eventService.publishEvent("hz:impl:mapService", registration, (Object)invalidation, orderKey.hashCode());
        }
    }

    protected void invalidateMember(BatchNearCacheInvalidation batch) {
        String mapName = batch.getName();
        if (!this.isMemberNearCacheInvalidationEnabled(mapName)) {
            return;
        }
        MapOperation operation = null;
        Set<Member> members = this.clusterService.getMembers();
        for (Member member : members) {
            if (member.localMember()) continue;
            if (operation == null) {
                operation = BatchInvalidator.createSingleOrBatchInvalidationOperation(mapName, null, BatchInvalidator.getKeys(batch));
            }
            this.operationService.send(operation, member.getAddress());
        }
    }

    public static List<Data> getKeys(BatchNearCacheInvalidation batch) {
        return BatchInvalidator.getKeysExcludingSource(batch, null);
    }

    public static List<Data> getKeysExcludingSource(BatchNearCacheInvalidation batch, String excludedSourceUuid) {
        List<SingleNearCacheInvalidation> invalidations = batch.getInvalidations();
        ArrayList<Data> keyList = null;
        for (SingleNearCacheInvalidation invalidation : invalidations) {
            if (excludedSourceUuid != null && invalidation.getSourceUuid().equals(excludedSourceUuid)) continue;
            if (keyList == null) {
                keyList = new ArrayList<Data>(invalidations.size());
            }
            keyList.add(invalidation.getKey());
        }
        return keyList == null ? Collections.EMPTY_LIST : keyList;
    }

    private void handleBatchesOnNodeShutdown() {
        HazelcastInstance node = this.nodeEngine.getHazelcastInstance();
        LifecycleService lifecycleService = node.getLifecycleService();
        this.listenerRegistrationId = lifecycleService.addLifecycleListener(new LifecycleListener(){

            @Override
            public void stateChanged(LifecycleEvent event) {
                if (event.getState() == LifecycleEvent.LifecycleState.SHUTTING_DOWN) {
                    Set entries = BatchInvalidator.this.invalidationQueues.entrySet();
                    for (Map.Entry entry : entries) {
                        BatchInvalidator.this.sendBatch((String)entry.getKey(), (InvalidationQueue)entry.getValue());
                    }
                }
            }
        });
    }

    private void startBackgroundBatchProcessor() {
        int periodSeconds = this.getBackgroundProcessorRunPeriodSeconds();
        ExecutionService executionService = this.nodeEngine.getExecutionService();
        executionService.scheduleAtFixedRate(INVALIDATION_EXECUTOR_NAME, new MapBatchInvalidationEventSender(), periodSeconds, periodSeconds, TimeUnit.SECONDS);
    }

    private int getBatchSize() {
        GroupProperties groupProperties = this.nodeEngine.getGroupProperties();
        return groupProperties.getInteger(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_SIZE);
    }

    private int getBackgroundProcessorRunPeriodSeconds() {
        GroupProperties groupProperties = this.nodeEngine.getGroupProperties();
        return groupProperties.getInteger(GroupProperty.MAP_INVALIDATION_MESSAGE_BATCH_FREQUENCY_SECONDS);
    }

    private static class InvalidationQueue
    extends ConcurrentLinkedQueue<SingleNearCacheInvalidation> {
        private final AtomicInteger elementCount = new AtomicInteger(0);
        private final AtomicBoolean flushingInProgress = new AtomicBoolean(false);

        private InvalidationQueue() {
        }

        @Override
        public int size() {
            return this.elementCount.get();
        }

        @Override
        public boolean offer(SingleNearCacheInvalidation invalidation) {
            boolean offered = super.offer(invalidation);
            if (offered) {
                this.elementCount.incrementAndGet();
            }
            return offered;
        }

        @Override
        public SingleNearCacheInvalidation poll() {
            SingleNearCacheInvalidation invalidation = (SingleNearCacheInvalidation)super.poll();
            if (invalidation != null) {
                this.elementCount.decrementAndGet();
            }
            return invalidation;
        }

        public boolean tryAcquire() {
            return this.flushingInProgress.compareAndSet(false, true);
        }

        public void release() {
            this.flushingInProgress.set(false);
        }

        @Override
        public boolean add(SingleNearCacheInvalidation invalidation) {
            throw new UnsupportedOperationException();
        }

        @Override
        public SingleNearCacheInvalidation remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection<? extends SingleNearCacheInvalidation> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }
    }

    private class MapBatchInvalidationEventSender
    implements Runnable {
        private MapBatchInvalidationEventSender() {
        }

        @Override
        public void run() {
            for (Map.Entry entry : BatchInvalidator.this.invalidationQueues.entrySet()) {
                if (Thread.currentThread().isInterrupted()) break;
                String mapName = (String)entry.getKey();
                InvalidationQueue invalidationQueue = (InvalidationQueue)entry.getValue();
                if (invalidationQueue.size() <= 0) continue;
                BatchInvalidator.this.sendBatch(mapName, invalidationQueue);
            }
        }
    }
}

