# OssImport

## 关于
OssImport可以将本地、其它云存储的数据迁移到OSS，它有以下特点：
- 支持的丰富的数据源，包括本地、七牛、百度BOS、AWS S3、Azure Blob、又拍云、腾讯云COS、金山KS3、HTTP、OSS等，并可根据需求扩展；
- 支持断点续传；
- 支持流量控制；
- 支持迁移指定时间后的文件、特定前缀的文件；
- 支持并行数据下载、上传；
- 支持单机模式和分布式模式，单机模式部署简单使用方便，分布式模式适合大规模数据迁移。

## 运行环境
- Java 1.7及以上。

## 部署方式

按照部署方式，OssImport可以分为*单机模式*和*分布式模式*，对于小于 ***1TB*** 的小规模数据数据迁移，单机模式即可完成。对于大规模的数据迁移，请使用分布式模式。

## 基本概念
- Job：数据迁移任务，对用户来说一个任务对应一个配置文件`job.cfg`；
- Task：数据迁移任务的子任务，任务按照 ***数据大小*** 和 ***文件个数*** 可以分成多个子任务*Task*，每个*Task*迁移部分文件。

## 文件目录
分布式模式的文件结构如下：
```
ossimport
├── bin
│   ├── console.jar     # Console模块jar包
│   ├── master.jar      # Master模块jar包
│   ├── tracker.jar     # Tracker模块jar包
│   └── worker.jar      # Worker模块jar包
├── conf
│   ├── job.cfg         # Job配置文件模板
│   ├── sys.properties  # 系统运行参数配置文件
│   └── workers         # Worker列表
├── console.sh          # 命令行工具，目前支持只Linux
├── logs                # 日志目录
└── README.md           # 说明文档，使用前请仔细阅读
```

**注意：**
- 配置文件 `sys.properties` 、 `job.cfg` 、 `workers`，请根据实际参数配置；
- `README.md`说明文档，使用前请仔细阅读；
- `console.sh` 为Linux系统下的命令行工具，Windows暂不支持；
- 执行命令时请确保当前目录是为 `console.sh` 的同级目录，即直接执行 *bash import.sh cmd*。

## 运行服务

### 修改配置文件
- `conf/job.cfg`：分布式模式下任务的配置文件模板，数据迁移前请按照实际参数修改；
- `conf/sys.properties`：系统运行参数配置文件，如工作目录、Worker运行参数等请在该文件中配置；
- `conf/workers`：worker列表。

### 执行命令

分布式部署时，执行任务的一般步骤是 *修改任务配置文件*、*部署服务*、*清除同名任务*、*提交任务*、*启动迁移服务*、*重试失败子任务*、*停止迁移任务*。详细说明如下：
- 部署服务。执行Linux终端执行 bash console.sh deploy。**部署前请保证配置文件 conf/job.cfg、conf/workers 已经修改完成**。
- 清除同名任务。如果运行过同名任务，需要从新执行任务，请先清除同名任务。如果没有运行过，或需要重试失败任务，不需要执行清除命令。Linux终端中执行 `bash console.sh clean job_name`。
- 提交数据迁移任务。OssImport不能重复提交同名任务，如果有请请使用`clean`命令清除。提交任务需要指定任务的配置文件，任务的配置文件模板在 `conf/job.cfg`，建议在模板的基础上修改。Linux终端执行 `bash console.sh submit [job_cfg_file]`，提交配置文件为 *job_cfg_file* 的任务，`job_cfg_file` 为可选参数，不指定是默认为 `$OSS_IMPORT_HOME/conf/job.cfg`，`$OSS_IMPORT_HOME` 默认为 `console.sh` 所在的目录。
- 启动服务。Linux终端执行 `bash console.sh start`。
- 失败Task重试。由于网络或其它原因，Task可能运行失败。失败重试只重试失败的Task，成功的Task不会重试。Linux下在终端执行 `bash console.sh retry [job_name]`，*job_name* 为可选参数，指定时重试任务`job_name`的失败子任务，不指定`job_name`时重试所有任务的失败子任务。
- 停止服务。Linux终端执行 `bash console.sh stop`。

**提示**：
- `bash console.sh`在参数错误时，会自动提示命令格式；
- 配置文件和提交任务中的目录，推荐使用绝对目录；
- 任务的配置，即 *job.cfg* 中的配置项，**提交后不能修改，请在提交前确定**。

## 常见任务失败原因
- 上传过程中源目录的文件发生了修改，`log/audit.log`里会提示`SIZE_NOT_MATCH`相关字样的错误，这种情况下老的文件已经上传成功，新的修改没有上传到OSS；
- 源文件在上传过程中被删除，导致下载的时候失败；
- 源文件名不符合OSS命名规范（不能以/开头，不能为空），导致上传到OSS失败；
- 下载数据源文件失败；
- 程序异常退出，任务状态为*Abort*，这种情况请联系我们。

## 建议
对于从云端（非本地）迁移到oss，且带宽资源不是很充足的用户，建议够买按量付费的ECS进行迁移(购买地址:https://ecs-buy.aliyun.com/#/postpay)。ECS配置：
- 付费方式选择按量付费；
- 地域选择OSS对应的区域；
- 带宽峰值选100M；
- 系统Linux/Windows随意；
- 其他全部选择最低配置。

在配置迁移服务时，将 *targetDomain* 设为带internal的内网域名；如果源端也是OSS，将 *srcDomain* 也设为带internal的内网域名，可以省掉从OSS源端下载的流量费，仅收取OSS访问次数的费用。
