﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Reflection;
using HarmonyLib;
using RimWorld;
using Verse;

namespace UtilityPatch
{
    [StaticConstructorOnStartup]
    public class HarmonyPatches
    {
        static HarmonyPatches()
        {
            var harmony = new Harmony("com.turnovus.utilitypatch");
            harmony.PatchAll();
        }
    }

    [HarmonyPatch(typeof(ThoughtWorker_NudistNude))]
    [HarmonyPatch("CurrentStateInternal")]
    class NudistNudePatch
    {

        static void Postfix(Pawn p, ref ThoughtState __result)
        {
            bool nudistsIgnoreUtility = LoadedModManager.GetMod<UtilityPatchMod>().GetSettings<UtilityPatchSettings>().nudistsIgnoreUtility;
            if (__result.Active || !nudistsIgnoreUtility)
                return;
            List<Apparel> wornApparel = p.apparel.WornApparel;
            bool noUtilities = true;
            foreach (Apparel apparel in wornApparel)
            {
                foreach (BodyPartGroupDef bodyPart in apparel.def.apparel.bodyPartGroups)
                {
                    if (bodyPart == BodyPartGroupDefOf.Torso || bodyPart == BodyPartGroupDefOf.Legs)
                    {
                        if (!apparel.def.apparel.layers.Contains(ApparelLayerDefOf.Belt))
                            noUtilities = false;
                    }
                }
            }
            if (noUtilities)
                __result = true;
        }

    }

}
