﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Verse;
using UnityEngine;

namespace UtilityPatch
{
    public class UtilityPatchMod : Mod
    {
        public UtilityPatchSettings settings;

        public UtilityPatchMod(ModContentPack content) : base(content)
        {
            this.settings = GetSettings<UtilityPatchSettings>();
        }

        public override void DoSettingsWindowContents(Rect inRect)
        {
            Listing_Standard listingStandard = new Listing_Standard();
            listingStandard.Begin(inRect);
            listingStandard.CheckboxLabeled("Nudists ignore utilities", ref settings.nudistsIgnoreUtility, "By default, anything worn on the legs or torso will upset nudists. This setting allows them to wear all utilities without consequence.");
            listingStandard.End();
            base.DoSettingsWindowContents(inRect);
        }

        public override string SettingsCategory()
        {
            return "Packs Are Not Belts";
        }
    }
}
