_G = GLOBAL
assert = _G.assert
error = _G.error
require = _G.require

local Highlight = require "components/highlight"

--------------------------------------------------------------------
local SELECTION_BOX_MODIFIER = assert(_G.KEY_SHIFT)
local CHERRY_PICKING_MODIFIER = SELECTION_BOX_MODIFIER

--------------------------------------------------------------------
Assets = {
	Asset( "ATLAS", "images/selection_square.xml" ),
	Asset( "IMAGE", "images/selection_square.tex" ),
}

--------------------------------------------------------------------
local function pfn(player)
	--print("start")
	player:DoTaskInTime(1,function() 
		local inst = _G.ThePlayer
		if not inst or not inst.components.playercontroller then
			player:DoTaskInTime(1,function() pfn(player) end)
			return
		end
		if not inst.components.actionqueuer then
			print("AddActionQueuerComponent")
			inst:AddComponent("actionqueuer")
			inst.components.actionqueuer:SetSelectionBoxModifier(SELECTION_BOX_MODIFIER)
			inst.components.actionqueuer:SetCherryPickingModifier(CHERRY_PICKING_MODIFIER)
			local pc = inst.components.playercontroller
			pc.OnControl = (function()
				local OnControl = pc.OnControl
				return function(self, ...)
					if not (SELECTION_BOX_MODIFIER and _G.TheInput:IsKeyDown(SELECTION_BOX_MODIFIER)) and not (CHERRY_PICKING_MODIFIER and _G.TheInput:IsKeyDown(CHERRY_PICKING_MODIFIER)) then
						if _G.TheInput:IsControlPressed(_G.CONTROL_MOVE_UP) or _G.TheInput:IsControlPressed(_G.CONTROL_MOVE_DOWN) or _G.TheInput:IsControlPressed(_G.CONTROL_PRIMARY) or
						   _G.TheInput:IsControlPressed(_G.CONTROL_MOVE_LEFT) or _G.TheInput:IsControlPressed(_G.CONTROL_MOVE_RIGHT) or _G.TheInput:IsControlPressed(_G.CONTROL_SECONDARY) or
						   _G.TheInput:IsControlPressed(_G.CONTROL_ATTACK) then
							inst.components.actionqueuer:Interrupt()
						end
						return OnControl(self, ...)
					end
				end
			end)()	
		end
	end)
end
AddPlayerPostInit(pfn)

Highlight.UnHighlight = (function()
	local UnHighlight = assert(Highlight.UnHighlight)
	return function(self, ...)
		local p = GLOBAL.ThePlayer
		if p and p.components.actionqueuer and p.components.actionqueuer:IsSelectedEntity(self.inst) then
			return
		end
		return UnHighlight(self, ...)
	end
end)()
