Scriptname ClimbScript extends Quest  

GlobalVariable Property ClimbDistanceBase Auto
GlobalVariable Property ClimbDistanceHold Auto
GlobalVariable Property ClimbDistanceHoldDecay Auto

GlobalVariable Property ClimbSkillMult Auto

GlobalVariable Property ClimbStaminaMult Auto
GlobalVariable Property ClimbStaminaSkillBase Auto
GlobalVariable Property ClimbStaminaSkillMult Auto

int KeyCode = 157 ;Right Control
String Stamina = "Stamina"
String LightArmor = "LightArmor"

Event OnInit()
	RegisterForKey(KeyCode)
endEvent

Event OnKeyUp(Int KeyCode2, float HoldTime)
	if(KeyCode2 == KeyCode)
		float ClimbDist = ClimbDistanceBase.GetValue() + (Math.Pow(HoldTime, ClimbDistanceHoldDecay.GetValue()) * ClimbDistanceHold.GetValue())
		Actor Player = Game.GetPlayer()
		float StaminaReq = ClimbDist * ClimbStaminaMult.GetValue() * Math.Pow(1 - ClimbStaminaSkillBase.GetValue(), Player.GetAv(LightArmor) * ClimbStaminaSkillMult.GetValue())
		if(Player.GetAv(Stamina) > StaminaReq)
			float AngleZ = Player.GetAngleZ()
			float PosX = Player.X + (20 * Math.Sin(AngleZ))
			float PosY = Player.Y + (20 * Math.Cos(AngleZ))
			float PosZ = Player.Z + ClimbDist
			Player.TranslateTo(PosX, PosY, PosZ, 0, 0, AngleZ, 200, 0)
			Player.DamageAv(Stamina, StaminaReq)
			Game.AdvanceSkill(LightArmor, Math.Pow(ClimbDist, ClimbSkillMult.GetValue()))
		endIf
	endIf
endEvent

Function ReRegisterKey(int KeyCode2)
	if(KeyCode2 != KeyCode)
		UnregisterForAllKeys()
		RegisterForKey(KeyCode2)
		KeyCode = KeyCode2
	endIf
endFunction

int Function GetKeyCode()
	return KeyCode
endFunction
