/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.AttrPtg;
import org.apache.poi.hssf.record.formula.BoolPtg;
import org.apache.poi.hssf.record.formula.ConcatPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.EqualPtg;
import org.apache.poi.hssf.record.formula.ErrPtg;
import org.apache.poi.hssf.record.formula.FuncPtg;
import org.apache.poi.hssf.record.formula.FuncVarPtg;
import org.apache.poi.hssf.record.formula.GreaterEqualPtg;
import org.apache.poi.hssf.record.formula.GreaterThanPtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.LessEqualPtg;
import org.apache.poi.hssf.record.formula.LessThanPtg;
import org.apache.poi.hssf.record.formula.MemAreaPtg;
import org.apache.poi.hssf.record.formula.MemErrPtg;
import org.apache.poi.hssf.record.formula.MemFuncPtg;
import org.apache.poi.hssf.record.formula.MissingArgPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.NamePtg;
import org.apache.poi.hssf.record.formula.NotEqualPtg;
import org.apache.poi.hssf.record.formula.NumberPtg;
import org.apache.poi.hssf.record.formula.OperationPtg;
import org.apache.poi.hssf.record.formula.ParenthesisPtg;
import org.apache.poi.hssf.record.formula.PercentPtg;
import org.apache.poi.hssf.record.formula.PowerPtg;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.ReferencePtg;
import org.apache.poi.hssf.record.formula.StringPtg;
import org.apache.poi.hssf.record.formula.SubtractPtg;
import org.apache.poi.hssf.record.formula.UnaryMinusPtg;
import org.apache.poi.hssf.record.formula.UnaryPlusPtg;
import org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import org.apache.poi.hssf.record.formula.function.FunctionMetadataRegistry;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public final class FormulaParser {
    public static int FORMULA_TYPE_CELL = 0;
    public static int FORMULA_TYPE_SHARED = 1;
    public static int FORMULA_TYPE_ARRAY = 2;
    public static int FORMULA_TYPE_CONDFOMRAT = 3;
    public static int FORMULA_TYPE_NAMEDRANGE = 4;
    private final String formulaString;
    private final int formulaLength;
    private int pointer;
    private final List tokens = new Stack();
    private static final Pattern CELL_REFERENCE_PATTERN = Pattern.compile("(?:('?)[^:\\\\/\\?\\*\\[\\]]+\\1!)?\\$?[A-Za-z]+\\$?[\\d]+");
    private static char TAB = (char)9;
    private char look;
    private HSSFWorkbook book;

    public FormulaParser(String formula, HSSFWorkbook book) {
        this.formulaString = formula;
        this.pointer = 0;
        this.book = book;
        this.formulaLength = this.formulaString.length();
    }

    public static Ptg[] parse(String formula, HSSFWorkbook book) {
        FormulaParser fp = new FormulaParser(formula, book);
        fp.parse();
        return fp.getRPNPtg();
    }

    private void GetChar() {
        if (this.pointer > this.formulaLength) {
            throw new RuntimeException("too far");
        }
        this.look = this.pointer < this.formulaLength ? this.formulaString.charAt(this.pointer) : (char)'\u0000';
        ++this.pointer;
    }

    private RuntimeException expected(String s) {
        return new FormulaParseException(s + " Expected");
    }

    private boolean IsAlpha(char c) {
        return Character.isLetter(c) || c == '$' || c == '_';
    }

    private boolean IsDigit(char c) {
        return Character.isDigit(c);
    }

    private boolean IsAlNum(char c) {
        return this.IsAlpha(c) || this.IsDigit(c);
    }

    private boolean IsWhite(char c) {
        return c == ' ' || c == TAB;
    }

    private void SkipWhite() {
        while (this.IsWhite(this.look)) {
            this.GetChar();
        }
    }

    private void Match(char x) {
        if (this.look != x) {
            throw this.expected("'" + x + "'");
        }
        this.GetChar();
    }

    private String GetName() {
        StringBuffer Token = new StringBuffer();
        if (!this.IsAlpha(this.look) && this.look != '\'') {
            throw this.expected("Name");
        }
        if (this.look == '\'') {
            boolean done;
            this.Match('\'');
            boolean bl = done = this.look == '\'';
            while (!done) {
                Token.append(this.look);
                this.GetChar();
                if (this.look != '\'') continue;
                this.Match('\'');
                done = this.look != '\'';
            }
        } else {
            while (this.IsAlNum(this.look)) {
                Token.append(this.look);
                this.GetChar();
            }
        }
        return Token.toString();
    }

    private String GetNum() {
        StringBuffer value = new StringBuffer();
        while (this.IsDigit(this.look)) {
            value.append(this.look);
            this.GetChar();
        }
        return value.length() == 0 ? null : value.toString();
    }

    private Ptg parseIdent() {
        String name = this.GetName();
        if (this.look == '(') {
            return this.function(name);
        }
        if (this.look == ':' || this.look == '.') {
            this.GetChar();
            while (this.look == '.') {
                this.GetChar();
            }
            String first = name;
            String second = this.GetName();
            return new AreaPtg(first + ":" + second);
        }
        if (this.look == '!') {
            this.Match('!');
            String sheetName = name;
            String first = this.GetName();
            short externIdx = this.book.getExternalSheetIndex(this.book.getSheetIndex(sheetName));
            if (this.look == ':') {
                this.Match(':');
                String second = this.GetName();
                if (this.look == '!') {
                    this.Match('!');
                    String third = this.GetName();
                    if (!sheetName.equals(second)) {
                        throw new RuntimeException("Unhandled double sheet reference.");
                    }
                    return new Area3DPtg(first + ":" + third, externIdx);
                }
                return new Area3DPtg(first + ":" + second, externIdx);
            }
            return new Ref3DPtg(first, externIdx);
        }
        if (name.equalsIgnoreCase("TRUE") || name.equalsIgnoreCase("FALSE")) {
            return new BoolPtg(name.toUpperCase());
        }
        boolean cellRef = CELL_REFERENCE_PATTERN.matcher(name).matches();
        if (cellRef) {
            return new ReferencePtg(name);
        }
        for (int i = 0; i < this.book.getNumberOfNames(); ++i) {
            if (!this.book.getNameAt(i).getNameName().equalsIgnoreCase(name)) continue;
            return new NamePtg(name, this.book);
        }
        throw new FormulaParseException("Found reference to named range \"" + name + "\", but that named range wasn't defined!");
    }

    private void addArgumentPointer(List argumentPointers) {
        argumentPointers.add(this.tokens.get(this.tokens.size() - 1));
    }

    private Ptg function(String name) {
        int numArgs = 0;
        if (!AbstractFunctionPtg.isInternalFunctionName(name)) {
            NamePtg nameToken = new NamePtg(name, this.book);
            ++numArgs;
            this.tokens.add(nameToken);
        }
        ArrayList argumentPointers = new ArrayList(2);
        this.Match('(');
        this.Match(')');
        return this.getFunction(name, numArgs += this.Arguments(argumentPointers), argumentPointers);
    }

    private int getPtgSize(int index) {
        int count = 0;
        ListIterator ptgIterator = this.tokens.listIterator(index);
        while (ptgIterator.hasNext()) {
            Ptg ptg = (Ptg)ptgIterator.next();
            count += ptg.getSize();
        }
        return count;
    }

    private int getPtgSize(int start, int end) {
        int index;
        int count = 0;
        ListIterator ptgIterator = this.tokens.listIterator(index);
        for (index = start; ptgIterator.hasNext() && index <= end; ++index) {
            Ptg ptg = (Ptg)ptgIterator.next();
            count += ptg.getSize();
        }
        return count;
    }

    private AbstractFunctionPtg getFunction(String name, int numArgs, List argumentPointers) {
        int funcIx;
        boolean isVarArgs;
        FunctionMetadata fm = FunctionMetadataRegistry.getFunctionByName(name.toUpperCase());
        if (fm == null) {
            isVarArgs = true;
            funcIx = 255;
        } else {
            isVarArgs = !fm.hasFixedArgsLength();
            funcIx = fm.getIndex();
            this.validateNumArgs(numArgs, fm);
        }
        AbstractFunctionPtg retval = isVarArgs ? new FuncVarPtg(name, (byte)numArgs) : new FuncPtg(funcIx);
        if (!name.equals("IF")) {
            return retval;
        }
        AttrPtg ifPtg = new AttrPtg();
        ifPtg.setData((short)7);
        ifPtg.setOptimizedIf(true);
        if (argumentPointers.size() != 2 && argumentPointers.size() != 3) {
            throw new IllegalArgumentException("[" + argumentPointers.size() + "] Arguments Found - An IF formula requires 2 or 3 arguments. IF(CONDITION, TRUE_VALUE, FALSE_VALUE [OPTIONAL]");
        }
        int ifIndex = this.tokens.indexOf(argumentPointers.get(0)) + 1;
        this.tokens.add(ifIndex, ifPtg);
        int gotoIndex = this.tokens.indexOf(argumentPointers.get(1)) + 1;
        AttrPtg goto1Ptg = new AttrPtg();
        goto1Ptg.setGoto(true);
        this.tokens.add(gotoIndex, goto1Ptg);
        if (numArgs > 2) {
            AttrPtg goto2Ptg = new AttrPtg();
            goto2Ptg.setGoto(true);
            goto2Ptg.setData((short)(retval.getSize() - 1));
            this.tokens.add(goto2Ptg);
        }
        ifPtg.setData((short)this.getPtgSize(ifIndex + 1, gotoIndex));
        int ptgCount = this.getPtgSize(gotoIndex) - goto1Ptg.getSize() + retval.getSize();
        if (ptgCount > Short.MAX_VALUE) {
            throw new RuntimeException("Ptg Size exceeds short when being specified for a goto ptg in an if");
        }
        goto1Ptg.setData((short)(ptgCount - 1));
        return retval;
    }

    private void validateNumArgs(int numArgs, FunctionMetadata fm) {
        if (numArgs < fm.getMinParams()) {
            String msg = "Too few arguments to function '" + fm.getName() + "'. ";
            msg = fm.hasFixedArgsLength() ? msg + "Expected " + fm.getMinParams() : msg + "At least " + fm.getMinParams() + " were expected";
            msg = msg + " but got " + numArgs + ".";
            throw new FormulaParseException(msg);
        }
        if (numArgs > fm.getMaxParams()) {
            String msg = "Too many arguments to function '" + fm.getName() + "'. ";
            msg = fm.hasFixedArgsLength() ? msg + "Expected " + fm.getMaxParams() : msg + "At most " + fm.getMaxParams() + " were expected";
            msg = msg + " but got " + numArgs + ".";
            throw new FormulaParseException(msg);
        }
    }

    private static boolean isArgumentDelimiter(char ch) {
        return ch == ',' || ch == ')';
    }

    private int Arguments(List argumentPointers) {
        this.SkipWhite();
        if (this.look == ')') {
            return 0;
        }
        boolean missedPrevArg = true;
        int numArgs = 0;
        while (true) {
            this.SkipWhite();
            if (FormulaParser.isArgumentDelimiter(this.look)) {
                if (missedPrevArg) {
                    this.tokens.add(new MissingArgPtg());
                    this.addArgumentPointer(argumentPointers);
                    ++numArgs;
                }
                if (this.look == ')') break;
                this.Match(',');
                missedPrevArg = true;
                continue;
            }
            this.comparisonExpression();
            this.addArgumentPointer(argumentPointers);
            ++numArgs;
            missedPrevArg = false;
        }
        return numArgs;
    }

    private void powerFactor() {
        this.percentFactor();
        while (true) {
            this.SkipWhite();
            if (this.look != '^') {
                return;
            }
            this.Match('^');
            this.percentFactor();
            this.tokens.add(new PowerPtg());
        }
    }

    private void percentFactor() {
        this.tokens.add(this.parseSimpleFactor());
        while (true) {
            this.SkipWhite();
            if (this.look != '%') {
                return;
            }
            this.Match('%');
            this.tokens.add(new PercentPtg());
        }
    }

    private Ptg parseSimpleFactor() {
        this.SkipWhite();
        switch (this.look) {
            case '#': {
                return this.parseErrorLiteral();
            }
            case '-': {
                this.Match('-');
                this.powerFactor();
                return new UnaryMinusPtg();
            }
            case '+': {
                this.Match('+');
                this.powerFactor();
                return new UnaryPlusPtg();
            }
            case '(': {
                this.Match('(');
                this.comparisonExpression();
                this.Match(')');
                return new ParenthesisPtg();
            }
            case '\"': {
                return this.parseStringLiteral();
            }
            case ')': 
            case ',': {
                return new MissingArgPtg();
            }
        }
        if (this.IsAlpha(this.look) || this.look == '\'') {
            return this.parseIdent();
        }
        return this.parseNumber();
    }

    private Ptg parseNumber() {
        String number2 = null;
        String exponent = null;
        String number1 = this.GetNum();
        if (this.look == '.') {
            this.GetChar();
            number2 = this.GetNum();
        }
        if (this.look == 'E') {
            this.GetChar();
            String sign = "";
            if (this.look == '+') {
                this.GetChar();
            } else if (this.look == '-') {
                this.GetChar();
                sign = "-";
            }
            String number = this.GetNum();
            if (number == null) {
                throw this.expected("Integer");
            }
            exponent = sign + number;
        }
        if (number1 == null && number2 == null) {
            throw this.expected("Integer");
        }
        return FormulaParser.getNumberPtgFromString(number1, number2, exponent);
    }

    private ErrPtg parseErrorLiteral() {
        this.Match('#');
        String part1 = this.GetName().toUpperCase();
        switch (part1.charAt(0)) {
            case 'V': {
                if (part1.equals("VALUE")) {
                    this.Match('!');
                    return ErrPtg.VALUE_INVALID;
                }
                throw this.expected("#VALUE!");
            }
            case 'R': {
                if (part1.equals("REF")) {
                    this.Match('!');
                    return ErrPtg.REF_INVALID;
                }
                throw this.expected("#REF!");
            }
            case 'D': {
                if (part1.equals("DIV")) {
                    this.Match('/');
                    this.Match('0');
                    this.Match('!');
                    return ErrPtg.DIV_ZERO;
                }
                throw this.expected("#DIV/0!");
            }
            case 'N': {
                if (part1.equals("NAME")) {
                    this.Match('?');
                    return ErrPtg.NAME_INVALID;
                }
                if (part1.equals("NUM")) {
                    this.Match('!');
                    return ErrPtg.NUM_ERROR;
                }
                if (part1.equals("NULL")) {
                    this.Match('!');
                    return ErrPtg.NULL_INTERSECTION;
                }
                if (part1.equals("N")) {
                    this.Match('/');
                    if (this.look != 'A' && this.look != 'a') {
                        throw this.expected("#N/A");
                    }
                    this.Match(this.look);
                    return ErrPtg.N_A;
                }
                throw this.expected("#NAME?, #NUM!, #NULL! or #N/A");
            }
        }
        throw this.expected("#VALUE!, #REF!, #DIV/0!, #NAME?, #NUM!, #NULL! or #N/A");
    }

    private static Ptg getNumberPtgFromString(String number1, String number2, String exponent) {
        StringBuffer number = new StringBuffer();
        if (number2 == null) {
            int intVal;
            number.append(number1);
            if (exponent != null) {
                number.append('E');
                number.append(exponent);
            }
            String numberStr = number.toString();
            try {
                intVal = Integer.parseInt(numberStr);
            }
            catch (NumberFormatException e) {
                return new NumberPtg(numberStr);
            }
            if (IntPtg.isInRange(intVal)) {
                return new IntPtg(intVal);
            }
            return new NumberPtg(numberStr);
        }
        if (number1 != null) {
            number.append(number1);
        }
        number.append('.');
        number.append(number2);
        if (exponent != null) {
            number.append('E');
            number.append(exponent);
        }
        return new NumberPtg(number.toString());
    }

    private StringPtg parseStringLiteral() {
        this.Match('\"');
        StringBuffer token = new StringBuffer();
        while (true) {
            if (this.look == '\"') {
                this.GetChar();
                if (this.look != '\"') break;
            }
            token.append(this.look);
            this.GetChar();
        }
        return new StringPtg(token.toString());
    }

    private void Term() {
        this.powerFactor();
        block4: while (true) {
            this.SkipWhite();
            switch (this.look) {
                case '*': {
                    this.Match('*');
                    this.powerFactor();
                    this.tokens.add(new MultiplyPtg());
                    continue block4;
                }
                case '/': {
                    this.Match('/');
                    this.powerFactor();
                    this.tokens.add(new DividePtg());
                    continue block4;
                }
            }
            break;
        }
    }

    private void comparisonExpression() {
        this.concatExpression();
        block3: while (true) {
            this.SkipWhite();
            switch (this.look) {
                case '<': 
                case '=': 
                case '>': {
                    Ptg comparisonToken = this.getComparisonToken();
                    this.concatExpression();
                    this.tokens.add(comparisonToken);
                    continue block3;
                }
            }
            break;
        }
    }

    private Ptg getComparisonToken() {
        if (this.look == '=') {
            this.Match(this.look);
            return new EqualPtg();
        }
        boolean isGreater = this.look == '>';
        this.Match(this.look);
        if (isGreater) {
            if (this.look == '=') {
                this.Match('=');
                return new GreaterEqualPtg();
            }
            return new GreaterThanPtg();
        }
        switch (this.look) {
            case '=': {
                this.Match('=');
                return new LessEqualPtg();
            }
            case '>': {
                this.Match('>');
                return new NotEqualPtg();
            }
        }
        return new LessThanPtg();
    }

    private void concatExpression() {
        this.additiveExpression();
        while (true) {
            this.SkipWhite();
            if (this.look != '&') break;
            this.Match('&');
            this.additiveExpression();
            this.tokens.add(new ConcatPtg());
        }
    }

    private void additiveExpression() {
        this.Term();
        block4: while (true) {
            this.SkipWhite();
            switch (this.look) {
                case '+': {
                    this.Match('+');
                    this.Term();
                    this.tokens.add(new AddPtg());
                    continue block4;
                }
                case '-': {
                    this.Match('-');
                    this.Term();
                    this.tokens.add(new SubtractPtg());
                    continue block4;
                }
            }
            break;
        }
    }

    public void parse() {
        this.pointer = 0;
        this.GetChar();
        this.comparisonExpression();
        if (this.pointer <= this.formulaLength) {
            String msg = "Unused input [" + this.formulaString.substring(this.pointer - 1) + "] after attempting to parse the formula [" + this.formulaString + "]";
            throw new FormulaParseException(msg);
        }
    }

    public Ptg[] getRPNPtg() {
        return this.getRPNPtg(FORMULA_TYPE_CELL);
    }

    public Ptg[] getRPNPtg(int formulaType) {
        Node node = this.createTree();
        this.setRootLevelRVA(node, formulaType);
        this.setParameterRVA(node, formulaType);
        return this.tokens.toArray(new Ptg[0]);
    }

    private void setRootLevelRVA(Node n, int formulaType) {
        Ptg p = n.getValue();
        if (formulaType == FORMULA_TYPE_NAMEDRANGE) {
            if (p.getDefaultOperandClass() == 0) {
                this.setClass(n, (byte)0);
            } else {
                this.setClass(n, (byte)64);
            }
        } else {
            this.setClass(n, (byte)32);
        }
    }

    private void setParameterRVA(Node n, int formulaType) {
        Ptg p = n.getValue();
        int numOperands = n.getNumChildren();
        if (p instanceof AbstractFunctionPtg) {
            for (int i = 0; i < numOperands; ++i) {
                this.setParameterRVA(n.getChild(i), ((AbstractFunctionPtg)p).getParameterClass(i), formulaType);
                this.setParameterRVA(n.getChild(i), formulaType);
            }
        } else {
            for (int i = 0; i < numOperands; ++i) {
                this.setParameterRVA(n.getChild(i), formulaType);
            }
        }
    }

    private void setParameterRVA(Node n, int expectedClass, int formulaType) {
        Ptg p = n.getValue();
        if (expectedClass == 0) {
            if (p.getDefaultOperandClass() == 0) {
                this.setClass(n, (byte)0);
            }
            if (p.getDefaultOperandClass() == 32) {
                if (formulaType == FORMULA_TYPE_CELL || formulaType == FORMULA_TYPE_SHARED) {
                    this.setClass(n, (byte)32);
                } else {
                    this.setClass(n, (byte)64);
                }
            }
            if (p.getDefaultOperandClass() == 64) {
                this.setClass(n, (byte)64);
            }
        } else if (expectedClass == 32) {
            if (formulaType == FORMULA_TYPE_NAMEDRANGE) {
                this.setClass(n, (byte)64);
            } else {
                this.setClass(n, (byte)32);
            }
        } else if (p.getDefaultOperandClass() == 32 && (formulaType == FORMULA_TYPE_CELL || formulaType == FORMULA_TYPE_SHARED)) {
            this.setClass(n, (byte)32);
        } else {
            this.setClass(n, (byte)64);
        }
    }

    private void setClass(Node n, byte theClass) {
        Ptg p = n.getValue();
        if (p instanceof AbstractFunctionPtg || !(p instanceof OperationPtg)) {
            p.setClass(theClass);
        } else {
            for (int i = 0; i < n.getNumChildren(); ++i) {
                this.setClass(n.getChild(i), theClass);
            }
        }
    }

    public static String toFormulaString(HSSFWorkbook book, List lptgs) {
        String retval = null;
        if (lptgs == null || lptgs.size() == 0) {
            return "#NAME";
        }
        Ptg[] ptgs = new Ptg[lptgs.size()];
        ptgs = lptgs.toArray(ptgs);
        retval = FormulaParser.toFormulaString(book, ptgs);
        return retval;
    }

    public String toFormulaString(List lptgs) {
        return FormulaParser.toFormulaString(this.book, lptgs);
    }

    public static String toFormulaString(HSSFWorkbook book, Ptg[] ptgs) {
        if (ptgs == null || ptgs.length == 0) {
            return "#NAME";
        }
        Stack<String> stack = new Stack<String>();
        for (int i = 0; i < ptgs.length; ++i) {
            Ptg ptg = ptgs[i];
            if (ptg instanceof MemAreaPtg || ptg instanceof MemFuncPtg || ptg instanceof MemErrPtg) continue;
            if (!(ptg instanceof OperationPtg)) {
                stack.push(ptg.toFormulaString(book));
                continue;
            }
            if (ptg instanceof AttrPtg) {
                AttrPtg attrPtg = (AttrPtg)ptg;
                if (attrPtg.isOptimizedIf() || attrPtg.isOptimizedChoose() || attrPtg.isGoto() || attrPtg.isSpace() || attrPtg.isSemiVolatile()) continue;
                if (!attrPtg.isSum()) {
                    throw new RuntimeException("Unexpected tAttr: " + attrPtg.toString());
                }
            }
            OperationPtg o = (OperationPtg)ptg;
            int nOperands = o.getNumberOfOperands();
            String[] operands = new String[nOperands];
            for (int j = nOperands - 1; j >= 0; --j) {
                if (stack.isEmpty()) {
                    String msg = "Too few arguments suppled to operation token (" + o.getClass().getName() + "). Expected (" + nOperands + ") operands but got (" + (nOperands - j - 1) + ")";
                    throw new IllegalStateException(msg);
                }
                operands[j] = (String)stack.pop();
            }
            stack.push(o.toFormulaString(operands));
        }
        if (stack.isEmpty()) {
            throw new IllegalStateException("Stack underflow");
        }
        String result = (String)stack.pop();
        if (!stack.isEmpty()) {
            throw new IllegalStateException("too much stuff left on the stack");
        }
        return result;
    }

    public String toFormulaString(Ptg[] ptgs) {
        return FormulaParser.toFormulaString(this.book, ptgs);
    }

    private Node createTree() {
        Stack<Node> stack = new Stack<Node>();
        int numPtgs = this.tokens.size();
        for (int i = 0; i < numPtgs; ++i) {
            if (this.tokens.get(i) instanceof OperationPtg) {
                OperationPtg o = (OperationPtg)this.tokens.get(i);
                int numOperands = o.getNumberOfOperands();
                Node[] operands = new Node[numOperands];
                for (int j = 0; j < numOperands; ++j) {
                    operands[numOperands - j - 1] = (Node)stack.pop();
                }
                Node result = new Node(o);
                result.setChildren(operands);
                stack.push(result);
                continue;
            }
            stack.push(new Node((Ptg)this.tokens.get(i)));
        }
        return (Node)stack.pop();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.tokens.size(); ++i) {
            buf.append(((Ptg)this.tokens.get(i)).toFormulaString(this.book));
            buf.append(' ');
        }
        return buf.toString();
    }

    private static final class Node {
        private Ptg value = null;
        private Node[] children = new Node[0];
        private int numChild = 0;

        public Node(Ptg val) {
            this.value = val;
        }

        public void setChildren(Node[] child) {
            this.children = child;
            this.numChild = child.length;
        }

        public int getNumChildren() {
            return this.numChild;
        }

        public Node getChild(int number) {
            return this.children[number];
        }

        public Ptg getValue() {
            return this.value;
        }
    }

    static final class FormulaParseException
    extends RuntimeException {
        public FormulaParseException(String msg) {
            super(msg);
        }
    }
}

