/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.hssf.model.RecordStream;
import org.apache.poi.hssf.model.WorkbookRecordList;
import org.apache.poi.hssf.record.CRNCountRecord;
import org.apache.poi.hssf.record.CRNRecord;
import org.apache.poi.hssf.record.ExternSheetRecord;
import org.apache.poi.hssf.record.ExternSheetSubRecord;
import org.apache.poi.hssf.record.ExternalNameRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.SupBookRecord;

final class LinkTable {
    private final ExternalBookBlock[] _externalBookBlocks;
    private final ExternSheetRecord _externSheetRecord;
    private final List _definedNames;
    private final int _recordCount;
    private final WorkbookRecordList _workbookRecordList;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$ExternalNameRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$CRNCountRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$SupBookRecord;
    static /* synthetic */ Class class$org$apache$poi$hssf$record$NameRecord;

    public LinkTable(List inputList, int startIndex, WorkbookRecordList workbookRecordList) {
        this._workbookRecordList = workbookRecordList;
        RecordStream rs = new RecordStream(inputList, startIndex);
        ArrayList<ExternalBookBlock> temp = new ArrayList<ExternalBookBlock>();
        while (rs.peekNextClass() == (class$org$apache$poi$hssf$record$SupBookRecord == null ? LinkTable.class$("org.apache.poi.hssf.record.SupBookRecord") : class$org$apache$poi$hssf$record$SupBookRecord)) {
            temp.add(new ExternalBookBlock(rs));
        }
        if (temp.size() < 1) {
            throw new RuntimeException("Need at least one EXTERNALBOOK blocks");
        }
        this._externalBookBlocks = new ExternalBookBlock[temp.size()];
        temp.toArray(this._externalBookBlocks);
        temp.clear();
        Record next = rs.getNext();
        this._externSheetRecord = (ExternSheetRecord)next;
        this._definedNames = new ArrayList();
        while (rs.peekNextClass() == (class$org$apache$poi$hssf$record$NameRecord == null ? LinkTable.class$("org.apache.poi.hssf.record.NameRecord") : class$org$apache$poi$hssf$record$NameRecord)) {
            NameRecord nr = (NameRecord)rs.getNext();
            this._definedNames.add(nr);
        }
        this._recordCount = rs.getCountRead();
        this._workbookRecordList.getRecords().addAll(inputList.subList(startIndex, startIndex + this._recordCount));
    }

    public LinkTable(short numberOfSheets, WorkbookRecordList workbookRecordList) {
        this._workbookRecordList = workbookRecordList;
        this._definedNames = new ArrayList();
        this._externalBookBlocks = new ExternalBookBlock[]{new ExternalBookBlock(numberOfSheets)};
        this._externSheetRecord = new ExternSheetRecord();
        this._recordCount = 2;
        SupBookRecord supbook = this._externalBookBlocks[0].getExternalBookRecord();
        int idx = this.findFirstRecordLocBySid((short)140);
        if (idx < 0) {
            throw new RuntimeException("CountryRecord not found");
        }
        this._workbookRecordList.add(idx + 1, this._externSheetRecord);
        this._workbookRecordList.add(idx + 1, supbook);
    }

    public int getRecordCount() {
        return this._recordCount;
    }

    public NameRecord getSpecificBuiltinRecord(byte name, int sheetIndex) {
        Iterator iterator = this._definedNames.iterator();
        while (iterator.hasNext()) {
            NameRecord record = (NameRecord)iterator.next();
            if (record.getBuiltInName() != name || record.getIndexToSheet() != sheetIndex) continue;
            return record;
        }
        return null;
    }

    public void removeBuiltinRecord(byte name, int sheetIndex) {
        NameRecord record = this.getSpecificBuiltinRecord(name, sheetIndex);
        if (record != null) {
            this._definedNames.remove(record);
        }
    }

    public int getNumNames() {
        return this._definedNames.size();
    }

    public NameRecord getNameRecord(int index) {
        return (NameRecord)this._definedNames.get(index);
    }

    public void addName(NameRecord name) {
        this._definedNames.add(name);
        int idx = this.findFirstRecordLocBySid((short)23);
        if (idx == -1) {
            idx = this.findFirstRecordLocBySid((short)430);
        }
        if (idx == -1) {
            idx = this.findFirstRecordLocBySid((short)140);
        }
        int countNames = this._definedNames.size();
        this._workbookRecordList.add(idx + countNames, name);
    }

    public void removeName(int namenum) {
        this._definedNames.remove(namenum);
    }

    public short getIndexToSheet(short num) {
        return this._externSheetRecord.getREFRecordAt(num).getIndexToFirstSupBook();
    }

    public int getSheetIndexFromExternSheetIndex(int externSheetNumber) {
        if (externSheetNumber >= this._externSheetRecord.getNumOfREFStructures()) {
            return -1;
        }
        return this._externSheetRecord.getREFRecordAt(externSheetNumber).getIndexToFirstSupBook();
    }

    public short addSheetIndexToExternSheet(short sheetNumber) {
        ExternSheetSubRecord record = new ExternSheetSubRecord();
        record.setIndexToFirstSupBook(sheetNumber);
        record.setIndexToLastSupBook(sheetNumber);
        this._externSheetRecord.addREFRecord(record);
        this._externSheetRecord.setNumOfREFStructures((short)(this._externSheetRecord.getNumOfREFStructures() + 1));
        return (short)(this._externSheetRecord.getNumOfREFStructures() - 1);
    }

    public short checkExternSheet(int sheetNumber) {
        short nESRs = this._externSheetRecord.getNumOfREFStructures();
        for (short i = 0; i < nESRs; i = (short)(i + 1)) {
            ExternSheetSubRecord esr = this._externSheetRecord.getREFRecordAt(i);
            if (esr.getIndexToFirstSupBook() != sheetNumber || esr.getIndexToLastSupBook() != sheetNumber) continue;
            return i;
        }
        return this.addSheetIndexToExternSheet((short)sheetNumber);
    }

    private int findFirstRecordLocBySid(short sid) {
        int index = 0;
        Iterator iterator = this._workbookRecordList.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() == sid) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public int getNumberOfREFStructures() {
        return this._externSheetRecord.getNumOfREFStructures();
    }

    public String resolveNameXText(int refIndex, int definedNameIndex) {
        short extBookIndex = this._externSheetRecord.getREFRecordAt(refIndex).getIndexToSupBook();
        return this._externalBookBlocks[extBookIndex].getNameText(definedNameIndex);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class ExternalBookBlock {
        private final SupBookRecord _externalBookRecord;
        private final ExternalNameRecord[] _externalNameRecords;
        private final CRNBlock[] _crnBlocks;

        public ExternalBookBlock(RecordStream rs) {
            this._externalBookRecord = (SupBookRecord)rs.getNext();
            ArrayList<Object> temp = new ArrayList<Object>();
            while (rs.peekNextClass() == (class$org$apache$poi$hssf$record$ExternalNameRecord == null ? LinkTable.class$("org.apache.poi.hssf.record.ExternalNameRecord") : class$org$apache$poi$hssf$record$ExternalNameRecord)) {
                temp.add(rs.getNext());
            }
            this._externalNameRecords = new ExternalNameRecord[temp.size()];
            temp.toArray(this._externalNameRecords);
            temp.clear();
            while (rs.peekNextClass() == (class$org$apache$poi$hssf$record$CRNCountRecord == null ? LinkTable.class$("org.apache.poi.hssf.record.CRNCountRecord") : class$org$apache$poi$hssf$record$CRNCountRecord)) {
                temp.add(new CRNBlock(rs));
            }
            this._crnBlocks = new CRNBlock[temp.size()];
            temp.toArray(this._crnBlocks);
        }

        public ExternalBookBlock(short numberOfSheets) {
            this._externalBookRecord = SupBookRecord.createInternalReferences(numberOfSheets);
            this._externalNameRecords = new ExternalNameRecord[0];
            this._crnBlocks = new CRNBlock[0];
        }

        public SupBookRecord getExternalBookRecord() {
            return this._externalBookRecord;
        }

        public String getNameText(int definedNameIndex) {
            return this._externalNameRecords[definedNameIndex].getText();
        }
    }

    private static final class CRNBlock {
        private final CRNCountRecord _countRecord;
        private final CRNRecord[] _crns;

        public CRNBlock(RecordStream rs) {
            this._countRecord = (CRNCountRecord)rs.getNext();
            int nCRNs = this._countRecord.getNumberOfCRNs();
            CRNRecord[] crns = new CRNRecord[nCRNs];
            for (int i = 0; i < crns.length; ++i) {
                crns[i] = (CRNRecord)rs.getNext();
            }
            this._crns = crns;
        }

        public CRNRecord[] getCrns() {
            return (CRNRecord[])this._crns.clone();
        }
    }
}

