/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.model;

import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.poi.ddf.EscherBSERecord;
import org.apache.poi.ddf.EscherBoolProperty;
import org.apache.poi.ddf.EscherContainerRecord;
import org.apache.poi.ddf.EscherDggRecord;
import org.apache.poi.ddf.EscherOptRecord;
import org.apache.poi.ddf.EscherRGBProperty;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherSplitMenuColorsRecord;
import org.apache.poi.hssf.model.DrawingManager2;
import org.apache.poi.hssf.model.LinkTable;
import org.apache.poi.hssf.model.Model;
import org.apache.poi.hssf.model.WorkbookRecordList;
import org.apache.poi.hssf.record.BOFRecord;
import org.apache.poi.hssf.record.BackupRecord;
import org.apache.poi.hssf.record.BookBoolRecord;
import org.apache.poi.hssf.record.BoundSheetRecord;
import org.apache.poi.hssf.record.CodepageRecord;
import org.apache.poi.hssf.record.CountryRecord;
import org.apache.poi.hssf.record.DSFRecord;
import org.apache.poi.hssf.record.DateWindow1904Record;
import org.apache.poi.hssf.record.DrawingGroupRecord;
import org.apache.poi.hssf.record.EOFRecord;
import org.apache.poi.hssf.record.ExtSSTRecord;
import org.apache.poi.hssf.record.ExtendedFormatRecord;
import org.apache.poi.hssf.record.FileSharingRecord;
import org.apache.poi.hssf.record.FnGroupCountRecord;
import org.apache.poi.hssf.record.FontRecord;
import org.apache.poi.hssf.record.FormatRecord;
import org.apache.poi.hssf.record.HideObjRecord;
import org.apache.poi.hssf.record.InterfaceEndRecord;
import org.apache.poi.hssf.record.InterfaceHdrRecord;
import org.apache.poi.hssf.record.MMSRecord;
import org.apache.poi.hssf.record.NameRecord;
import org.apache.poi.hssf.record.PaletteRecord;
import org.apache.poi.hssf.record.PasswordRecord;
import org.apache.poi.hssf.record.PasswordRev4Record;
import org.apache.poi.hssf.record.PrecisionRecord;
import org.apache.poi.hssf.record.ProtectRecord;
import org.apache.poi.hssf.record.ProtectionRev4Record;
import org.apache.poi.hssf.record.RecalcIdRecord;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RefreshAllRecord;
import org.apache.poi.hssf.record.SSTRecord;
import org.apache.poi.hssf.record.StyleRecord;
import org.apache.poi.hssf.record.TabIdRecord;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.hssf.record.UseSelFSRecord;
import org.apache.poi.hssf.record.WindowOneRecord;
import org.apache.poi.hssf.record.WindowProtectRecord;
import org.apache.poi.hssf.record.WriteAccessRecord;
import org.apache.poi.hssf.record.WriteProtectRecord;
import org.apache.poi.hssf.util.SheetReferences;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class Workbook
implements Model {
    private static final int DEBUG = 1;
    private static final short CODEPAGE = 1200;
    protected WorkbookRecordList records = new WorkbookRecordList();
    protected SSTRecord sst = null;
    private LinkTable linkTable;
    protected ArrayList boundsheets = new ArrayList();
    protected ArrayList formats = new ArrayList();
    protected ArrayList hyperlinks = new ArrayList();
    protected int numxfs = 0;
    protected int numfonts = 0;
    private short maxformatid = (short)-1;
    private boolean uses1904datewindowing = false;
    private DrawingManager2 drawingManager;
    private List escherBSERecords = new ArrayList();
    private WindowOneRecord windowOne;
    private FileSharingRecord fileShare;
    private WriteAccessRecord writeAccess;
    private WriteProtectRecord writeProtect;
    private static POILogger log = POILogFactory.getLogger(class$org$apache$poi$hssf$model$Workbook == null ? (class$org$apache$poi$hssf$model$Workbook = Workbook.class$("org.apache.poi.hssf.model.Workbook")) : class$org$apache$poi$hssf$model$Workbook);
    static /* synthetic */ Class class$org$apache$poi$hssf$model$Workbook;

    /*
     * Enabled aggressive block sorting
     */
    public static Workbook createWorkbook(List recs) {
        Record rec;
        int k;
        if (log.check(1)) {
            log.log(1, (Object)"Workbook (readfile) created with reclen=", new Integer(recs.size()));
        }
        Workbook retval = new Workbook();
        ArrayList<Record> records = new ArrayList<Record>(recs.size() / 3);
        retval.records.setRecords(records);
        block22: for (k = 0; k < recs.size(); ++k) {
            rec = (Record)recs.get(k);
            if (rec.getSid() == 10) {
                records.add(rec);
                if (!log.check(1)) break;
                log.log(1, "found workbook eof record at " + k);
                break;
            }
            switch (rec.getSid()) {
                case 133: {
                    if (log.check(1)) {
                        log.log(1, "found boundsheet record at " + k);
                    }
                    retval.boundsheets.add(rec);
                    retval.records.setBspos(k);
                    break;
                }
                case 252: {
                    if (log.check(1)) {
                        log.log(1, "found sst record at " + k);
                    }
                    retval.sst = (SSTRecord)rec;
                    break;
                }
                case 49: {
                    if (log.check(1)) {
                        log.log(1, "found font record at " + k);
                    }
                    retval.records.setFontpos(k);
                    ++retval.numfonts;
                    break;
                }
                case 224: {
                    if (log.check(1)) {
                        log.log(1, "found XF record at " + k);
                    }
                    retval.records.setXfpos(k);
                    ++retval.numxfs;
                    break;
                }
                case 317: {
                    if (log.check(1)) {
                        log.log(1, "found tabid record at " + k);
                    }
                    retval.records.setTabpos(k);
                    break;
                }
                case 18: {
                    if (log.check(1)) {
                        log.log(1, "found protect record at " + k);
                    }
                    retval.records.setProtpos(k);
                    break;
                }
                case 64: {
                    if (log.check(1)) {
                        log.log(1, "found backup record at " + k);
                    }
                    retval.records.setBackuppos(k);
                    break;
                }
                case 23: {
                    throw new RuntimeException("Extern sheet is part of LinkTable");
                }
                case 24: {
                    throw new RuntimeException("DEFINEDNAME is part of LinkTable");
                }
                case 430: {
                    if (log.check(1)) {
                        log.log(1, "found SupBook record at " + k);
                    }
                    retval.linkTable = new LinkTable(recs, k, retval.records);
                    k += retval.linkTable.getRecordCount() - 1;
                    continue block22;
                }
                case 1054: {
                    if (log.check(1)) {
                        log.log(1, "found format record at " + k);
                    }
                    retval.formats.add(rec);
                    retval.maxformatid = retval.maxformatid >= ((FormatRecord)rec).getIndexCode() ? retval.maxformatid : ((FormatRecord)rec).getIndexCode();
                    break;
                }
                case 34: {
                    if (log.check(1)) {
                        log.log(1, "found datewindow1904 record at " + k);
                    }
                    retval.uses1904datewindowing = ((DateWindow1904Record)rec).getWindowing() == 1;
                    break;
                }
                case 146: {
                    if (log.check(1)) {
                        log.log(1, "found palette record at " + k);
                    }
                    retval.records.setPalettepos(k);
                    break;
                }
                case 61: {
                    if (log.check(1)) {
                        log.log(1, "found WindowOneRecord at " + k);
                    }
                    retval.windowOne = (WindowOneRecord)rec;
                    break;
                }
                case 92: {
                    if (log.check(1)) {
                        log.log(1, "found WriteAccess at " + k);
                    }
                    retval.writeAccess = (WriteAccessRecord)rec;
                    break;
                }
                case 134: {
                    if (log.check(1)) {
                        log.log(1, "found WriteProtect at " + k);
                    }
                    retval.writeProtect = (WriteProtectRecord)rec;
                    break;
                }
                case 91: {
                    if (log.check(1)) {
                        log.log(1, "found FileSharing at " + k);
                    }
                    retval.fileShare = (FileSharingRecord)rec;
                }
            }
            records.add(rec);
        }
        while (k < recs.size()) {
            rec = (Record)recs.get(k);
            switch (rec.getSid()) {
                case 440: {
                    retval.hyperlinks.add(rec);
                    break;
                }
            }
            ++k;
        }
        if (retval.windowOne == null) {
            retval.windowOne = (WindowOneRecord)retval.createWindowOne();
        }
        if (log.check(1)) {
            log.log(1, "exit create workbook from existing file function");
        }
        return retval;
    }

    public static Workbook createWorkbook() {
        int k;
        int k2;
        if (log.check(1)) {
            log.log(1, "creating new workbook from scratch");
        }
        Workbook retval = new Workbook();
        ArrayList<Record> records = new ArrayList<Record>(30);
        retval.records.setRecords(records);
        ArrayList<Record> formats = new ArrayList<Record>(8);
        records.add(retval.createBOF());
        records.add(retval.createInterfaceHdr());
        records.add(retval.createMMS());
        records.add(retval.createInterfaceEnd());
        records.add(retval.createWriteAccess());
        records.add(retval.createCodepage());
        records.add(retval.createDSF());
        records.add(retval.createTabId());
        retval.records.setTabpos(records.size() - 1);
        records.add(retval.createFnGroupCount());
        records.add(retval.createWindowProtect());
        records.add(retval.createProtect());
        retval.records.setProtpos(records.size() - 1);
        records.add(retval.createPassword());
        records.add(retval.createProtectionRev4());
        records.add(retval.createPasswordRev4());
        retval.windowOne = (WindowOneRecord)retval.createWindowOne();
        records.add(retval.windowOne);
        records.add(retval.createBackup());
        retval.records.setBackuppos(records.size() - 1);
        records.add(retval.createHideObj());
        records.add(retval.createDateWindow1904());
        records.add(retval.createPrecision());
        records.add(retval.createRefreshAll());
        records.add(retval.createBookBool());
        records.add(retval.createFont());
        records.add(retval.createFont());
        records.add(retval.createFont());
        records.add(retval.createFont());
        retval.records.setFontpos(records.size() - 1);
        retval.numfonts = 4;
        for (int i = 0; i <= 7; ++i) {
            Record rec = retval.createFormat(i);
            retval.maxformatid = retval.maxformatid >= ((FormatRecord)rec).getIndexCode() ? retval.maxformatid : ((FormatRecord)rec).getIndexCode();
            formats.add(rec);
            records.add(rec);
        }
        retval.formats = formats;
        for (k2 = 0; k2 < 21; ++k2) {
            records.add(retval.createExtendedFormat(k2));
            ++retval.numxfs;
        }
        retval.records.setXfpos(records.size() - 1);
        for (k2 = 0; k2 < 6; ++k2) {
            records.add(retval.createStyle(k2));
        }
        records.add(retval.createUseSelFS());
        int nBoundSheets = 1;
        for (k = 0; k < nBoundSheets; ++k) {
            BoundSheetRecord bsr = (BoundSheetRecord)retval.createBoundSheet(k);
            records.add(bsr);
            retval.boundsheets.add(bsr);
            retval.records.setBspos(records.size() - 1);
        }
        records.add(retval.createCountry());
        for (k = 0; k < nBoundSheets; ++k) {
            retval.getOrCreateLinkTable().checkExternSheet(k);
        }
        retval.sst = (SSTRecord)retval.createSST();
        records.add(retval.sst);
        records.add(retval.createExtendedSST());
        records.add(retval.createEOF());
        if (log.check(1)) {
            log.log(1, "exit create new workbook from scratch");
        }
        return retval;
    }

    public NameRecord getSpecificBuiltinRecord(byte name, int sheetIndex) {
        return this.getOrCreateLinkTable().getSpecificBuiltinRecord(name, sheetIndex);
    }

    public void removeBuiltinRecord(byte name, int sheetIndex) {
        this.linkTable.removeBuiltinRecord(name, sheetIndex);
    }

    public int getNumRecords() {
        return this.records.size();
    }

    public FontRecord getFontRecordAt(int idx) {
        int index = idx;
        if (index > 4) {
            --index;
        }
        if (index > this.numfonts - 1) {
            throw new ArrayIndexOutOfBoundsException("There are only " + this.numfonts + " font records, you asked for " + idx);
        }
        FontRecord retval = (FontRecord)this.records.get(this.records.getFontpos() - (this.numfonts - 1) + index);
        return retval;
    }

    public FontRecord createNewFont() {
        FontRecord rec = (FontRecord)this.createFont();
        this.records.add(this.records.getFontpos() + 1, rec);
        this.records.setFontpos(this.records.getFontpos() + 1);
        ++this.numfonts;
        return rec;
    }

    public int getNumberOfFontRecords() {
        return this.numfonts;
    }

    public void setSheetBof(int sheetnum, int pos) {
        if (log.check(1)) {
            log.log(1, (Object)"setting bof for sheetnum =", (Object)new Integer(sheetnum), (Object)" at pos=", new Integer(pos));
        }
        this.checkSheets(sheetnum);
        ((BoundSheetRecord)this.boundsheets.get(sheetnum)).setPositionOfBof(pos);
    }

    public BackupRecord getBackupRecord() {
        return (BackupRecord)this.records.get(this.records.getBackuppos());
    }

    public void setSheetName(int sheetnum, String sheetname) {
        this.checkSheets(sheetnum);
        BoundSheetRecord sheet = (BoundSheetRecord)this.boundsheets.get(sheetnum);
        sheet.setSheetname(sheetname);
        sheet.setSheetnameLength((byte)sheetname.length());
    }

    public boolean doesContainsSheetName(String name, int excludeSheetIdx) {
        for (int i = 0; i < this.boundsheets.size(); ++i) {
            BoundSheetRecord boundSheetRecord = (BoundSheetRecord)this.boundsheets.get(i);
            if (excludeSheetIdx == i || !name.equalsIgnoreCase(boundSheetRecord.getSheetname())) continue;
            return true;
        }
        return false;
    }

    public void setSheetName(int sheetnum, String sheetname, short encoding) {
        this.checkSheets(sheetnum);
        BoundSheetRecord sheet = (BoundSheetRecord)this.boundsheets.get(sheetnum);
        sheet.setSheetname(sheetname);
        sheet.setSheetnameLength((byte)sheetname.length());
        sheet.setCompressedUnicodeFlag((byte)encoding);
    }

    public void setSheetOrder(String sheetname, int pos) {
        int sheetNumber = this.getSheetIndex(sheetname);
        this.boundsheets.add(pos, this.boundsheets.remove(sheetNumber));
    }

    public String getSheetName(int sheetnum) {
        return ((BoundSheetRecord)this.boundsheets.get(sheetnum)).getSheetname();
    }

    public boolean isSheetHidden(int sheetnum) {
        BoundSheetRecord bsr = (BoundSheetRecord)this.boundsheets.get(sheetnum);
        return bsr.isHidden();
    }

    public void setSheetHidden(int sheetnum, boolean hidden) {
        BoundSheetRecord bsr = (BoundSheetRecord)this.boundsheets.get(sheetnum);
        bsr.setHidden(hidden);
    }

    public int getSheetIndex(String name) {
        int retval = -1;
        for (int k = 0; k < this.boundsheets.size(); ++k) {
            String sheet = this.getSheetName(k);
            if (!sheet.equalsIgnoreCase(name)) continue;
            retval = k;
            break;
        }
        return retval;
    }

    private void checkSheets(int sheetnum) {
        if (this.boundsheets.size() <= sheetnum) {
            if (this.boundsheets.size() + 1 <= sheetnum) {
                throw new RuntimeException("Sheet number out of bounds!");
            }
            BoundSheetRecord bsr = (BoundSheetRecord)this.createBoundSheet(sheetnum);
            this.records.add(this.records.getBspos() + 1, bsr);
            this.records.setBspos(this.records.getBspos() + 1);
            this.boundsheets.add(bsr);
            this.getOrCreateLinkTable().checkExternSheet(sheetnum);
            this.fixTabIdRecord();
        }
    }

    public void removeSheet(int sheetnum) {
        if (this.boundsheets.size() > sheetnum) {
            this.records.remove(this.records.getBspos() - (this.boundsheets.size() - 1) + sheetnum);
            this.boundsheets.remove(sheetnum);
            this.fixTabIdRecord();
        }
    }

    private void fixTabIdRecord() {
        TabIdRecord tir = (TabIdRecord)this.records.get(this.records.getTabpos());
        short[] tia = new short[this.boundsheets.size()];
        for (int k = 0; k < tia.length; k = (int)((short)(k + 1))) {
            tia[k] = k;
        }
        tir.setTabIdArray(tia);
    }

    public int getNumSheets() {
        if (log.check(1)) {
            log.log(1, (Object)"getNumSheets=", new Integer(this.boundsheets.size()));
        }
        return this.boundsheets.size();
    }

    public int getNumExFormats() {
        if (log.check(1)) {
            log.log(1, (Object)"getXF=", new Integer(this.numxfs));
        }
        return this.numxfs;
    }

    public ExtendedFormatRecord getExFormatAt(int index) {
        int xfptr = this.records.getXfpos() - (this.numxfs - 1);
        ExtendedFormatRecord retval = (ExtendedFormatRecord)this.records.get(xfptr += index);
        return retval;
    }

    public ExtendedFormatRecord createCellXF() {
        ExtendedFormatRecord xf = this.createExtendedFormat();
        this.records.add(this.records.getXfpos() + 1, xf);
        this.records.setXfpos(this.records.getXfpos() + 1);
        ++this.numxfs;
        return xf;
    }

    public int addSSTString(UnicodeString string) {
        if (log.check(1)) {
            log.log(1, (Object)"insert to sst string='", string);
        }
        if (this.sst == null) {
            this.insertSST();
        }
        return this.sst.addString(string);
    }

    public UnicodeString getSSTString(int str) {
        if (this.sst == null) {
            this.insertSST();
        }
        UnicodeString retval = this.sst.getString(str);
        if (log.check(1)) {
            log.log(1, (Object)"Returning SST for index=", (Object)new Integer(str), (Object)" String= ", retval);
        }
        return retval;
    }

    public void insertSST() {
        if (log.check(1)) {
            log.log(1, "creating new SST via insertSST!");
        }
        this.sst = (SSTRecord)this.createSST();
        this.records.add(this.records.size() - 1, this.createExtendedSST());
        this.records.add(this.records.size() - 2, this.sst);
    }

    public int serialize(int offset, byte[] data) {
        if (log.check(1)) {
            log.log(1, "Serializing Workbook with offsets");
        }
        int pos = 0;
        SSTRecord sst = null;
        int sstPos = 0;
        boolean wroteBoundSheets = false;
        for (int k = 0; k < this.records.size(); ++k) {
            Record record = this.records.get(k);
            if (record.getSid() == 449 && !((RecalcIdRecord)record).isNeeded()) continue;
            int len = 0;
            if (record instanceof SSTRecord) {
                sst = (SSTRecord)record;
                sstPos = pos;
            }
            if (record.getSid() == 255 && sst != null) {
                record = sst.createExtSSTRecord(sstPos + offset);
            }
            if (record instanceof BoundSheetRecord) {
                if (!wroteBoundSheets) {
                    for (int i = 0; i < this.boundsheets.size(); ++i) {
                        len += ((BoundSheetRecord)this.boundsheets.get(i)).serialize(pos + offset + len, data);
                    }
                    wroteBoundSheets = true;
                }
            } else {
                len = record.serialize(pos + offset, data);
            }
            pos += len;
        }
        if (log.check(1)) {
            log.log(1, "Exiting serialize workbook");
        }
        return pos;
    }

    public int getSize() {
        int retval = 0;
        SSTRecord sst = null;
        for (int k = 0; k < this.records.size(); ++k) {
            Record record = this.records.get(k);
            if (record.getSid() == 449 && !((RecalcIdRecord)record).isNeeded()) continue;
            if (record instanceof SSTRecord) {
                sst = (SSTRecord)record;
            }
            if (record.getSid() == 255 && sst != null) {
                retval += sst.calcExtSSTRecordSize();
                continue;
            }
            retval += record.getRecordSize();
        }
        return retval;
    }

    protected Record createBOF() {
        BOFRecord retval = new BOFRecord();
        retval.setVersion((short)1536);
        retval.setType((short)5);
        retval.setBuild((short)4307);
        retval.setBuildYear((short)1996);
        retval.setHistoryBitMask(65);
        retval.setRequiredVersion(6);
        return retval;
    }

    protected Record createInterfaceHdr() {
        InterfaceHdrRecord retval = new InterfaceHdrRecord();
        retval.setCodepage((short)1200);
        return retval;
    }

    protected Record createMMS() {
        MMSRecord retval = new MMSRecord();
        retval.setAddMenuCount((byte)0);
        retval.setDelMenuCount((byte)0);
        return retval;
    }

    protected Record createInterfaceEnd() {
        return new InterfaceEndRecord();
    }

    protected Record createWriteAccess() {
        WriteAccessRecord retval = new WriteAccessRecord();
        try {
            retval.setUsername(System.getProperty("user.name"));
        }
        catch (AccessControlException e) {
            retval.setUsername("POI");
        }
        return retval;
    }

    protected Record createCodepage() {
        CodepageRecord retval = new CodepageRecord();
        retval.setCodepage((short)1200);
        return retval;
    }

    protected Record createDSF() {
        DSFRecord retval = new DSFRecord();
        retval.setDsf((short)0);
        return retval;
    }

    protected Record createTabId() {
        TabIdRecord retval = new TabIdRecord();
        short[] tabidarray = new short[]{0};
        retval.setTabIdArray(tabidarray);
        return retval;
    }

    protected Record createFnGroupCount() {
        FnGroupCountRecord retval = new FnGroupCountRecord();
        retval.setCount((short)14);
        return retval;
    }

    protected Record createWindowProtect() {
        WindowProtectRecord retval = new WindowProtectRecord();
        retval.setProtect(false);
        return retval;
    }

    protected Record createProtect() {
        ProtectRecord retval = new ProtectRecord();
        retval.setProtect(false);
        return retval;
    }

    protected Record createPassword() {
        PasswordRecord retval = new PasswordRecord();
        retval.setPassword((short)0);
        return retval;
    }

    protected Record createProtectionRev4() {
        ProtectionRev4Record retval = new ProtectionRev4Record();
        retval.setProtect(false);
        return retval;
    }

    protected Record createPasswordRev4() {
        PasswordRev4Record retval = new PasswordRev4Record();
        retval.setPassword((short)0);
        return retval;
    }

    protected Record createWindowOne() {
        WindowOneRecord retval = new WindowOneRecord();
        retval.setHorizontalHold((short)360);
        retval.setVerticalHold((short)270);
        retval.setWidth((short)14940);
        retval.setHeight((short)9150);
        retval.setOptions((short)56);
        retval.setSelectedTab((short)0);
        retval.setDisplayedTab((short)0);
        retval.setNumSelectedTabs((short)1);
        retval.setTabWidthRatio((short)600);
        return retval;
    }

    protected Record createBackup() {
        BackupRecord retval = new BackupRecord();
        retval.setBackup((short)0);
        return retval;
    }

    protected Record createHideObj() {
        HideObjRecord retval = new HideObjRecord();
        retval.setHideObj((short)0);
        return retval;
    }

    protected Record createDateWindow1904() {
        DateWindow1904Record retval = new DateWindow1904Record();
        retval.setWindowing((short)0);
        return retval;
    }

    protected Record createPrecision() {
        PrecisionRecord retval = new PrecisionRecord();
        retval.setFullPrecision(true);
        return retval;
    }

    protected Record createRefreshAll() {
        RefreshAllRecord retval = new RefreshAllRecord();
        retval.setRefreshAll(false);
        return retval;
    }

    protected Record createBookBool() {
        BookBoolRecord retval = new BookBoolRecord();
        retval.setSaveLinkValues((short)0);
        return retval;
    }

    protected Record createFont() {
        FontRecord retval = new FontRecord();
        retval.setFontHeight((short)200);
        retval.setAttributes((short)0);
        retval.setColorPaletteIndex((short)Short.MAX_VALUE);
        retval.setBoldWeight((short)400);
        retval.setFontNameLength((byte)5);
        retval.setFontName("Arial");
        return retval;
    }

    protected Record createFormat(int id) {
        FormatRecord retval = new FormatRecord();
        switch (id) {
            case 0: {
                retval.setIndexCode((short)5);
                retval.setFormatStringLength((byte)23);
                retval.setFormatString("\"$\"#,##0_);\\(\"$\"#,##0\\)");
                break;
            }
            case 1: {
                retval.setIndexCode((short)6);
                retval.setFormatStringLength((byte)28);
                retval.setFormatString("\"$\"#,##0_);[Red]\\(\"$\"#,##0\\)");
                break;
            }
            case 2: {
                retval.setIndexCode((short)7);
                retval.setFormatStringLength((byte)29);
                retval.setFormatString("\"$\"#,##0.00_);\\(\"$\"#,##0.00\\)");
                break;
            }
            case 3: {
                retval.setIndexCode((short)8);
                retval.setFormatStringLength((byte)34);
                retval.setFormatString("\"$\"#,##0.00_);[Red]\\(\"$\"#,##0.00\\)");
                break;
            }
            case 4: {
                retval.setIndexCode((short)42);
                retval.setFormatStringLength((byte)50);
                retval.setFormatString("_(\"$\"* #,##0_);_(\"$\"* \\(#,##0\\);_(\"$\"* \"-\"_);_(@_)");
                break;
            }
            case 5: {
                retval.setIndexCode((short)41);
                retval.setFormatStringLength((byte)41);
                retval.setFormatString("_(* #,##0_);_(* \\(#,##0\\);_(* \"-\"_);_(@_)");
                break;
            }
            case 6: {
                retval.setIndexCode((short)44);
                retval.setFormatStringLength((byte)58);
                retval.setFormatString("_(\"$\"* #,##0.00_);_(\"$\"* \\(#,##0.00\\);_(\"$\"* \"-\"??_);_(@_)");
                break;
            }
            case 7: {
                retval.setIndexCode((short)43);
                retval.setFormatStringLength((byte)49);
                retval.setFormatString("_(* #,##0.00_);_(* \\(#,##0.00\\);_(* \"-\"??_);_(@_)");
            }
        }
        return retval;
    }

    protected Record createExtendedFormat(int id) {
        ExtendedFormatRecord retval = new ExtendedFormatRecord();
        switch (id) {
            case 0: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)0);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 1: {
                retval.setFontIndex((short)1);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 2: {
                retval.setFontIndex((short)1);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 3: {
                retval.setFontIndex((short)2);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 4: {
                retval.setFontIndex((short)2);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 5: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 6: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 7: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 8: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 9: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 10: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 11: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 12: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 13: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 14: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-3072);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 15: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)1);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)0);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 16: {
                retval.setFontIndex((short)1);
                retval.setFormatIndex((short)43);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-2048);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 17: {
                retval.setFontIndex((short)1);
                retval.setFormatIndex((short)41);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-2048);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 18: {
                retval.setFontIndex((short)1);
                retval.setFormatIndex((short)44);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-2048);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 19: {
                retval.setFontIndex((short)1);
                retval.setFormatIndex((short)42);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-2048);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 20: {
                retval.setFontIndex((short)1);
                retval.setFormatIndex((short)9);
                retval.setCellOptions((short)-11);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)-2048);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 21: {
                retval.setFontIndex((short)5);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)1);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)2048);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 22: {
                retval.setFontIndex((short)6);
                retval.setFormatIndex((short)0);
                retval.setCellOptions((short)1);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)23552);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 23: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)49);
                retval.setCellOptions((short)1);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)23552);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 24: {
                retval.setFontIndex((short)0);
                retval.setFormatIndex((short)8);
                retval.setCellOptions((short)1);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)23552);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
                break;
            }
            case 25: {
                retval.setFontIndex((short)6);
                retval.setFormatIndex((short)8);
                retval.setCellOptions((short)1);
                retval.setAlignmentOptions((short)32);
                retval.setIndentionOptions((short)23552);
                retval.setBorderOptions((short)0);
                retval.setPaletteOptions((short)0);
                retval.setAdtlPaletteOptions((short)0);
                retval.setFillPaletteOptions((short)8384);
            }
        }
        return retval;
    }

    protected ExtendedFormatRecord createExtendedFormat() {
        ExtendedFormatRecord retval = new ExtendedFormatRecord();
        retval.setFontIndex((short)0);
        retval.setFormatIndex((short)0);
        retval.setCellOptions((short)1);
        retval.setAlignmentOptions((short)32);
        retval.setIndentionOptions((short)0);
        retval.setBorderOptions((short)0);
        retval.setPaletteOptions((short)0);
        retval.setAdtlPaletteOptions((short)0);
        retval.setFillPaletteOptions((short)8384);
        retval.setTopBorderPaletteIdx((short)8);
        retval.setBottomBorderPaletteIdx((short)8);
        retval.setLeftBorderPaletteIdx((short)8);
        retval.setRightBorderPaletteIdx((short)8);
        return retval;
    }

    protected Record createStyle(int id) {
        StyleRecord retval = new StyleRecord();
        switch (id) {
            case 0: {
                retval.setIndex((short)-32752);
                retval.setBuiltin((byte)3);
                retval.setOutlineStyleLevel((byte)-1);
                break;
            }
            case 1: {
                retval.setIndex((short)-32751);
                retval.setBuiltin((byte)6);
                retval.setOutlineStyleLevel((byte)-1);
                break;
            }
            case 2: {
                retval.setIndex((short)-32750);
                retval.setBuiltin((byte)4);
                retval.setOutlineStyleLevel((byte)-1);
                break;
            }
            case 3: {
                retval.setIndex((short)-32749);
                retval.setBuiltin((byte)7);
                retval.setOutlineStyleLevel((byte)-1);
                break;
            }
            case 4: {
                retval.setIndex((short)Short.MIN_VALUE);
                retval.setBuiltin((byte)0);
                retval.setOutlineStyleLevel((byte)-1);
                break;
            }
            case 5: {
                retval.setIndex((short)-32748);
                retval.setBuiltin((byte)5);
                retval.setOutlineStyleLevel((byte)-1);
            }
        }
        return retval;
    }

    protected PaletteRecord createPalette() {
        return new PaletteRecord();
    }

    protected Record createUseSelFS() {
        UseSelFSRecord retval = new UseSelFSRecord();
        retval.setFlag((short)0);
        return retval;
    }

    protected Record createBoundSheet(int id) {
        BoundSheetRecord retval = new BoundSheetRecord();
        switch (id) {
            case 0: {
                retval.setPositionOfBof(0);
                retval.setOptionFlags((short)0);
                retval.setSheetnameLength((byte)6);
                retval.setCompressedUnicodeFlag((byte)0);
                retval.setSheetname("Sheet1");
                break;
            }
            case 1: {
                retval.setPositionOfBof(0);
                retval.setOptionFlags((short)0);
                retval.setSheetnameLength((byte)6);
                retval.setCompressedUnicodeFlag((byte)0);
                retval.setSheetname("Sheet2");
                break;
            }
            case 2: {
                retval.setPositionOfBof(0);
                retval.setOptionFlags((short)0);
                retval.setSheetnameLength((byte)6);
                retval.setCompressedUnicodeFlag((byte)0);
                retval.setSheetname("Sheet3");
            }
        }
        return retval;
    }

    protected Record createCountry() {
        CountryRecord retval = new CountryRecord();
        retval.setDefaultCountry((short)1);
        if (Locale.getDefault().toString().equals("ru_RU")) {
            retval.setCurrentCountry((short)7);
        } else {
            retval.setCurrentCountry((short)1);
        }
        return retval;
    }

    protected Record createSST() {
        return new SSTRecord();
    }

    protected Record createExtendedSST() {
        ExtSSTRecord retval = new ExtSSTRecord();
        retval.setNumStringsPerBucket((short)8);
        return retval;
    }

    protected Record createEOF() {
        return new EOFRecord();
    }

    private LinkTable getOrCreateLinkTable() {
        if (this.linkTable == null) {
            this.linkTable = new LinkTable((short)this.getNumSheets(), this.records);
        }
        return this.linkTable;
    }

    public SheetReferences getSheetReferences() {
        SheetReferences refs = new SheetReferences();
        if (this.linkTable != null) {
            short s = this.linkTable.getNumberOfREFStructures();
            for (short k = 0; k < s; k = (short)(k + 1)) {
                String sheetName = this.findSheetNameFromExternSheet(k);
                refs.addSheetReference(sheetName, k);
            }
        }
        return refs;
    }

    public String findSheetNameFromExternSheet(short num) {
        String result = "";
        short indexToSheet = this.linkTable.getIndexToSheet(num);
        if (indexToSheet > -1) {
            result = this.getSheetName(indexToSheet);
        }
        return result;
    }

    public int getSheetIndexFromExternSheetIndex(int externSheetNumber) {
        return this.linkTable.getSheetIndexFromExternSheetIndex(externSheetNumber);
    }

    public short checkExternSheet(int sheetNumber) {
        return this.getOrCreateLinkTable().checkExternSheet(sheetNumber);
    }

    public int getNumNames() {
        if (this.linkTable == null) {
            return 0;
        }
        return this.linkTable.getNumNames();
    }

    public NameRecord getNameRecord(int index) {
        return this.linkTable.getNameRecord(index);
    }

    public NameRecord createName() {
        return this.addName(new NameRecord());
    }

    public NameRecord addName(NameRecord name) {
        this.getOrCreateLinkTable().addName(name);
        return name;
    }

    public NameRecord createBuiltInName(byte builtInName, int index) {
        if (index == -1 || index + 1 > Short.MAX_VALUE) {
            throw new IllegalArgumentException("Index is not valid [" + index + "]");
        }
        NameRecord name = new NameRecord(builtInName, (short)index);
        this.addName(name);
        return name;
    }

    public void removeName(int namenum) {
        if (this.linkTable.getNumNames() > namenum) {
            int idx = this.findFirstRecordLocBySid((short)24);
            this.records.remove(idx + namenum);
            this.linkTable.removeName(namenum);
        }
    }

    public short getFormat(String format, boolean createIfNotFound) {
        Iterator iterator = this.formats.iterator();
        while (iterator.hasNext()) {
            FormatRecord r = (FormatRecord)iterator.next();
            if (!r.getFormatString().equals(format)) continue;
            return r.getIndexCode();
        }
        if (createIfNotFound) {
            return this.createFormat(format);
        }
        return -1;
    }

    public ArrayList getFormats() {
        return this.formats;
    }

    public short createFormat(String format) {
        FormatRecord rec = new FormatRecord();
        this.maxformatid = (short)(this.maxformatid >= 164 ? (int)(this.maxformatid + 1) : 164);
        rec.setIndexCode(this.maxformatid);
        rec.setFormatStringLength((byte)format.length());
        rec.setFormatString(format);
        for (int pos = 0; pos < this.records.size() && this.records.get(pos).getSid() != 1054; ++pos) {
        }
        this.formats.add(rec);
        this.records.add(pos += this.formats.size(), rec);
        return this.maxformatid;
    }

    public Record findFirstRecordBySid(short sid) {
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() != sid) continue;
            return record;
        }
        return null;
    }

    public int findFirstRecordLocBySid(short sid) {
        int index = 0;
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() == sid) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public Record findNextRecordBySid(short sid, int pos) {
        int matches = 0;
        Iterator iterator = this.records.iterator();
        while (iterator.hasNext()) {
            Record record = (Record)iterator.next();
            if (record.getSid() != sid || matches++ != pos) continue;
            return record;
        }
        return null;
    }

    public List getHyperlinks() {
        return this.hyperlinks;
    }

    public List getRecords() {
        return this.records.getRecords();
    }

    public boolean isUsing1904DateWindowing() {
        return this.uses1904datewindowing;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PaletteRecord getCustomPalette() {
        int palettePos = this.records.getPalettepos();
        if (palettePos != -1) {
            Record rec = this.records.get(palettePos);
            if (!(rec instanceof PaletteRecord)) throw new RuntimeException("InternalError: Expected PaletteRecord but got a '" + rec + "'");
            return (PaletteRecord)rec;
        }
        PaletteRecord palette = this.createPalette();
        this.records.add(1, palette);
        this.records.setPalettepos(1);
        return palette;
    }

    public void findDrawingGroup() {
        Iterator rit = this.records.iterator();
        while (rit.hasNext()) {
            Record r = (Record)rit.next();
            if (!(r instanceof DrawingGroupRecord)) continue;
            DrawingGroupRecord dg = (DrawingGroupRecord)r;
            dg.processChildRecords();
            EscherContainerRecord cr = dg.getEscherContainer();
            if (cr == null) continue;
            EscherDggRecord dgg = null;
            Iterator it = cr.getChildRecords().iterator();
            while (it.hasNext()) {
                Object er = it.next();
                if (!(er instanceof EscherDggRecord)) continue;
                dgg = (EscherDggRecord)er;
            }
            if (dgg == null) continue;
            this.drawingManager = new DrawingManager2(dgg);
            return;
        }
        int dgLoc = this.findFirstRecordLocBySid((short)235);
        if (dgLoc != -1) {
            DrawingGroupRecord dg = (DrawingGroupRecord)this.records.get(dgLoc);
            EscherDggRecord dgg = null;
            Iterator it = dg.getEscherRecords().iterator();
            while (it.hasNext()) {
                Object er = it.next();
                if (!(er instanceof EscherDggRecord)) continue;
                dgg = (EscherDggRecord)er;
            }
            if (dgg != null) {
                this.drawingManager = new DrawingManager2(dgg);
            }
        }
    }

    public void createDrawingGroup() {
        if (this.drawingManager == null) {
            DrawingGroupRecord drawingGroup;
            EscherContainerRecord dggContainer = new EscherContainerRecord();
            EscherDggRecord dgg = new EscherDggRecord();
            EscherOptRecord opt = new EscherOptRecord();
            EscherSplitMenuColorsRecord splitMenuColors = new EscherSplitMenuColorsRecord();
            dggContainer.setRecordId((short)-4096);
            dggContainer.setOptions((short)15);
            dgg.setRecordId((short)-4090);
            dgg.setOptions((short)0);
            dgg.setShapeIdMax(1024);
            dgg.setNumShapesSaved(0);
            dgg.setDrawingsSaved(0);
            dgg.setFileIdClusters(new EscherDggRecord.FileIdCluster[0]);
            this.drawingManager = new DrawingManager2(dgg);
            EscherContainerRecord bstoreContainer = null;
            if (this.escherBSERecords.size() > 0) {
                bstoreContainer = new EscherContainerRecord();
                bstoreContainer.setRecordId((short)-4095);
                bstoreContainer.setOptions((short)(this.escherBSERecords.size() << 4 | 0xF));
                Iterator iterator = this.escherBSERecords.iterator();
                while (iterator.hasNext()) {
                    EscherRecord escherRecord = (EscherRecord)iterator.next();
                    bstoreContainer.addChildRecord(escherRecord);
                }
            }
            opt.setRecordId((short)-4085);
            opt.setOptions((short)51);
            opt.addEscherProperty(new EscherBoolProperty(191, 524296));
            opt.addEscherProperty(new EscherRGBProperty(385, 134217793));
            opt.addEscherProperty(new EscherRGBProperty(448, 0x8000040));
            splitMenuColors.setRecordId((short)-3810);
            splitMenuColors.setOptions((short)64);
            splitMenuColors.setColor1(0x800000D);
            splitMenuColors.setColor2(0x800000C);
            splitMenuColors.setColor3(134217751);
            splitMenuColors.setColor4(268435703);
            dggContainer.addChildRecord(dgg);
            if (bstoreContainer != null) {
                dggContainer.addChildRecord(bstoreContainer);
            }
            dggContainer.addChildRecord(opt);
            dggContainer.addChildRecord(splitMenuColors);
            int dgLoc = this.findFirstRecordLocBySid((short)235);
            if (dgLoc == -1) {
                drawingGroup = new DrawingGroupRecord();
                drawingGroup.addEscherRecord(dggContainer);
                int loc = this.findFirstRecordLocBySid((short)140);
                this.getRecords().add(loc + 1, drawingGroup);
            } else {
                drawingGroup = new DrawingGroupRecord();
                drawingGroup.addEscherRecord(dggContainer);
                this.getRecords().set(dgLoc, drawingGroup);
            }
        }
    }

    public WindowOneRecord getWindowOne() {
        return this.windowOne;
    }

    public EscherBSERecord getBSERecord(int pictureIndex) {
        return (EscherBSERecord)this.escherBSERecords.get(pictureIndex - 1);
    }

    public int addBSERecord(EscherBSERecord e) {
        EscherContainerRecord bstoreContainer;
        this.createDrawingGroup();
        this.escherBSERecords.add(e);
        int dgLoc = this.findFirstRecordLocBySid((short)235);
        DrawingGroupRecord drawingGroup = (DrawingGroupRecord)this.getRecords().get(dgLoc);
        EscherContainerRecord dggContainer = (EscherContainerRecord)drawingGroup.getEscherRecord(0);
        if (dggContainer.getChild(1).getRecordId() == -4095) {
            bstoreContainer = (EscherContainerRecord)dggContainer.getChild(1);
        } else {
            bstoreContainer = new EscherContainerRecord();
            bstoreContainer.setRecordId((short)-4095);
            dggContainer.getChildRecords().add(1, bstoreContainer);
        }
        bstoreContainer.setOptions((short)(this.escherBSERecords.size() << 4 | 0xF));
        bstoreContainer.addChildRecord(e);
        return this.escherBSERecords.size();
    }

    public DrawingManager2 getDrawingManager() {
        return this.drawingManager;
    }

    public WriteProtectRecord getWriteProtect() {
        if (this.writeProtect == null) {
            this.writeProtect = new WriteProtectRecord();
            int i = 0;
            for (i = 0; i < this.records.size() && !(this.records.get(i) instanceof BOFRecord); ++i) {
            }
            this.records.add(i + 1, this.writeProtect);
        }
        return this.writeProtect;
    }

    public WriteAccessRecord getWriteAccess() {
        if (this.writeAccess == null) {
            this.writeAccess = (WriteAccessRecord)this.createWriteAccess();
            int i = 0;
            for (i = 0; i < this.records.size() && !(this.records.get(i) instanceof InterfaceEndRecord); ++i) {
            }
            this.records.add(i + 1, this.writeAccess);
        }
        return this.writeAccess;
    }

    public FileSharingRecord getFileSharing() {
        if (this.fileShare == null) {
            this.fileShare = new FileSharingRecord();
            int i = 0;
            for (i = 0; i < this.records.size() && !(this.records.get(i) instanceof WriteAccessRecord); ++i) {
            }
            this.records.add(i + 1, this.fileShare);
        }
        return this.fileShare;
    }

    public boolean isWriteProtected() {
        if (this.fileShare == null) {
            return false;
        }
        FileSharingRecord frec = this.getFileSharing();
        return frec.getReadOnly() == 1;
    }

    public void writeProtectWorkbook(String password, String username) {
        int protIdx = -1;
        FileSharingRecord frec = this.getFileSharing();
        WriteAccessRecord waccess = this.getWriteAccess();
        WriteProtectRecord wprotect = this.getWriteProtect();
        frec.setReadOnly((short)1);
        frec.setPassword(FileSharingRecord.hashPassword(password));
        frec.setUsername(username);
        waccess.setUsername(username);
    }

    public void unwriteProtectWorkbook() {
        this.records.remove(this.fileShare);
        this.records.remove(this.writeProtect);
        this.fileShare = null;
        this.writeProtect = null;
    }

    public String resolveNameXText(int refIndex, int definedNameIndex) {
        return this.linkTable.resolveNameXText(refIndex, definedNameIndex);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

