/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.AreaI;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.AreaReference;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

public class AreaPtg
extends Ptg
implements AreaI {
    public static final short sid = 37;
    private static final int SIZE = 9;
    private int field_1_first_row;
    private int field_2_last_row;
    private int field_3_first_column;
    private int field_4_last_column;
    private static final BitField rowRelative = BitFieldFactory.getInstance(32768);
    private static final BitField colRelative = BitFieldFactory.getInstance(16384);
    private static final BitField columnMask = BitFieldFactory.getInstance(16383);

    protected final RuntimeException notImplemented() {
        return new RuntimeException("Coding Error: This method should never be called. This ptg should be converted");
    }

    protected AreaPtg() {
    }

    public AreaPtg(String arearef) {
        AreaReference ar = new AreaReference(arearef);
        CellReference firstCell = ar.getFirstCell();
        CellReference lastCell = ar.getLastCell();
        this.setFirstRow(firstCell.getRow());
        this.setFirstColumn(firstCell.getCol());
        this.setLastRow(lastCell.getRow());
        this.setLastColumn(lastCell.getCol());
        this.setFirstColRelative(!firstCell.isColAbsolute());
        this.setLastColRelative(!lastCell.isColAbsolute());
        this.setFirstRowRelative(!firstCell.isRowAbsolute());
        this.setLastRowRelative(!lastCell.isRowAbsolute());
    }

    public AreaPtg(int firstRow, int lastRow, int firstColumn, int lastColumn, boolean firstRowRelative, boolean lastRowRelative, boolean firstColRelative, boolean lastColRelative) {
        AreaPtg.checkColumnBounds(firstColumn);
        AreaPtg.checkColumnBounds(lastColumn);
        AreaPtg.checkRowBounds(firstRow);
        AreaPtg.checkRowBounds(lastRow);
        this.setFirstRow(firstRow);
        this.setLastRow(lastRow);
        this.setFirstColumn(firstColumn);
        this.setLastColumn(lastColumn);
        this.setFirstRowRelative(firstRowRelative);
        this.setLastRowRelative(lastRowRelative);
        this.setFirstColRelative(firstColRelative);
        this.setLastColRelative(lastColRelative);
    }

    private static void checkColumnBounds(int colIx) {
        if ((colIx & 0xFF) != colIx) {
            throw new IllegalArgumentException("colIx (" + colIx + ") is out of range");
        }
    }

    private static void checkRowBounds(int rowIx) {
        if ((rowIx & 0xFFFF) != rowIx) {
            throw new IllegalArgumentException("rowIx (" + rowIx + ") is out of range");
        }
    }

    public AreaPtg(RecordInputStream in) {
        this.field_1_first_row = in.readUShort();
        this.field_2_last_row = in.readUShort();
        this.field_3_first_column = in.readUShort();
        this.field_4_last_column = in.readUShort();
    }

    public String getAreaPtgName() {
        return "AreaPtg";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getAreaPtgName());
        buffer.append("\n");
        buffer.append("firstRow = " + this.getFirstRow()).append("\n");
        buffer.append("lastRow  = " + this.getLastRow()).append("\n");
        buffer.append("firstCol = " + this.getFirstColumn()).append("\n");
        buffer.append("lastCol  = " + this.getLastColumn()).append("\n");
        buffer.append("firstColRowRel= " + this.isFirstRowRelative()).append("\n");
        buffer.append("lastColRowRel = " + this.isLastRowRelative()).append("\n");
        buffer.append("firstColRel   = " + this.isFirstColRelative()).append("\n");
        buffer.append("lastColRel    = " + this.isLastColRelative()).append("\n");
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(37 + this.ptgClass);
        LittleEndian.putShort(array, offset + 1, (short)this.field_1_first_row);
        LittleEndian.putShort(array, offset + 3, (short)this.field_2_last_row);
        LittleEndian.putShort(array, offset + 5, (short)this.field_3_first_column);
        LittleEndian.putShort(array, offset + 7, (short)this.field_4_last_column);
    }

    public int getSize() {
        return 9;
    }

    public int getFirstRow() {
        return this.field_1_first_row;
    }

    public void setFirstRow(int rowIx) {
        AreaPtg.checkRowBounds(rowIx);
        this.field_1_first_row = rowIx;
    }

    public int getLastRow() {
        return this.field_2_last_row;
    }

    public void setLastRow(int rowIx) {
        AreaPtg.checkRowBounds(rowIx);
        this.field_2_last_row = rowIx;
    }

    public int getFirstColumn() {
        return columnMask.getValue(this.field_3_first_column);
    }

    public short getFirstColumnRaw() {
        return (short)this.field_3_first_column;
    }

    public boolean isFirstRowRelative() {
        return rowRelative.isSet(this.field_3_first_column);
    }

    public void setFirstRowRelative(boolean rel) {
        this.field_3_first_column = rowRelative.setBoolean(this.field_3_first_column, rel);
    }

    public boolean isFirstColRelative() {
        return colRelative.isSet(this.field_3_first_column);
    }

    public void setFirstColRelative(boolean rel) {
        this.field_3_first_column = colRelative.setBoolean(this.field_3_first_column, rel);
    }

    public void setFirstColumn(int colIx) {
        AreaPtg.checkColumnBounds(colIx);
        this.field_3_first_column = columnMask.setValue(this.field_3_first_column, colIx);
    }

    public void setFirstColumnRaw(int column) {
        this.field_3_first_column = column;
    }

    public int getLastColumn() {
        return columnMask.getValue(this.field_4_last_column);
    }

    public short getLastColumnRaw() {
        return (short)this.field_4_last_column;
    }

    public boolean isLastRowRelative() {
        return rowRelative.isSet(this.field_4_last_column);
    }

    public void setLastRowRelative(boolean rel) {
        this.field_4_last_column = rowRelative.setBoolean(this.field_4_last_column, rel);
    }

    public boolean isLastColRelative() {
        return colRelative.isSet(this.field_4_last_column);
    }

    public void setLastColRelative(boolean rel) {
        this.field_4_last_column = colRelative.setBoolean(this.field_4_last_column, rel);
    }

    public void setLastColumn(int colIx) {
        AreaPtg.checkColumnBounds(colIx);
        this.field_4_last_column = columnMask.setValue(this.field_4_last_column, colIx);
    }

    public void setLastColumnRaw(short column) {
        this.field_4_last_column = column;
    }

    public String toFormulaString(HSSFWorkbook book) {
        return AreaPtg.toFormulaString(this, book);
    }

    protected static String toFormulaString(AreaI area, HSSFWorkbook book) {
        CellReference botRight;
        CellReference topLeft = new CellReference(area.getFirstRow(), area.getFirstColumn(), !area.isFirstRowRelative(), !area.isFirstColRelative());
        if (AreaReference.isWholeColumnReference(topLeft, botRight = new CellReference(area.getLastRow(), area.getLastColumn(), !area.isLastRowRelative(), !area.isLastColRelative()))) {
            return new AreaReference(topLeft, botRight).formatAsString();
        }
        return topLeft.formatAsString() + ":" + botRight.formatAsString();
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public Object clone() {
        AreaPtg ptg = new AreaPtg();
        ptg.field_1_first_row = this.field_1_first_row;
        ptg.field_2_last_row = this.field_2_last_row;
        ptg.field_3_first_column = this.field_3_first_column;
        ptg.field_4_last_column = this.field_4_last_column;
        ptg.setClass(this.ptgClass);
        return ptg;
    }
}

