/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.UnicodeString;
import org.apache.poi.hssf.record.constant.ConstantValueParser;
import org.apache.poi.hssf.record.constant.ErrorConstant;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.util.LittleEndian;

public class ArrayPtg
extends Ptg {
    public static final byte sid = 32;
    private static final int RESERVED_FIELD_LEN = 7;
    protected byte[] field_1_reserved;
    protected short token_1_columns;
    protected short token_2_rows;
    protected Object[] token_3_arrayValues;

    protected ArrayPtg() {
    }

    public ArrayPtg(RecordInputStream in) {
        this.field_1_reserved = new byte[7];
        for (int i = 0; i < 7; ++i) {
            this.field_1_reserved[i] = in.readByte();
        }
    }

    public void readTokenValues(RecordInputStream in) {
        short nColumns = in.readUByte();
        short nRows = in.readShort();
        nColumns = (short)(nColumns + 1);
        nRows = (short)(nRows + 1);
        this.token_1_columns = nColumns;
        this.token_2_rows = nRows;
        int totalCount = nRows * nColumns;
        this.token_3_arrayValues = ConstantValueParser.parse(in, totalCount);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[ArrayPtg]\n");
        buffer.append("columns = ").append(this.getColumnCount()).append("\n");
        buffer.append("rows = ").append(this.getRowCount()).append("\n");
        for (int x = 0; x < this.getColumnCount(); ++x) {
            for (int y = 0; y < this.getRowCount(); ++y) {
                Object o = this.token_3_arrayValues[this.getValueIndex(x, y)];
                buffer.append("[").append(x).append("][").append(y).append("] = ").append(o).append("\n");
            }
        }
        return buffer.toString();
    }

    int getValueIndex(int colIx, int rowIx) {
        if (colIx < 0 || colIx >= this.token_1_columns) {
            throw new IllegalArgumentException("Specified colIx (" + colIx + ") is outside the allowed range (0.." + (this.token_1_columns - 1) + ")");
        }
        if (rowIx < 0 || rowIx >= this.token_2_rows) {
            throw new IllegalArgumentException("Specified rowIx (" + rowIx + ") is outside the allowed range (0.." + (this.token_2_rows - 1) + ")");
        }
        return rowIx * this.token_1_columns + colIx;
    }

    public void writeBytes(byte[] data, int offset) {
        LittleEndian.putByte(data, offset + 0, 32 + this.ptgClass);
        System.arraycopy(this.field_1_reserved, 0, data, offset + 1, 7);
    }

    public int writeTokenValueBytes(byte[] data, int offset) {
        LittleEndian.putByte(data, offset + 0, this.token_1_columns - 1);
        LittleEndian.putShort(data, offset + 1, (short)(this.token_2_rows - 1));
        ConstantValueParser.encode(data, offset + 3, this.token_3_arrayValues);
        return 3 + ConstantValueParser.getEncodedSize(this.token_3_arrayValues);
    }

    public short getRowCount() {
        return this.token_2_rows;
    }

    public short getColumnCount() {
        return this.token_1_columns;
    }

    public int getSize() {
        int size = 11;
        return size += ConstantValueParser.getEncodedSize(this.token_3_arrayValues);
    }

    public String toFormulaString(HSSFWorkbook book) {
        StringBuffer b = new StringBuffer();
        b.append("{");
        for (int x = 0; x < this.getColumnCount(); ++x) {
            if (x > 0) {
                b.append(";");
            }
            for (int y = 0; y < this.getRowCount(); ++y) {
                if (y > 0) {
                    b.append(",");
                }
                Object o = this.token_3_arrayValues[this.getValueIndex(x, y)];
                b.append(ArrayPtg.getConstantText(o));
            }
        }
        b.append("}");
        return b.toString();
    }

    private static String getConstantText(Object o) {
        if (o == null) {
            return "";
        }
        if (o instanceof UnicodeString) {
            return "\"" + ((UnicodeString)o).getString() + "\"";
        }
        if (o instanceof Double) {
            return ((Double)o).toString();
        }
        if (o instanceof Boolean) {
            ((Boolean)o).toString();
        }
        if (o instanceof ErrorConstant) {
            return ((ErrorConstant)o).getText();
        }
        throw new IllegalArgumentException("Unexpected constant class (" + o.getClass().getName() + ")");
    }

    public byte getDefaultOperandClass() {
        return 64;
    }

    public Object clone() {
        ArrayPtg ptg = new ArrayPtg();
        ptg.field_1_reserved = (byte[])this.field_1_reserved.clone();
        ptg.token_1_columns = this.token_1_columns;
        ptg.token_2_rows = this.token_2_rows;
        ptg.token_3_arrayValues = (Object[])this.token_3_arrayValues.clone();
        ptg.setClass(this.ptgClass);
        return ptg;
    }
}

