/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.usermodel.HSSFErrorConstants;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public final class ErrPtg
extends Ptg {
    private static final HSSFErrorConstants EC = null;
    public static final ErrPtg NULL_INTERSECTION = new ErrPtg(0);
    public static final ErrPtg DIV_ZERO = new ErrPtg(7);
    public static final ErrPtg VALUE_INVALID = new ErrPtg(15);
    public static final ErrPtg REF_INVALID = new ErrPtg(23);
    public static final ErrPtg NAME_INVALID = new ErrPtg(29);
    public static final ErrPtg NUM_ERROR = new ErrPtg(36);
    public static final ErrPtg N_A = new ErrPtg(42);
    public static final short sid = 28;
    private static final int SIZE = 2;
    private int field_1_error_code;

    public ErrPtg(int errorCode) {
        if (!HSSFErrorConstants.isValidCode(errorCode)) {
            throw new IllegalArgumentException("Invalid error code (" + errorCode + ")");
        }
        this.field_1_error_code = errorCode;
    }

    public ErrPtg(RecordInputStream in) {
        this(in.readByte());
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(28 + this.ptgClass);
        array[offset + 1] = (byte)this.field_1_error_code;
    }

    public String toFormulaString(HSSFWorkbook book) {
        return HSSFErrorConstants.getText(this.field_1_error_code);
    }

    public int getSize() {
        return 2;
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public Object clone() {
        return new ErrPtg(this.field_1_error_code);
    }

    public int getErrorCode() {
        return this.field_1_error_code;
    }
}

