/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.AbstractFunctionPtg;
import org.apache.poi.hssf.record.formula.function.FunctionMetadata;
import org.apache.poi.hssf.record.formula.function.FunctionMetadataRegistry;
import org.apache.poi.util.LittleEndian;

public final class FuncPtg
extends AbstractFunctionPtg {
    public static final byte sid = 33;
    public static final int SIZE = 3;
    private int numParams = 0;

    public FuncPtg(RecordInputStream in) {
        this.field_2_fnc_index = in.readShort();
        FunctionMetadata fm = FunctionMetadataRegistry.getFunctionByIndex(this.field_2_fnc_index);
        if (fm == null) {
            throw new RuntimeException("Invalid built-in function index (" + this.field_2_fnc_index + ")");
        }
        this.numParams = fm.getMinParams();
    }

    public FuncPtg(int functionIndex) {
        this.field_2_fnc_index = (short)functionIndex;
        FunctionMetadata fm = FunctionMetadataRegistry.getFunctionByIndex(functionIndex);
        this.numParams = fm.getMinParams();
        this.returnClass = fm.getReturnClassCode();
        this.paramClass = fm.getParameterClassCodes();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = (byte)(33 + this.ptgClass);
        LittleEndian.putShort(array, offset + 1, this.field_2_fnc_index);
    }

    public int getNumberOfOperands() {
        return this.numParams;
    }

    public Object clone() {
        FuncPtg ptg = new FuncPtg(this.field_2_fnc_index);
        ptg.setClass(this.ptgClass);
        return ptg;
    }

    public int getSize() {
        return 3;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this.lookupName(this.field_2_fnc_index));
        sb.append(" nArgs=").append(this.numParams);
        sb.append("]");
        return sb.toString();
    }
}

