/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.util.LittleEndian;

public final class IntPtg
extends Ptg {
    private static final int MIN_VALUE = 0;
    private static final int MAX_VALUE = 65535;
    public static final int SIZE = 3;
    public static final byte sid = 30;
    private int field_1_value;

    public static boolean isInRange(int i) {
        return i >= 0 && i <= 65535;
    }

    public IntPtg(RecordInputStream in) {
        this(in.readUShort());
    }

    public IntPtg(int value) {
        if (!IntPtg.isInRange(value)) {
            throw new IllegalArgumentException("value is out of range: " + value);
        }
        this.field_1_value = value;
    }

    public int getValue() {
        return this.field_1_value;
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = 30;
        LittleEndian.putUShort(array, offset + 1, this.getValue());
    }

    public int getSize() {
        return 3;
    }

    public String toFormulaString(HSSFWorkbook book) {
        return String.valueOf(this.getValue());
    }

    public byte getDefaultOperandClass() {
        return 32;
    }

    public Object clone() {
        return new IntPtg(this.field_1_value);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this.field_1_value);
        sb.append("]");
        return sb.toString();
    }
}

