/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.usermodel.HSSFName;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.util.LittleEndian;

public class NamePtg
extends Ptg {
    public static final short sid = 35;
    private static final int SIZE = 5;
    private short field_1_label_index;
    private short field_2_zero;
    boolean xtra = false;

    private NamePtg() {
    }

    public NamePtg(String name, HSSFWorkbook book) {
        this.field_1_label_index = (short)(1 + NamePtg.getOrCreateNameRecord(book, name));
    }

    private static final int getOrCreateNameRecord(HSSFWorkbook book, String name) {
        int countNames = book.getNumberOfNames();
        for (int i = 0; i < countNames; ++i) {
            if (!name.equalsIgnoreCase(book.getNameName(i))) continue;
            return i;
        }
        HSSFName nameObj = book.createName();
        nameObj.setNameName(name);
        return countNames;
    }

    public NamePtg(RecordInputStream in) {
        this.field_1_label_index = in.readShort();
        this.field_2_zero = in.readShort();
    }

    public int getIndex() {
        return this.field_1_label_index - 1;
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = (byte)(35 + this.ptgClass);
        LittleEndian.putShort(array, offset + 1, this.field_1_label_index);
        LittleEndian.putShort(array, offset + 3, this.field_2_zero);
    }

    public int getSize() {
        return 5;
    }

    public String toFormulaString(HSSFWorkbook book) {
        return book.getNameName(this.field_1_label_index - 1);
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public Object clone() {
        NamePtg ptg = new NamePtg();
        ptg.field_1_label_index = this.field_1_label_index;
        ptg.field_2_zero = this.field_2_zero;
        return ptg;
    }
}

