/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import java.util.ArrayList;
import java.util.Stack;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.AddPtg;
import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaAPtg;
import org.apache.poi.hssf.record.formula.AreaErrPtg;
import org.apache.poi.hssf.record.formula.AreaNAPtg;
import org.apache.poi.hssf.record.formula.AreaNPtg;
import org.apache.poi.hssf.record.formula.AreaNVPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.AreaVPtg;
import org.apache.poi.hssf.record.formula.ArrayPtg;
import org.apache.poi.hssf.record.formula.ArrayPtgA;
import org.apache.poi.hssf.record.formula.ArrayPtgV;
import org.apache.poi.hssf.record.formula.AttrPtg;
import org.apache.poi.hssf.record.formula.BoolPtg;
import org.apache.poi.hssf.record.formula.ConcatPtg;
import org.apache.poi.hssf.record.formula.DeletedArea3DPtg;
import org.apache.poi.hssf.record.formula.DeletedRef3DPtg;
import org.apache.poi.hssf.record.formula.DividePtg;
import org.apache.poi.hssf.record.formula.EqualPtg;
import org.apache.poi.hssf.record.formula.ErrPtg;
import org.apache.poi.hssf.record.formula.ExpPtg;
import org.apache.poi.hssf.record.formula.FuncPtg;
import org.apache.poi.hssf.record.formula.FuncVarPtg;
import org.apache.poi.hssf.record.formula.GreaterEqualPtg;
import org.apache.poi.hssf.record.formula.GreaterThanPtg;
import org.apache.poi.hssf.record.formula.IntPtg;
import org.apache.poi.hssf.record.formula.IntersectionPtg;
import org.apache.poi.hssf.record.formula.LessEqualPtg;
import org.apache.poi.hssf.record.formula.LessThanPtg;
import org.apache.poi.hssf.record.formula.MemAreaPtg;
import org.apache.poi.hssf.record.formula.MemErrPtg;
import org.apache.poi.hssf.record.formula.MemFuncPtg;
import org.apache.poi.hssf.record.formula.MissingArgPtg;
import org.apache.poi.hssf.record.formula.MultiplyPtg;
import org.apache.poi.hssf.record.formula.NamePtg;
import org.apache.poi.hssf.record.formula.NameXPtg;
import org.apache.poi.hssf.record.formula.NotEqualPtg;
import org.apache.poi.hssf.record.formula.NumberPtg;
import org.apache.poi.hssf.record.formula.ParenthesisPtg;
import org.apache.poi.hssf.record.formula.PercentPtg;
import org.apache.poi.hssf.record.formula.PowerPtg;
import org.apache.poi.hssf.record.formula.RangePtg;
import org.apache.poi.hssf.record.formula.Ref3DPtg;
import org.apache.poi.hssf.record.formula.RefAPtg;
import org.apache.poi.hssf.record.formula.RefErrorPtg;
import org.apache.poi.hssf.record.formula.RefNAPtg;
import org.apache.poi.hssf.record.formula.RefNPtg;
import org.apache.poi.hssf.record.formula.RefNVPtg;
import org.apache.poi.hssf.record.formula.RefVPtg;
import org.apache.poi.hssf.record.formula.ReferencePtg;
import org.apache.poi.hssf.record.formula.StringPtg;
import org.apache.poi.hssf.record.formula.SubtractPtg;
import org.apache.poi.hssf.record.formula.UnaryMinusPtg;
import org.apache.poi.hssf.record.formula.UnaryPlusPtg;
import org.apache.poi.hssf.record.formula.UnionPtg;
import org.apache.poi.hssf.record.formula.UnknownPtg;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.util.HexDump;

public abstract class Ptg {
    public static final byte CLASS_REF = 0;
    public static final byte CLASS_VALUE = 32;
    public static final byte CLASS_ARRAY = 64;
    protected byte ptgClass = 0;

    public static Stack createParsedExpressionTokens(short size, RecordInputStream in) {
        Stack<Ptg> stack = new Stack<Ptg>();
        int pos = 0;
        ArrayList<Ptg> arrayPtgs = null;
        while (pos < size) {
            Ptg ptg = Ptg.createPtg(in);
            if (ptg instanceof ArrayPtg) {
                if (arrayPtgs == null) {
                    arrayPtgs = new ArrayList<Ptg>(5);
                }
                arrayPtgs.add(ptg);
                pos += 8;
            } else {
                pos += ptg.getSize();
            }
            stack.push(ptg);
        }
        if (pos != size) {
            throw new RuntimeException("Ptg array size mismatch");
        }
        if (arrayPtgs != null) {
            for (int i = 0; i < arrayPtgs.size(); ++i) {
                ArrayPtg p = (ArrayPtg)arrayPtgs.get(i);
                p.readTokenValues(in);
            }
        }
        return stack;
    }

    public static Ptg createPtg(RecordInputStream in) {
        byte id = in.readByte();
        Ptg retval = null;
        switch (id) {
            case 1: {
                retval = new ExpPtg(in);
                break;
            }
            case 3: {
                retval = new AddPtg(in);
                break;
            }
            case 4: {
                retval = new SubtractPtg(in);
                break;
            }
            case 5: {
                retval = new MultiplyPtg(in);
                break;
            }
            case 6: {
                retval = new DividePtg(in);
                break;
            }
            case 7: {
                retval = new PowerPtg(in);
                break;
            }
            case 8: {
                retval = new ConcatPtg(in);
                break;
            }
            case 9: {
                retval = new LessThanPtg(in);
                break;
            }
            case 10: {
                retval = new LessEqualPtg(in);
                break;
            }
            case 11: {
                retval = new EqualPtg(in);
                break;
            }
            case 12: {
                retval = new GreaterEqualPtg(in);
                break;
            }
            case 13: {
                retval = new GreaterThanPtg(in);
                break;
            }
            case 14: {
                retval = new NotEqualPtg(in);
                break;
            }
            case 15: {
                retval = new IntersectionPtg(in);
                break;
            }
            case 16: {
                retval = new UnionPtg(in);
                break;
            }
            case 17: {
                retval = new RangePtg(in);
                break;
            }
            case 18: {
                retval = new UnaryPlusPtg(in);
                break;
            }
            case 19: {
                retval = new UnaryMinusPtg(in);
                break;
            }
            case 20: {
                retval = new PercentPtg(in);
                break;
            }
            case 21: {
                retval = new ParenthesisPtg(in);
                break;
            }
            case 22: {
                retval = new MissingArgPtg(in);
                break;
            }
            case 23: {
                retval = new StringPtg(in);
                break;
            }
            case 25: 
            case 26: {
                retval = new AttrPtg(in);
                break;
            }
            case 28: {
                retval = new ErrPtg(in);
                break;
            }
            case 29: {
                retval = new BoolPtg(in);
                break;
            }
            case 30: {
                retval = new IntPtg(in);
                break;
            }
            case 31: {
                retval = new NumberPtg(in);
                break;
            }
            case 32: {
                retval = new ArrayPtg(in);
                break;
            }
            case 64: {
                retval = new ArrayPtgV(in);
                break;
            }
            case 96: {
                retval = new ArrayPtgA(in);
                break;
            }
            case 33: 
            case 65: 
            case 97: {
                retval = new FuncPtg(in);
                break;
            }
            case 34: 
            case 66: 
            case 98: {
                retval = new FuncVarPtg(in);
                break;
            }
            case 36: {
                retval = new ReferencePtg(in);
                break;
            }
            case 100: {
                retval = new RefAPtg(in);
                break;
            }
            case 68: {
                retval = new RefVPtg(in);
                break;
            }
            case 108: {
                retval = new RefNAPtg(in);
                break;
            }
            case 44: {
                retval = new RefNPtg(in);
                break;
            }
            case 76: {
                retval = new RefNVPtg(in);
                break;
            }
            case 37: {
                retval = new AreaPtg(in);
                break;
            }
            case 69: {
                retval = new AreaVPtg(in);
                break;
            }
            case 101: {
                retval = new AreaAPtg(in);
                break;
            }
            case 109: {
                retval = new AreaNAPtg(in);
                break;
            }
            case 45: {
                retval = new AreaNPtg(in);
                break;
            }
            case 77: {
                retval = new AreaNVPtg(in);
                break;
            }
            case 38: 
            case 70: 
            case 102: {
                retval = new MemAreaPtg(in);
                break;
            }
            case 39: 
            case 71: 
            case 103: {
                retval = new MemErrPtg(in);
                break;
            }
            case 41: {
                retval = new MemFuncPtg(in);
                break;
            }
            case 42: 
            case 74: 
            case 106: {
                retval = new RefErrorPtg(in);
                break;
            }
            case 43: 
            case 75: 
            case 107: {
                retval = new AreaErrPtg(in);
                break;
            }
            case 35: 
            case 67: 
            case 99: {
                retval = new NamePtg(in);
                break;
            }
            case 57: 
            case 89: 
            case 121: {
                retval = new NameXPtg(in);
                break;
            }
            case 59: 
            case 91: 
            case 123: {
                retval = new Area3DPtg(in);
                break;
            }
            case 58: 
            case 90: 
            case 122: {
                retval = new Ref3DPtg(in);
                break;
            }
            case 60: 
            case 92: 
            case 124: {
                retval = new DeletedRef3DPtg(in);
                break;
            }
            case 61: 
            case 93: 
            case 125: {
                retval = new DeletedArea3DPtg(in);
                break;
            }
            case 0: {
                retval = new UnknownPtg();
                break;
            }
            default: {
                throw new UnsupportedOperationException(" Unknown Ptg in Formula: 0x" + Integer.toHexString(id) + " (" + id + ")");
            }
        }
        if (id > 96) {
            retval.setClass((byte)64);
        } else if (id > 64) {
            retval.setClass((byte)32);
        } else {
            retval.setClass((byte)0);
        }
        return retval;
    }

    public static int serializePtgStack(Stack expression, byte[] array, int offset) {
        int pos = 0;
        int size = 0;
        if (expression != null) {
            size = expression.size();
        }
        ArrayList<Ptg> arrayPtgs = null;
        for (int k = 0; k < size; ++k) {
            Ptg ptg = (Ptg)expression.get(k);
            ptg.writeBytes(array, pos + offset);
            if (ptg instanceof ArrayPtg) {
                if (arrayPtgs == null) {
                    arrayPtgs = new ArrayList<Ptg>(5);
                }
                arrayPtgs.add(ptg);
                pos += 8;
                continue;
            }
            pos += ptg.getSize();
        }
        if (arrayPtgs != null) {
            for (int i = 0; i < arrayPtgs.size(); ++i) {
                ArrayPtg p = (ArrayPtg)arrayPtgs.get(i);
                pos += p.writeTokenValueBytes(array, pos + offset);
            }
        }
        return pos;
    }

    public abstract int getSize();

    public final byte[] getBytes() {
        int size = this.getSize();
        byte[] bytes = new byte[size];
        this.writeBytes(bytes, 0);
        return bytes;
    }

    public abstract void writeBytes(byte[] var1, int var2);

    public abstract String toFormulaString(HSSFWorkbook var1);

    public String toDebugString() {
        byte[] ba = new byte[this.getSize()];
        String retval = null;
        this.writeBytes(ba, 0);
        try {
            retval = HexDump.dump(ba, 0L, 0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retval;
    }

    public String toString() {
        return this.getClass().toString();
    }

    public void setClass(byte thePtgClass) {
        this.ptgClass = thePtgClass;
    }

    public byte getPtgClass() {
        return this.ptgClass;
    }

    public abstract byte getDefaultOperandClass();

    public abstract Object clone();
}

