/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.record.formula.SheetNameFormatter;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.hssf.util.RangeAddress;
import org.apache.poi.hssf.util.SheetReferences;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

public class Ref3DPtg
extends Ptg {
    public static final byte sid = 58;
    private static final int SIZE = 7;
    private short field_1_index_extern_sheet;
    private int field_2_row;
    private int field_3_column;
    private BitField rowRelative = BitFieldFactory.getInstance(32768);
    private BitField colRelative = BitFieldFactory.getInstance(16384);

    public Ref3DPtg() {
    }

    public Ref3DPtg(RecordInputStream in) {
        this.field_1_index_extern_sheet = in.readShort();
        this.field_2_row = in.readShort();
        this.field_3_column = in.readShort();
    }

    public Ref3DPtg(String cellref, short externIdx) {
        CellReference c = new CellReference(cellref);
        this.setRow(c.getRow());
        this.setColumn(c.getCol());
        this.setColRelative(!c.isColAbsolute());
        this.setRowRelative(!c.isRowAbsolute());
        this.setExternSheetIndex(externIdx);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("Ref3dPtg\n");
        buffer.append("Index to Extern Sheet = " + this.getExternSheetIndex()).append("\n");
        buffer.append("Row = " + this.getRow()).append("\n");
        buffer.append("Col  = " + this.getColumn()).append("\n");
        buffer.append("ColRowRel= " + this.isRowRelative()).append("\n");
        buffer.append("ColRel   = " + this.isColRelative()).append("\n");
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
        array[0 + offset] = (byte)(58 + this.ptgClass);
        LittleEndian.putShort(array, 1 + offset, this.getExternSheetIndex());
        LittleEndian.putShort(array, 3 + offset, (short)this.getRow());
        LittleEndian.putShort(array, 5 + offset, (short)this.getColumnRaw());
    }

    public int getSize() {
        return 7;
    }

    public short getExternSheetIndex() {
        return this.field_1_index_extern_sheet;
    }

    public void setExternSheetIndex(short index) {
        this.field_1_index_extern_sheet = index;
    }

    public int getRow() {
        return this.field_2_row;
    }

    public void setRow(int row) {
        this.field_2_row = row;
    }

    public int getColumn() {
        return this.field_3_column & 0xFF;
    }

    public int getColumnRaw() {
        return this.field_3_column;
    }

    public boolean isRowRelative() {
        return this.rowRelative.isSet(this.field_3_column);
    }

    public void setRowRelative(boolean rel) {
        this.field_3_column = this.rowRelative.setBoolean(this.field_3_column, rel);
    }

    public boolean isColRelative() {
        return this.colRelative.isSet(this.field_3_column);
    }

    public void setColRelative(boolean rel) {
        this.field_3_column = this.colRelative.setBoolean(this.field_3_column, rel);
    }

    public void setColumn(short column) {
        this.field_3_column &= 0xFF00;
        this.field_3_column |= column & 0xFF;
    }

    public void setColumnRaw(short column) {
        this.field_3_column = column;
    }

    public void setArea(String ref) {
        RangeAddress ra = new RangeAddress(ref);
        String from = ra.getFromCell();
        this.setColumn((short)(ra.getXPosition(from) - 1));
        this.setRow((short)(ra.getYPosition(from) - 1));
    }

    static String getSheetName(HSSFWorkbook book, int externSheetIndex) {
        if (book == null) {
            return null;
        }
        SheetReferences refs = book.getSheetReferences();
        if (refs == null) {
            return null;
        }
        return refs.getSheetName(externSheetIndex);
    }

    public String toFormulaString(HSSFWorkbook book) {
        StringBuffer retval = new StringBuffer();
        String sheetName = Ref3DPtg.getSheetName(book, this.field_1_index_extern_sheet);
        if (sheetName != null) {
            SheetNameFormatter.appendFormat(retval, sheetName);
            retval.append('!');
        }
        retval.append(new CellReference(this.getRow(), this.getColumn(), !this.isRowRelative(), !this.isColRelative()).formatAsString());
        return retval.toString();
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public Object clone() {
        Ref3DPtg ptg = new Ref3DPtg();
        ptg.field_1_index_extern_sheet = this.field_1_index_extern_sheet;
        ptg.field_2_row = this.field_2_row;
        ptg.field_3_column = this.field_3_column;
        ptg.setClass(this.ptgClass);
        return ptg;
    }
}

