/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula;

import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.hssf.record.formula.Ptg;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.CellReference;
import org.apache.poi.util.BitField;
import org.apache.poi.util.BitFieldFactory;
import org.apache.poi.util.LittleEndian;

public class ReferencePtg
extends Ptg {
    private static final int SIZE = 5;
    public static final byte sid = 36;
    private static final int MAX_ROW_NUMBER = 65536;
    private int field_1_row;
    private int field_2_col;
    private static final BitField rowRelative = BitFieldFactory.getInstance(32768);
    private static final BitField colRelative = BitFieldFactory.getInstance(16384);
    private static final BitField column = BitFieldFactory.getInstance(255);

    protected final RuntimeException notImplemented() {
        return new RuntimeException("Coding Error: This method should never be called. This ptg should be converted");
    }

    protected ReferencePtg() {
    }

    public ReferencePtg(String cellref) {
        CellReference c = new CellReference(cellref);
        this.setRow(c.getRow());
        this.setColumn(c.getCol());
        this.setColRelative(!c.isColAbsolute());
        this.setRowRelative(!c.isRowAbsolute());
    }

    public ReferencePtg(int row, int column, boolean isRowRelative, boolean isColumnRelative) {
        this.setRow(row);
        this.setColumn(column);
        this.setRowRelative(isRowRelative);
        this.setColRelative(isColumnRelative);
    }

    public ReferencePtg(RecordInputStream in) {
        this.field_1_row = in.readUShort();
        this.field_2_col = in.readUShort();
    }

    public String getRefPtgName() {
        return "ReferencePtg";
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("[");
        buffer.append(this.getRefPtgName());
        buffer.append("]\n");
        buffer.append("row = ").append(this.getRow()).append("\n");
        buffer.append("col = ").append(this.getColumn()).append("\n");
        buffer.append("rowrelative = ").append(this.isRowRelative()).append("\n");
        buffer.append("colrelative = ").append(this.isColRelative()).append("\n");
        return buffer.toString();
    }

    public void writeBytes(byte[] array, int offset) {
        array[offset] = (byte)(36 + this.ptgClass);
        LittleEndian.putShort(array, offset + 1, (short)this.field_1_row);
        LittleEndian.putShort(array, offset + 3, (short)this.field_2_col);
    }

    public void setRow(int row) {
        if (row < 0 || row >= 65536) {
            throw new IllegalArgumentException("The row number, when specified as an integer, must be between 0 and 65536");
        }
        this.field_1_row = row;
    }

    public int getRow() {
        return this.field_1_row;
    }

    public int getRowAsInt() {
        if (this.field_1_row < 0) {
            return this.field_1_row + 65536;
        }
        return this.field_1_row;
    }

    public boolean isRowRelative() {
        return rowRelative.isSet(this.field_2_col);
    }

    public void setRowRelative(boolean rel) {
        this.field_2_col = rowRelative.setBoolean(this.field_2_col, rel);
    }

    public boolean isColRelative() {
        return colRelative.isSet(this.field_2_col);
    }

    public void setColRelative(boolean rel) {
        this.field_2_col = colRelative.setBoolean(this.field_2_col, rel);
    }

    public void setColumnRaw(int col) {
        this.field_2_col = col;
    }

    public int getColumnRaw() {
        return this.field_2_col;
    }

    public void setColumn(int col) {
        if (col < 0 || col > 256) {
            throw new IllegalArgumentException("Specified colIx (" + col + ") is out of range");
        }
        this.field_2_col = column.setValue(this.field_2_col, col);
    }

    public int getColumn() {
        return column.getValue(this.field_2_col);
    }

    public int getSize() {
        return 5;
    }

    public String toFormulaString(HSSFWorkbook book) {
        return new CellReference(this.getRowAsInt(), this.getColumn(), !this.isRowRelative(), !this.isColRelative()).formatAsString();
    }

    public byte getDefaultOperandClass() {
        return 0;
    }

    public Object clone() {
        ReferencePtg ptg = new ReferencePtg();
        ptg.field_1_row = this.field_1_row;
        ptg.field_2_col = this.field_2_col;
        ptg.setClass(this.ptgClass);
        return ptg;
    }
}

