/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record.formula.functions;

import org.apache.poi.hssf.record.formula.Area3DPtg;
import org.apache.poi.hssf.record.formula.AreaPtg;
import org.apache.poi.hssf.record.formula.eval.Area3DEval;
import org.apache.poi.hssf.record.formula.eval.AreaEval;
import org.apache.poi.hssf.record.formula.eval.BoolEval;
import org.apache.poi.hssf.record.formula.eval.ErrorEval;
import org.apache.poi.hssf.record.formula.eval.Eval;
import org.apache.poi.hssf.record.formula.eval.NumericValueEval;
import org.apache.poi.hssf.record.formula.eval.Ref3DEval;
import org.apache.poi.hssf.record.formula.eval.RefEval;
import org.apache.poi.hssf.record.formula.eval.StringEval;
import org.apache.poi.hssf.record.formula.eval.ValueEval;
import org.apache.poi.hssf.record.formula.functions.Countif;
import org.apache.poi.hssf.record.formula.functions.FreeRefFunction;
import org.apache.poi.hssf.usermodel.HSSFFormulaEvaluator;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public final class Offset
implements FreeRefFunction {
    private static final int LAST_VALID_ROW_INDEX = 65535;
    private static final int LAST_VALID_COLUMN_INDEX = 255;

    public ValueEval evaluate(Eval[] args, int srcCellRow, short srcCellCol, HSSFWorkbook workbook, HSSFSheet sheet) {
        if (args.length < 3 || args.length > 5) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            BaseRef baseRef = Offset.evaluateBaseRef(args[0]);
            int rowOffset = Offset.evaluateIntArg(args[1], srcCellRow, srcCellCol);
            int columnOffset = Offset.evaluateIntArg(args[2], srcCellRow, srcCellCol);
            int height = baseRef.getHeight();
            int width = baseRef.getWidth();
            switch (args.length) {
                case 5: {
                    width = Offset.evaluateIntArg(args[4], srcCellRow, srcCellCol);
                }
                case 4: {
                    height = Offset.evaluateIntArg(args[3], srcCellRow, srcCellCol);
                }
            }
            if (height == 0 || width == 0) {
                return ErrorEval.REF_INVALID;
            }
            LinearOffsetRange rowOffsetRange = new LinearOffsetRange(rowOffset, height);
            LinearOffsetRange colOffsetRange = new LinearOffsetRange(columnOffset, width);
            return Offset.createOffset(baseRef, rowOffsetRange, colOffsetRange, workbook, sheet);
        }
        catch (EvalEx e) {
            return e.getError();
        }
    }

    private static AreaEval createOffset(BaseRef baseRef, LinearOffsetRange rowOffsetRange, LinearOffsetRange colOffsetRange, HSSFWorkbook workbook, HSSFSheet sheet) throws EvalEx {
        LinearOffsetRange rows = rowOffsetRange.normaliseAndTranslate(baseRef.getFirstRowIndex());
        LinearOffsetRange cols = colOffsetRange.normaliseAndTranslate(baseRef.getFirstColumnIndex());
        if (rows.isOutOfBounds(0, 65535)) {
            throw new EvalEx(ErrorEval.REF_INVALID);
        }
        if (cols.isOutOfBounds(0, 255)) {
            throw new EvalEx(ErrorEval.REF_INVALID);
        }
        if (baseRef.isIs3d()) {
            Area3DPtg a3dp = new Area3DPtg(rows.getFirstIndex(), rows.getLastIndex(), cols.getFirstIndex(), cols.getLastIndex(), false, false, false, false, baseRef.getExternalSheetIndex());
            return HSSFFormulaEvaluator.evaluateArea3dPtg(workbook, a3dp);
        }
        AreaPtg ap = new AreaPtg(rows.getFirstIndex(), rows.getLastIndex(), cols.getFirstIndex(), cols.getLastIndex(), false, false, false, false);
        return HSSFFormulaEvaluator.evaluateAreaPtg(sheet, workbook, ap);
    }

    private static BaseRef evaluateBaseRef(Eval eval) throws EvalEx {
        if (eval instanceof RefEval) {
            return new BaseRef((RefEval)eval);
        }
        if (eval instanceof AreaEval) {
            return new BaseRef((AreaEval)eval);
        }
        if (eval instanceof ErrorEval) {
            throw new EvalEx((ErrorEval)eval);
        }
        throw new EvalEx(ErrorEval.VALUE_INVALID);
    }

    private static int evaluateIntArg(Eval eval, int srcCellRow, short srcCellCol) throws EvalEx {
        double d = Offset.evaluateDoubleArg(eval, srcCellRow, srcCellCol);
        return Offset.convertDoubleToInt(d);
    }

    static int convertDoubleToInt(double d) {
        return (int)Math.floor(d);
    }

    private static double evaluateDoubleArg(Eval eval, int srcCellRow, short srcCellCol) throws EvalEx {
        ValueEval ve = Offset.evaluateSingleValue(eval, srcCellRow, srcCellCol);
        if (ve instanceof NumericValueEval) {
            return ((NumericValueEval)ve).getNumberValue();
        }
        if (ve instanceof StringEval) {
            StringEval se = (StringEval)ve;
            Double d = Offset.parseDouble(se.getStringValue());
            if (d == null) {
                throw new EvalEx(ErrorEval.VALUE_INVALID);
            }
            return d;
        }
        if (ve instanceof BoolEval) {
            if (((BoolEval)ve).getBooleanValue()) {
                return 1.0;
            }
            return 0.0;
        }
        throw new RuntimeException("Unexpected eval type (" + ve.getClass().getName() + ")");
    }

    private static Double parseDouble(String s) {
        return Countif.parseDouble(s);
    }

    private static ValueEval evaluateSingleValue(Eval eval, int srcCellRow, short srcCellCol) throws EvalEx {
        if (eval instanceof RefEval) {
            return ((RefEval)eval).getInnerValueEval();
        }
        if (eval instanceof AreaEval) {
            return Offset.chooseSingleElementFromArea((AreaEval)eval, srcCellRow, srcCellCol);
        }
        if (eval instanceof ValueEval) {
            return (ValueEval)eval;
        }
        throw new RuntimeException("Unexpected eval type (" + eval.getClass().getName() + ")");
    }

    private static ValueEval chooseSingleElementFromArea(AreaEval ae, int srcCellRow, short srcCellCol) throws EvalEx {
        if (ae.isColumn()) {
            if (ae.isRow()) {
                return ae.getValues()[0];
            }
            if (!ae.containsRow(srcCellRow)) {
                throw new EvalEx(ErrorEval.VALUE_INVALID);
            }
            return ae.getValueAt(srcCellRow, ae.getFirstColumn());
        }
        if (!ae.isRow()) {
            throw new EvalEx(ErrorEval.VALUE_INVALID);
        }
        if (!ae.containsColumn(srcCellCol)) {
            throw new EvalEx(ErrorEval.VALUE_INVALID);
        }
        return ae.getValueAt(ae.getFirstRow(), srcCellCol);
    }

    private static final class BaseRef {
        private static final int INVALID_SHEET_INDEX = -1;
        private final int _firstRowIndex;
        private final int _firstColumnIndex;
        private final int _width;
        private final int _height;
        private final int _externalSheetIndex;

        public BaseRef(RefEval re) {
            this._firstRowIndex = re.getRow();
            this._firstColumnIndex = re.getColumn();
            this._height = 1;
            this._width = 1;
            if (re instanceof Ref3DEval) {
                Ref3DEval r3e = (Ref3DEval)re;
                this._externalSheetIndex = r3e.getExternSheetIndex();
            } else {
                this._externalSheetIndex = -1;
            }
        }

        public BaseRef(AreaEval ae) {
            this._firstRowIndex = ae.getFirstRow();
            this._firstColumnIndex = ae.getFirstColumn();
            this._height = ae.getLastRow() - ae.getFirstRow() + 1;
            this._width = ae.getLastColumn() - ae.getFirstColumn() + 1;
            if (ae instanceof Area3DEval) {
                Area3DEval a3e = (Area3DEval)ae;
                this._externalSheetIndex = a3e.getExternSheetIndex();
            } else {
                this._externalSheetIndex = -1;
            }
        }

        public int getWidth() {
            return this._width;
        }

        public int getHeight() {
            return this._height;
        }

        public int getFirstRowIndex() {
            return this._firstRowIndex;
        }

        public int getFirstColumnIndex() {
            return this._firstColumnIndex;
        }

        public boolean isIs3d() {
            return this._externalSheetIndex > 0;
        }

        public short getExternalSheetIndex() {
            if (this._externalSheetIndex < 0) {
                throw new IllegalStateException("external sheet index only available for 3d refs");
            }
            return (short)this._externalSheetIndex;
        }
    }

    static final class LinearOffsetRange {
        private final int _offset;
        private final int _length;

        public LinearOffsetRange(int offset, int length) {
            if (length == 0) {
                throw new RuntimeException("length may not be zero");
            }
            this._offset = offset;
            this._length = length;
        }

        public short getFirstIndex() {
            return (short)this._offset;
        }

        public short getLastIndex() {
            return (short)(this._offset + this._length - 1);
        }

        public LinearOffsetRange normaliseAndTranslate(int translationAmount) {
            if (this._length > 0) {
                if (translationAmount == 0) {
                    return this;
                }
                return new LinearOffsetRange(translationAmount + this._offset, this._length);
            }
            return new LinearOffsetRange(translationAmount + this._offset + this._length + 1, -this._length);
        }

        public boolean isOutOfBounds(int lowValidIx, int highValidIx) {
            if (this._offset < lowValidIx) {
                return true;
            }
            return this.getLastIndex() > highValidIx;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(64);
            sb.append(this.getClass().getName()).append(" [");
            sb.append(this._offset).append("...").append(this.getLastIndex());
            sb.append("]");
            return sb.toString();
        }
    }

    private static final class EvalEx
    extends Exception {
        private final ErrorEval _error;

        public EvalEx(ErrorEval error) {
            this._error = error;
        }

        public ErrorEval getError() {
            return this._error;
        }
    }
}

