/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.apache.poi.hssf.util.CellReference;

public final class AreaReference {
    private static final char SHEET_NAME_DELIMITER = '!';
    private static final char CELL_DELIMITER = ':';
    private static final char SPECIAL_NAME_DELIMITER = '\'';
    private final CellReference _firstCell;
    private final CellReference _lastCell;
    private final boolean _isSingleCell;

    public AreaReference(String reference) {
        if (!AreaReference.isContiguous(reference)) {
            throw new IllegalArgumentException("References passed to the AreaReference must be contiguous, use generateContiguous(ref) if you have non-contiguous references");
        }
        String[] parts = AreaReference.separateAreaRefs(reference);
        if (parts.length == 2 && parts[0].length() == 1 && parts[1].length() == 1 && parts[0].charAt(0) >= 'A' && parts[0].charAt(0) <= 'Z' && parts[1].charAt(0) >= 'A' && parts[1].charAt(0) <= 'Z') {
            parts[0] = parts[0] + "$1";
            parts[1] = parts[1] + "$65536";
        }
        this._firstCell = new CellReference(parts[0]);
        if (parts.length == 2) {
            this._lastCell = new CellReference(parts[1]);
            this._isSingleCell = false;
        } else {
            this._lastCell = this._firstCell;
            this._isSingleCell = true;
        }
    }

    public AreaReference(CellReference topLeft, CellReference botRight) {
        this._firstCell = topLeft;
        this._lastCell = botRight;
        this._isSingleCell = false;
    }

    public static boolean isContiguous(String reference) {
        return reference.indexOf(44) == -1;
    }

    public static boolean isWholeColumnReference(CellReference topLeft, CellReference botRight) {
        return topLeft.getRow() == 0 && topLeft.isRowAbsolute() && botRight.getRow() == 65535 && botRight.isRowAbsolute();
    }

    public boolean isWholeColumnReference() {
        return AreaReference.isWholeColumnReference(this._firstCell, this._lastCell);
    }

    public static AreaReference[] generateContiguous(String reference) {
        ArrayList<AreaReference> refs = new ArrayList<AreaReference>();
        StringTokenizer st = new StringTokenizer(reference, ",");
        while (st.hasMoreTokens()) {
            refs.add(new AreaReference(st.nextToken()));
        }
        return refs.toArray(new AreaReference[refs.size()]);
    }

    public boolean isSingleCell() {
        return this._isSingleCell;
    }

    public CellReference getFirstCell() {
        return this._firstCell;
    }

    public CellReference getLastCell() {
        return this._lastCell;
    }

    public CellReference[] getAllReferencedCells() {
        if (this._isSingleCell) {
            return new CellReference[]{this._firstCell};
        }
        int minRow = Math.min(this._firstCell.getRow(), this._lastCell.getRow());
        int maxRow = Math.max(this._firstCell.getRow(), this._lastCell.getRow());
        int minCol = Math.min(this._firstCell.getCol(), this._lastCell.getCol());
        int maxCol = Math.max(this._firstCell.getCol(), this._lastCell.getCol());
        String sheetName = this._firstCell.getSheetName();
        ArrayList<CellReference> refs = new ArrayList<CellReference>();
        for (int row = minRow; row <= maxRow; ++row) {
            for (int col = minCol; col <= maxCol; ++col) {
                CellReference ref = new CellReference(sheetName, row, col, this._firstCell.isRowAbsolute(), this._firstCell.isColAbsolute());
                refs.add(ref);
            }
        }
        return refs.toArray(new CellReference[refs.size()]);
    }

    public String formatAsString() {
        if (this.isWholeColumnReference()) {
            return CellReference.convertNumToColString(this._firstCell.getCol()) + ":" + CellReference.convertNumToColString(this._lastCell.getCol());
        }
        StringBuffer sb = new StringBuffer(32);
        sb.append(this._firstCell.formatAsString());
        if (!this._isSingleCell) {
            sb.append(':');
            if (this._lastCell.getSheetName() == null) {
                sb.append(this._lastCell.formatAsString());
            } else {
                this._lastCell.appendCellReference(sb);
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getClass().getName()).append(" [");
        sb.append(this.formatAsString());
        sb.append("]");
        return sb.toString();
    }

    private static String[] separateAreaRefs(String reference) {
        int len = reference.length();
        int delimiterPos = -1;
        boolean insideDelimitedName = false;
        block4: for (int i = 0; i < len; ++i) {
            switch (reference.charAt(i)) {
                case ':': {
                    if (!insideDelimitedName) {
                        if (delimiterPos >= 0) {
                            throw new IllegalArgumentException("More than one cell delimiter ':' appears in area reference '" + reference + "'");
                        }
                        delimiterPos = i;
                    }
                }
                default: {
                    continue block4;
                }
                case '\'': {
                    if (!insideDelimitedName) {
                        insideDelimitedName = true;
                        continue block4;
                    }
                    if (i >= len - 1) {
                        throw new IllegalArgumentException("Area reference '" + reference + "' ends with special name delimiter '" + '\'' + "'");
                    }
                    if (reference.charAt(i + 1) == '\'') {
                        ++i;
                        continue block4;
                    }
                    insideDelimitedName = false;
                }
            }
        }
        if (delimiterPos < 0) {
            return new String[]{reference};
        }
        String partA = reference.substring(0, delimiterPos);
        String partB = reference.substring(delimiterPos + 1);
        if (partB.indexOf(33) >= 0) {
            throw new RuntimeException("Unexpected ! in second cell reference of '" + reference + "'");
        }
        int plingPos = partA.lastIndexOf(33);
        if (plingPos < 0) {
            return new String[]{partA, partB};
        }
        String sheetName = partA.substring(0, plingPos + 1);
        return new String[]{partA, sheetName + partB};
    }
}

