/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.core;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.logicalcobwebs.cglib.core.Predicate;
import org.logicalcobwebs.cglib.core.Transformer;

public class CollectionUtils {
    private CollectionUtils() {
    }

    public static Map bucket(Collection c, Transformer t) {
        HashMap buckets = new HashMap();
        Iterator it = c.iterator();
        while (it.hasNext()) {
            Object value = it.next();
            Object key = t.transform(value);
            LinkedList bucket = (LinkedList)buckets.get(key);
            if (bucket == null) {
                bucket = new LinkedList();
                buckets.put(key, bucket);
            }
            bucket.add(value);
        }
        return buckets;
    }

    public static void reverse(Map source, Map target) {
        Iterator it = source.keySet().iterator();
        while (it.hasNext()) {
            Object key = it.next();
            target.put(source.get(key), key);
        }
    }

    public static Object[] filter(Object[] a, Predicate p) {
        ArrayList<Object> c = new ArrayList<Object>(Arrays.asList(a));
        CollectionUtils.filter(c, p);
        return c.toArray((Object[])Array.newInstance(a.getClass().getComponentType(), c.size()));
    }

    public static Collection filter(Collection c, Predicate p) {
        Iterator it = c.iterator();
        while (it.hasNext()) {
            if (p.evaluate(it.next())) continue;
            it.remove();
        }
        return c;
    }

    public static List transform(List c, Transformer t) {
        ArrayList<Object> result = new ArrayList<Object>(c.size());
        Iterator it = c.iterator();
        while (it.hasNext()) {
            result.add(t.transform(it.next()));
        }
        return result;
    }
}

