/*
 * Decompiled with CFR 0.152.
 */
package org.logicalcobwebs.cglib.proxy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.logicalcobwebs.asm.ClassVisitor;
import org.logicalcobwebs.cglib.core.AbstractClassGenerator;
import org.logicalcobwebs.cglib.core.ClassesKey;
import org.logicalcobwebs.cglib.core.KeyFactory;
import org.logicalcobwebs.cglib.core.ReflectUtils;
import org.logicalcobwebs.cglib.proxy.MixinBeanEmitter;
import org.logicalcobwebs.cglib.proxy.MixinEmitter;

public abstract class Mixin {
    private static final MixinKey KEY_FACTORY = (MixinKey)((Object)KeyFactory.create(class$org$logicalcobwebs$cglib$proxy$Mixin$MixinKey == null ? (class$org$logicalcobwebs$cglib$proxy$Mixin$MixinKey = Mixin.class$("org.logicalcobwebs.cglib.proxy.Mixin$MixinKey")) : class$org$logicalcobwebs$cglib$proxy$Mixin$MixinKey, KeyFactory.CLASS_BY_NAME));
    private static final Map ROUTE_CACHE = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$logicalcobwebs$cglib$proxy$Mixin$MixinKey;
    static /* synthetic */ Class class$org$logicalcobwebs$cglib$proxy$Mixin;
    static /* synthetic */ Class class$java$lang$Object;

    public abstract Mixin newInstance(Object[] var1);

    public static Mixin create(Object[] delegates) {
        Generator gen = new Generator();
        gen.setDelegates(delegates);
        return gen.create();
    }

    public static Mixin create(Class[] interfaces, Object[] delegates) {
        Generator gen = new Generator();
        gen.setClasses(interfaces);
        gen.setDelegates(delegates);
        return gen.create();
    }

    public static Mixin createBean(Object[] beans) {
        Generator gen = new Generator();
        gen.setAsBeans(true);
        gen.setDelegates(beans);
        return gen.create();
    }

    public static Class[] getClasses(Object[] delegates) {
        return (Class[])Mixin.route(delegates).classes.clone();
    }

    public static int[] getRoute(Object[] delegates) {
        return (int[])Mixin.route(delegates).route.clone();
    }

    private static Route route(Object[] delegates) {
        Object key = ClassesKey.create(delegates);
        Route route = (Route)ROUTE_CACHE.get(key);
        if (route == null) {
            route = new Route(delegates);
            ROUTE_CACHE.put(key, route);
        }
        return route;
    }

    private static void collectAllInterfaces(Class type, List list) {
        if (!type.equals(class$java$lang$Object == null ? (class$java$lang$Object = Mixin.class$("java.lang.Object")) : class$java$lang$Object)) {
            list.addAll(Arrays.asList(type.getInterfaces()));
            Mixin.collectAllInterfaces(type.getSuperclass(), list);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class Route {
        private Class[] classes;
        private int[] route;

        Route(Object[] delegates) {
            HashMap<Class, Integer> map = new HashMap<Class, Integer>();
            ArrayList collect = new ArrayList();
            for (int i = 0; i < delegates.length; ++i) {
                Class<?> delegate = delegates[i].getClass();
                collect.clear();
                Mixin.collectAllInterfaces(delegate, collect);
                Iterator it = collect.iterator();
                while (it.hasNext()) {
                    Class iface = (Class)it.next();
                    if (map.containsKey(iface)) continue;
                    map.put(iface, new Integer(i));
                }
            }
            this.classes = new Class[map.size()];
            this.route = new int[map.size()];
            int index = 0;
            Iterator it = map.keySet().iterator();
            while (it.hasNext()) {
                Class key;
                this.classes[index] = key = (Class)it.next();
                this.route[index] = (Integer)map.get(key);
                ++index;
            }
        }
    }

    public static class Generator
    extends AbstractClassGenerator {
        private static final AbstractClassGenerator.Source SOURCE = new AbstractClassGenerator.Source((class$org$logicalcobwebs$cglib$proxy$Mixin == null ? (class$org$logicalcobwebs$cglib$proxy$Mixin = Mixin.class$("org.logicalcobwebs.cglib.proxy.Mixin")) : class$org$logicalcobwebs$cglib$proxy$Mixin).getName());
        private Class[] classes;
        private Object[] delegates;
        private int[] route;
        private boolean asBeans;

        public Generator() {
            super(SOURCE);
        }

        protected ClassLoader getDefaultClassLoader() {
            return this.delegates[0].getClass().getClassLoader();
        }

        public void setAsBeans(boolean asBeans) {
            this.asBeans = asBeans;
        }

        public void setClasses(Class[] classes) {
            this.classes = classes;
        }

        public void setDelegates(Object[] delegates) {
            this.delegates = delegates;
        }

        public void setRoute(int[] route) {
            this.route = route;
        }

        public Mixin create() {
            if (this.classes == null) {
                if (this.asBeans) {
                    this.classes = ReflectUtils.getClasses(this.delegates);
                    this.route = null;
                } else {
                    Route r = Mixin.route(this.delegates);
                    this.classes = r.classes;
                    this.route = r.route;
                }
            }
            this.setNamePrefix(this.classes[ReflectUtils.findPackageProtected(this.classes)].getName());
            return (Mixin)super.create(KEY_FACTORY.newInstance(this.classes, this.route));
        }

        public void generateClass(ClassVisitor v) {
            if (this.asBeans) {
                new MixinBeanEmitter(v, this.getClassName(), this.classes);
            } else {
                new MixinEmitter(v, this.getClassName(), this.classes, this.route);
            }
        }

        protected Object firstInstance(Class type) {
            return ((Mixin)ReflectUtils.newInstance(type)).newInstance(this.delegates);
        }

        protected Object nextInstance(Object instance) {
            return ((Mixin)instance).newInstance(this.delegates);
        }
    }

    static interface MixinKey {
        public Object newInstance(Class[] var1, int[] var2);
    }
}

