/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.ws.handler;

import com.sun.xml.internal.ws.api.WSBinding;
import com.sun.xml.internal.ws.api.message.AttachmentSet;
import com.sun.xml.internal.ws.api.message.Packet;
import com.sun.xml.internal.ws.api.model.wsdl.WSDLPort;
import com.sun.xml.internal.ws.api.pipe.Tube;
import com.sun.xml.internal.ws.api.pipe.TubeCloner;
import com.sun.xml.internal.ws.api.pipe.helper.AbstractFilterTubeImpl;
import com.sun.xml.internal.ws.binding.BindingImpl;
import com.sun.xml.internal.ws.client.HandlerConfiguration;
import com.sun.xml.internal.ws.handler.HandlerProcessor;
import com.sun.xml.internal.ws.handler.HandlerTube;
import com.sun.xml.internal.ws.handler.MessageUpdatableContext;
import com.sun.xml.internal.ws.handler.SOAPHandlerProcessor;
import com.sun.xml.internal.ws.handler.SOAPMessageContextImpl;
import com.sun.xml.internal.ws.message.DataHandlerAttachment;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.activation.DataHandler;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.MessageContext;
import javax.xml.ws.handler.soap.SOAPHandler;

public class ClientSOAPHandlerTube
extends HandlerTube {
    private WSBinding binding;
    private List<SOAPHandler> soapHandlers;
    private Set<String> roles;

    public ClientSOAPHandlerTube(WSBinding wSBinding, WSDLPort wSDLPort, Tube tube) {
        super(tube, wSDLPort);
        if (wSBinding.getSOAPVersion() != null) {
            // empty if block
        }
        this.binding = wSBinding;
    }

    public ClientSOAPHandlerTube(WSBinding wSBinding, Tube tube, HandlerTube handlerTube) {
        super(tube, handlerTube);
        this.binding = wSBinding;
    }

    private ClientSOAPHandlerTube(ClientSOAPHandlerTube clientSOAPHandlerTube, TubeCloner tubeCloner) {
        super(clientSOAPHandlerTube, tubeCloner);
        this.binding = clientSOAPHandlerTube.binding;
    }

    boolean isHandlerChainEmpty() {
        return this.soapHandlers.isEmpty();
    }

    public void close(MessageContext messageContext) {
    }

    public void closeCall(MessageContext messageContext) {
        this.closeSOAPHandlers(messageContext);
    }

    private void closeSOAPHandlers(MessageContext messageContext) {
        if (this.processor == null) {
            return;
        }
        if (this.remedyActionTaken) {
            this.processor.closeHandlers(messageContext, this.processor.getIndex(), 0);
            this.processor.setIndex(-1);
            this.remedyActionTaken = false;
        } else {
            this.processor.closeHandlers(messageContext, this.soapHandlers.size() - 1, 0);
        }
    }

    public AbstractFilterTubeImpl copy(TubeCloner tubeCloner) {
        return new ClientSOAPHandlerTube(this, tubeCloner);
    }

    void setUpProcessor() {
        this.soapHandlers = new ArrayList<SOAPHandler>();
        HandlerConfiguration handlerConfiguration = ((BindingImpl)this.binding).getHandlerConfig();
        List<SOAPHandler> list = handlerConfiguration.getSoapHandlers();
        if (!list.isEmpty()) {
            this.soapHandlers.addAll(list);
            this.roles = new HashSet<String>();
            this.roles.addAll(handlerConfiguration.getRoles());
            this.processor = new SOAPHandlerProcessor(true, this, this.binding, this.soapHandlers);
        }
    }

    MessageUpdatableContext getContext(Packet packet) {
        SOAPMessageContextImpl sOAPMessageContextImpl = new SOAPMessageContextImpl(this.binding, packet);
        sOAPMessageContextImpl.setRoles(this.roles);
        return sOAPMessageContextImpl;
    }

    boolean callHandlersOnRequest(MessageUpdatableContext messageUpdatableContext, boolean bl) {
        boolean bl2;
        Map map = (Map)messageUpdatableContext.get("javax.xml.ws.binding.attachments.outbound");
        AttachmentSet attachmentSet = this.packet.getMessage().getAttachments();
        for (String string : map.keySet()) {
            DataHandlerAttachment dataHandlerAttachment = new DataHandlerAttachment(string, (DataHandler)map.get(string));
            attachmentSet.add(dataHandlerAttachment);
        }
        try {
            bl2 = this.processor.callHandlersRequest(HandlerProcessor.Direction.OUTBOUND, messageUpdatableContext, !bl);
        }
        catch (WebServiceException webServiceException) {
            this.remedyActionTaken = true;
            throw webServiceException;
        }
        catch (RuntimeException runtimeException) {
            this.remedyActionTaken = true;
            throw new WebServiceException(runtimeException);
        }
        if (!bl2) {
            this.remedyActionTaken = true;
        }
        return bl2;
    }

    void callHandlersOnResponse(MessageUpdatableContext messageUpdatableContext, boolean bl) {
        try {
            this.processor.callHandlersResponse(HandlerProcessor.Direction.INBOUND, messageUpdatableContext, bl);
        }
        catch (WebServiceException webServiceException) {
            throw webServiceException;
        }
        catch (RuntimeException runtimeException) {
            throw new WebServiceException(runtimeException);
        }
    }
}

