/*
 * Decompiled with CFR 0.152.
 */
package org.acegisecurity.providers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.acegisecurity.AbstractAuthenticationManager;
import org.acegisecurity.AcegiMessageSource;
import org.acegisecurity.Authentication;
import org.acegisecurity.AuthenticationException;
import org.acegisecurity.concurrent.ConcurrentSessionController;
import org.acegisecurity.concurrent.NullConcurrentSessionController;
import org.acegisecurity.event.authentication.AbstractAuthenticationEvent;
import org.acegisecurity.event.authentication.AuthenticationSuccessEvent;
import org.acegisecurity.providers.AbstractAuthenticationToken;
import org.acegisecurity.providers.AuthenticationProvider;
import org.acegisecurity.providers.ProviderNotFoundException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.MessageSource;
import org.springframework.context.MessageSourceAware;
import org.springframework.context.support.MessageSourceAccessor;
import org.springframework.util.Assert;

public class ProviderManager
extends AbstractAuthenticationManager
implements InitializingBean,
ApplicationEventPublisherAware,
MessageSourceAware {
    private static final Log logger = LogFactory.getLog((Class)(class$org$acegisecurity$providers$ProviderManager == null ? (class$org$acegisecurity$providers$ProviderManager = ProviderManager.class$("org.acegisecurity.providers.ProviderManager")) : class$org$acegisecurity$providers$ProviderManager));
    private static final Properties DEFAULT_EXCEPTION_MAPPINGS = new Properties();
    private ApplicationEventPublisher applicationEventPublisher;
    private ConcurrentSessionController sessionController = new NullConcurrentSessionController();
    private List providers;
    protected MessageSourceAccessor messages = AcegiMessageSource.getAccessor();
    private Properties exceptionMappings = new Properties();
    static /* synthetic */ Class class$org$acegisecurity$providers$ProviderManager;
    static /* synthetic */ Class class$org$acegisecurity$AccountExpiredException;
    static /* synthetic */ Class class$org$acegisecurity$event$authentication$AuthenticationFailureExpiredEvent;
    static /* synthetic */ Class class$org$acegisecurity$AuthenticationServiceException;
    static /* synthetic */ Class class$org$acegisecurity$event$authentication$AuthenticationFailureServiceExceptionEvent;
    static /* synthetic */ Class class$org$acegisecurity$LockedException;
    static /* synthetic */ Class class$org$acegisecurity$event$authentication$AuthenticationFailureLockedEvent;
    static /* synthetic */ Class class$org$acegisecurity$CredentialsExpiredException;
    static /* synthetic */ Class class$org$acegisecurity$event$authentication$AuthenticationFailureCredentialsExpiredEvent;
    static /* synthetic */ Class class$org$acegisecurity$DisabledException;
    static /* synthetic */ Class class$org$acegisecurity$event$authentication$AuthenticationFailureDisabledEvent;
    static /* synthetic */ Class class$org$acegisecurity$BadCredentialsException;
    static /* synthetic */ Class class$org$acegisecurity$event$authentication$AuthenticationFailureBadCredentialsEvent;
    static /* synthetic */ Class class$org$acegisecurity$userdetails$UsernameNotFoundException;
    static /* synthetic */ Class class$org$acegisecurity$concurrent$ConcurrentLoginException;
    static /* synthetic */ Class class$org$acegisecurity$event$authentication$AuthenticationFailureConcurrentLoginEvent;
    static /* synthetic */ Class class$org$acegisecurity$providers$ProviderNotFoundException;
    static /* synthetic */ Class class$org$acegisecurity$event$authentication$AuthenticationFailureProviderNotFoundEvent;
    static /* synthetic */ Class class$org$acegisecurity$providers$cas$ProxyUntrustedException;
    static /* synthetic */ Class class$org$acegisecurity$event$authentication$AuthenticationFailureProxyUntrustedEvent;
    static /* synthetic */ Class class$org$acegisecurity$Authentication;
    static /* synthetic */ Class class$org$acegisecurity$AuthenticationException;
    static /* synthetic */ Class class$org$acegisecurity$event$authentication$AbstractAuthenticationEvent;
    static /* synthetic */ Class class$org$acegisecurity$providers$AuthenticationProvider;

    public ProviderManager() {
        this.exceptionMappings.putAll((Map<?, ?>)DEFAULT_EXCEPTION_MAPPINGS);
    }

    public void afterPropertiesSet() throws Exception {
        this.checkIfValidList(this.providers);
        Assert.notNull((Object)this.messages, (String)"A message source must be set");
        this.doAddExtraDefaultExceptionMappings(this.exceptionMappings);
    }

    private void checkIfValidList(List listToCheck) {
        if (listToCheck == null || listToCheck.size() == 0) {
            throw new IllegalArgumentException("A list of AuthenticationManagers is required");
        }
    }

    protected void doAddExtraDefaultExceptionMappings(Properties exceptionMappings) {
    }

    public Authentication doAuthentication(Authentication authentication) throws AuthenticationException {
        Iterator iter = this.providers.iterator();
        Class<?> toTest = authentication.getClass();
        Object lastException = null;
        while (iter.hasNext()) {
            AuthenticationProvider provider = (AuthenticationProvider)iter.next();
            if (!provider.supports(toTest)) continue;
            logger.debug((Object)("Authentication attempt using " + provider.getClass().getName()));
            Authentication result = null;
            try {
                result = provider.authenticate(authentication);
                this.copyDetails(authentication, result);
                this.sessionController.checkAuthenticationAllowed(result);
            }
            catch (AuthenticationException ae) {
                lastException = ae;
                result = null;
            }
            if (result == null) continue;
            this.sessionController.registerSuccessfulAuthentication(result);
            this.publishEvent(new AuthenticationSuccessEvent(result));
            return result;
        }
        if (lastException == null) {
            lastException = new ProviderNotFoundException(this.messages.getMessage("ProviderManager.providerNotFound", new Object[]{toTest.getName()}, "No AuthenticationProvider found for {0}"));
        }
        String className = this.exceptionMappings.getProperty(lastException.getClass().getName());
        AbstractAuthenticationEvent event = null;
        if (className != null) {
            try {
                Class<?> clazz = this.getClass().getClassLoader().loadClass(className);
                Constructor<?> constructor = clazz.getConstructor(class$org$acegisecurity$Authentication == null ? (class$org$acegisecurity$Authentication = ProviderManager.class$("org.acegisecurity.Authentication")) : class$org$acegisecurity$Authentication, class$org$acegisecurity$AuthenticationException == null ? (class$org$acegisecurity$AuthenticationException = ProviderManager.class$("org.acegisecurity.AuthenticationException")) : class$org$acegisecurity$AuthenticationException);
                Object obj = constructor.newInstance(authentication, lastException);
                Assert.isInstanceOf((Class)(class$org$acegisecurity$event$authentication$AbstractAuthenticationEvent == null ? (class$org$acegisecurity$event$authentication$AbstractAuthenticationEvent = ProviderManager.class$("org.acegisecurity.event.authentication.AbstractAuthenticationEvent")) : class$org$acegisecurity$event$authentication$AbstractAuthenticationEvent), obj, (String)"Must be an AbstractAuthenticationEvent");
                event = (AbstractAuthenticationEvent)((Object)obj);
            }
            catch (ClassNotFoundException ignored) {
            }
            catch (NoSuchMethodException ignored) {
            }
            catch (IllegalAccessException ignored) {
            }
            catch (InstantiationException ignored) {
            }
            catch (InvocationTargetException ignored) {
                // empty catch block
            }
        }
        if (event != null) {
            this.publishEvent(event);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("No event was found for the exception " + lastException.getClass().getName()));
        }
        throw lastException;
    }

    private void copyDetails(Authentication source, Authentication dest) {
        if (dest instanceof AbstractAuthenticationToken && dest.getDetails() == null) {
            AbstractAuthenticationToken token = (AbstractAuthenticationToken)dest;
            token.setDetails(source.getDetails());
        }
    }

    public List getProviders() {
        return this.providers;
    }

    public ConcurrentSessionController getSessionController() {
        return this.sessionController;
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setMessageSource(MessageSource messageSource) {
        this.messages = new MessageSourceAccessor(messageSource);
    }

    public void setProviders(List newList) {
        this.checkIfValidList(newList);
        Iterator iter = newList.iterator();
        while (iter.hasNext()) {
            Object currentObject = iter.next();
            Assert.isInstanceOf((Class)(class$org$acegisecurity$providers$AuthenticationProvider == null ? ProviderManager.class$("org.acegisecurity.providers.AuthenticationProvider") : class$org$acegisecurity$providers$AuthenticationProvider), currentObject, (String)"Can only provide AuthenticationProvider instances");
        }
        this.providers = newList;
    }

    public void setSessionController(ConcurrentSessionController sessionController) {
        this.sessionController = sessionController;
    }

    private void publishEvent(ApplicationEvent event) {
        if (this.applicationEventPublisher != null) {
            this.applicationEventPublisher.publishEvent(event);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        DEFAULT_EXCEPTION_MAPPINGS.put((class$org$acegisecurity$AccountExpiredException == null ? (class$org$acegisecurity$AccountExpiredException = ProviderManager.class$("org.acegisecurity.AccountExpiredException")) : class$org$acegisecurity$AccountExpiredException).getName(), (class$org$acegisecurity$event$authentication$AuthenticationFailureExpiredEvent == null ? (class$org$acegisecurity$event$authentication$AuthenticationFailureExpiredEvent = ProviderManager.class$("org.acegisecurity.event.authentication.AuthenticationFailureExpiredEvent")) : class$org$acegisecurity$event$authentication$AuthenticationFailureExpiredEvent).getName());
        DEFAULT_EXCEPTION_MAPPINGS.put((class$org$acegisecurity$AuthenticationServiceException == null ? (class$org$acegisecurity$AuthenticationServiceException = ProviderManager.class$("org.acegisecurity.AuthenticationServiceException")) : class$org$acegisecurity$AuthenticationServiceException).getName(), (class$org$acegisecurity$event$authentication$AuthenticationFailureServiceExceptionEvent == null ? (class$org$acegisecurity$event$authentication$AuthenticationFailureServiceExceptionEvent = ProviderManager.class$("org.acegisecurity.event.authentication.AuthenticationFailureServiceExceptionEvent")) : class$org$acegisecurity$event$authentication$AuthenticationFailureServiceExceptionEvent).getName());
        DEFAULT_EXCEPTION_MAPPINGS.put((class$org$acegisecurity$LockedException == null ? (class$org$acegisecurity$LockedException = ProviderManager.class$("org.acegisecurity.LockedException")) : class$org$acegisecurity$LockedException).getName(), (class$org$acegisecurity$event$authentication$AuthenticationFailureLockedEvent == null ? (class$org$acegisecurity$event$authentication$AuthenticationFailureLockedEvent = ProviderManager.class$("org.acegisecurity.event.authentication.AuthenticationFailureLockedEvent")) : class$org$acegisecurity$event$authentication$AuthenticationFailureLockedEvent).getName());
        DEFAULT_EXCEPTION_MAPPINGS.put((class$org$acegisecurity$CredentialsExpiredException == null ? (class$org$acegisecurity$CredentialsExpiredException = ProviderManager.class$("org.acegisecurity.CredentialsExpiredException")) : class$org$acegisecurity$CredentialsExpiredException).getName(), (class$org$acegisecurity$event$authentication$AuthenticationFailureCredentialsExpiredEvent == null ? (class$org$acegisecurity$event$authentication$AuthenticationFailureCredentialsExpiredEvent = ProviderManager.class$("org.acegisecurity.event.authentication.AuthenticationFailureCredentialsExpiredEvent")) : class$org$acegisecurity$event$authentication$AuthenticationFailureCredentialsExpiredEvent).getName());
        DEFAULT_EXCEPTION_MAPPINGS.put((class$org$acegisecurity$DisabledException == null ? (class$org$acegisecurity$DisabledException = ProviderManager.class$("org.acegisecurity.DisabledException")) : class$org$acegisecurity$DisabledException).getName(), (class$org$acegisecurity$event$authentication$AuthenticationFailureDisabledEvent == null ? (class$org$acegisecurity$event$authentication$AuthenticationFailureDisabledEvent = ProviderManager.class$("org.acegisecurity.event.authentication.AuthenticationFailureDisabledEvent")) : class$org$acegisecurity$event$authentication$AuthenticationFailureDisabledEvent).getName());
        DEFAULT_EXCEPTION_MAPPINGS.put((class$org$acegisecurity$BadCredentialsException == null ? (class$org$acegisecurity$BadCredentialsException = ProviderManager.class$("org.acegisecurity.BadCredentialsException")) : class$org$acegisecurity$BadCredentialsException).getName(), (class$org$acegisecurity$event$authentication$AuthenticationFailureBadCredentialsEvent == null ? (class$org$acegisecurity$event$authentication$AuthenticationFailureBadCredentialsEvent = ProviderManager.class$("org.acegisecurity.event.authentication.AuthenticationFailureBadCredentialsEvent")) : class$org$acegisecurity$event$authentication$AuthenticationFailureBadCredentialsEvent).getName());
        DEFAULT_EXCEPTION_MAPPINGS.put((class$org$acegisecurity$userdetails$UsernameNotFoundException == null ? (class$org$acegisecurity$userdetails$UsernameNotFoundException = ProviderManager.class$("org.acegisecurity.userdetails.UsernameNotFoundException")) : class$org$acegisecurity$userdetails$UsernameNotFoundException).getName(), (class$org$acegisecurity$event$authentication$AuthenticationFailureBadCredentialsEvent == null ? (class$org$acegisecurity$event$authentication$AuthenticationFailureBadCredentialsEvent = ProviderManager.class$("org.acegisecurity.event.authentication.AuthenticationFailureBadCredentialsEvent")) : class$org$acegisecurity$event$authentication$AuthenticationFailureBadCredentialsEvent).getName());
        DEFAULT_EXCEPTION_MAPPINGS.put((class$org$acegisecurity$concurrent$ConcurrentLoginException == null ? (class$org$acegisecurity$concurrent$ConcurrentLoginException = ProviderManager.class$("org.acegisecurity.concurrent.ConcurrentLoginException")) : class$org$acegisecurity$concurrent$ConcurrentLoginException).getName(), (class$org$acegisecurity$event$authentication$AuthenticationFailureConcurrentLoginEvent == null ? (class$org$acegisecurity$event$authentication$AuthenticationFailureConcurrentLoginEvent = ProviderManager.class$("org.acegisecurity.event.authentication.AuthenticationFailureConcurrentLoginEvent")) : class$org$acegisecurity$event$authentication$AuthenticationFailureConcurrentLoginEvent).getName());
        DEFAULT_EXCEPTION_MAPPINGS.put((class$org$acegisecurity$providers$ProviderNotFoundException == null ? (class$org$acegisecurity$providers$ProviderNotFoundException = ProviderManager.class$("org.acegisecurity.providers.ProviderNotFoundException")) : class$org$acegisecurity$providers$ProviderNotFoundException).getName(), (class$org$acegisecurity$event$authentication$AuthenticationFailureProviderNotFoundEvent == null ? (class$org$acegisecurity$event$authentication$AuthenticationFailureProviderNotFoundEvent = ProviderManager.class$("org.acegisecurity.event.authentication.AuthenticationFailureProviderNotFoundEvent")) : class$org$acegisecurity$event$authentication$AuthenticationFailureProviderNotFoundEvent).getName());
        DEFAULT_EXCEPTION_MAPPINGS.put((class$org$acegisecurity$providers$cas$ProxyUntrustedException == null ? (class$org$acegisecurity$providers$cas$ProxyUntrustedException = ProviderManager.class$("org.acegisecurity.providers.cas.ProxyUntrustedException")) : class$org$acegisecurity$providers$cas$ProxyUntrustedException).getName(), (class$org$acegisecurity$event$authentication$AuthenticationFailureProxyUntrustedEvent == null ? (class$org$acegisecurity$event$authentication$AuthenticationFailureProxyUntrustedEvent = ProviderManager.class$("org.acegisecurity.event.authentication.AuthenticationFailureProxyUntrustedEvent")) : class$org$acegisecurity$event$authentication$AuthenticationFailureProxyUntrustedEvent).getName());
    }
}

