/*
 * Decompiled with CFR 0.152.
 */
package net.sf.struts.saif;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.struts.saif.ActionHaveForwardInterceptor;
import net.sf.struts.saif.SAIFSpringPlugin;
import net.sf.struts.saif.config.ActionElement;
import net.sf.struts.saif.config.InterceptorConfig;
import net.sf.struts.saif.config.InterceptorElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionServlet;
import org.apache.struts.action.PlugIn;
import org.apache.struts.config.ModuleConfig;
import org.apache.struts.config.PlugInConfig;
import org.springframework.web.struts.DelegatingActionUtils;
import org.xml.sax.InputSource;

public class RequestProcessorSpringHelper {
    public static final String INTERCEPTOR_CONFIG_DEFAULT = "/WEB-INF/interceptor-config.xml";
    public static final String INTERCEPTOR_CONFIG_KEY = "interceptor-config";
    private InterceptorConfig interceptorCfg = null;
    private HashMap interceptorCache = new HashMap();
    private static final Log log;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("net.sf.struts.saif.RequestProcessorSpringHelper");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        log = LogFactory.getLog((Class)clazz);
    }

    public RequestProcessorSpringHelper(ActionServlet actionServlet, ModuleConfig moduleConfig) throws ServletException {
        Map props;
        String path;
        if (log.isDebugEnabled()) {
            log.debug((Object)"Reading interceptor configuration ...");
        }
        if ((path = (String)(props = this.findStrutsPlugInConfigProperties(actionServlet.getServletContext(), moduleConfig)).get(INTERCEPTOR_CONFIG_KEY)) == null) {
            path = INTERCEPTOR_CONFIG_DEFAULT;
        }
        try {
            URL url = actionServlet.getServletContext().getResource(path);
            InputSource is = new InputSource(url.toExternalForm());
            InputStream input = actionServlet.getServletContext().getResourceAsStream(path);
            is.setByteStream(input);
            this.interceptorCfg = InterceptorConfig.readConfig((InputSource)is);
        }
        catch (Exception ex) {
            log.error((Object)"Could not read interceptor configuration file");
            throw new ServletException(ex.getMessage());
        }
    }

    protected ActionForward beforeAction(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        List actionInterceptors = this.getActionInterceptors(action, mapping);
        ActionForward f = null;
        Iterator it = actionInterceptors.iterator();
        while (it.hasNext()) {
            ActionHaveForwardInterceptor actionIcp = (ActionHaveForwardInterceptor)it.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Applying interceptor [" + actionIcp + "] on action [" + action + "]"));
            }
            if ((f = actionIcp.beforeAction(action, mapping, form, request, response)) != null) break;
        }
        return f;
    }

    protected ActionForward afterAction(HttpServletRequest request, HttpServletResponse response, Action action, ActionForm form, ActionMapping mapping) throws IOException, ServletException {
        List actionInterceptors = this.getActionInterceptors(action, mapping);
        ActionForward f = null;
        Iterator it = actionInterceptors.iterator();
        while (it.hasNext()) {
            ActionHaveForwardInterceptor actionIcp = (ActionHaveForwardInterceptor)it.next();
            if (log.isDebugEnabled()) {
                log.debug((Object)("Applying interceptor [" + actionIcp + "] on action [" + action + "]"));
            }
            if ((f = actionIcp.afterAction(action, mapping, form, request, response)) != null) break;
        }
        return f;
    }

    private List getActionInterceptors(Action action) throws ServletException {
        LinkedList<ActionHaveForwardInterceptor> actionInterceptors = new LinkedList<ActionHaveForwardInterceptor>();
        List defaultInterceptors = this.interceptorCfg.getDefaultInterceptorElements();
        Iterator it = defaultInterceptors.iterator();
        while (it.hasNext()) {
            InterceptorElement interceptor = (InterceptorElement)it.next();
            actionInterceptors.add(this.getActionInterceptorInstance(interceptor));
        }
        ActionElement icpAction = this.interceptorCfg.getActionElement(action.getClass().getName());
        if (icpAction != null) {
            List interceptorNames = icpAction.getInterceptorNames();
            Iterator it2 = interceptorNames.iterator();
            while (it2.hasNext()) {
                String interceptorName = (String)it2.next();
                InterceptorElement interceptor = this.interceptorCfg.getInterceptorElement(interceptorName);
                if (interceptor != null) {
                    actionInterceptors.add(this.getActionInterceptorInstance(interceptor));
                    continue;
                }
                throw new ServletException("No interceptor with name " + interceptorName + " found!");
            }
        }
        return actionInterceptors;
    }

    private List getActionInterceptors(Action action, ActionMapping mapping) throws ServletException {
        LinkedList<ActionHaveForwardInterceptor> actionInterceptors = new LinkedList<ActionHaveForwardInterceptor>();
        List defaultInterceptors = this.interceptorCfg.getDefaultInterceptorElements();
        Iterator it = defaultInterceptors.iterator();
        while (it.hasNext()) {
            InterceptorElement interceptor = (InterceptorElement)it.next();
            actionInterceptors.add(this.getActionInterceptorInstance(interceptor));
        }
        String actionName = DelegatingActionUtils.determineActionBeanName((ActionMapping)mapping);
        ActionElement icpAction = this.interceptorCfg.getActionElement(actionName);
        if (icpAction != null) {
            List interceptorNames = icpAction.getInterceptorNames();
            Iterator it2 = interceptorNames.iterator();
            while (it2.hasNext()) {
                String interceptorName = (String)it2.next();
                InterceptorElement interceptor = this.interceptorCfg.getInterceptorElement(interceptorName);
                if (interceptor != null) {
                    actionInterceptors.add(this.getActionInterceptorInstance(interceptor));
                    continue;
                }
                throw new ServletException("No interceptor with name " + interceptorName + " found!");
            }
        }
        return actionInterceptors;
    }

    private ActionHaveForwardInterceptor getActionInterceptorInstance(InterceptorElement interceptor) throws ServletException {
        ActionHaveForwardInterceptor actionIcp = null;
        String type = interceptor.getType();
        if (this.interceptorCache.containsKey(type)) {
            return (ActionHaveForwardInterceptor)this.interceptorCache.get(type);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Creating new instance for interceptor of type: " + type));
        }
        try {
            Class<?> interceptorClass = Class.forName(type);
            actionIcp = (ActionHaveForwardInterceptor)interceptorClass.newInstance();
            this.interceptorCache.put(type, actionIcp);
        }
        catch (Exception ex) {
            log.error((Object)("Could not create interceptor instance of type: " + type));
            throw new ServletException("Failed to create interceptor of type " + type);
        }
        return actionIcp;
    }

    private Map findStrutsPlugInConfigProperties(ServletContext ctx, ModuleConfig config) throws ServletException {
        PlugIn[] plugIns = (PlugIn[])ctx.getAttribute("org.apache.struts.action.PLUG_INS" + config.getPrefix());
        int index = 0;
        while (index < plugIns.length && !(plugIns[index] instanceof SAIFSpringPlugin)) {
            ++index;
        }
        if (index == plugIns.length || !(plugIns[index] instanceof SAIFSpringPlugin)) {
            String msg = "Can't find saif definition in the config file.";
            log.error((Object)msg);
            throw new ServletException(msg);
        }
        PlugInConfig plugInConfig = config.findPlugInConfigs()[index];
        return plugInConfig.getProperties();
    }
}

