/*
 * Decompiled with CFR 0.152.
 */
package com.tombrus.cleanImports.model;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Pattern;

public class ImportSpecification {
    private List list = new ArrayList();

    public void addComment(String string) {
        this.list.add(new TextElement(string, null));
    }

    public void addText(String string) {
        this.list.add(new TextElement(null, string));
    }

    public void addText(String string, String string2) {
        this.list.add(new TextElement(string, string2));
    }

    public void addRegExp(String string) {
        this.list.add(new RegExpElement(null, null, string));
    }

    public void addRegExp(String string, String string2) {
        this.list.add(new RegExpElement(string, null, string2));
    }

    public void addRegExp(String string, String string2, String string3) {
        this.list.add(new RegExpElement(string, string2, string3));
    }

    public void addRegExp(Pattern pattern) {
        this.addRegExp(null, null, pattern);
    }

    public void addRegExp(String string, Pattern pattern) {
        this.addRegExp(string, null, pattern);
    }

    public void addRegExp(String string, String string2, Pattern pattern) {
        this.list.add(new RegExpElement(string, string2, pattern));
    }

    public void addPackage(String string) {
        this.addPackage(null, null, string);
    }

    public void addPackage(String string, String string2) {
        this.addPackage(string, null, string2);
    }

    public void addPackage(String string, String string2, String string3) {
        this.list.add(new RegExpElement(string, string2, "^\\Q" + string3 + "\\E\\..*"));
    }

    public void addRest() {
        this.addRest(null, null);
    }

    public void addRest(String string) {
        this.addRest(string, null);
    }

    public void addRest(String string, String string2) {
        this.list.add(new RestElement(string, string2));
    }

    public void addOwn(boolean bl) {
        this.addOwn(null, null, bl);
    }

    public void addOwn(String string, boolean bl) {
        this.addOwn(string, null, bl);
    }

    public void addOwn(String string, String string2, boolean bl) {
        this.list.add(new OwnElement(string, string2, bl));
    }

    public void addJavaLang(boolean bl) {
        this.addJavaLang(null, null, bl);
    }

    public void addJavaLang(String string, boolean bl) {
        this.addJavaLang(string, null, bl);
    }

    public void addJavaLang(String string, String string2, boolean bl) {
        this.list.add(new JavaLangElement(string, string2, bl));
    }

    public void addCollapseAbove(int n) {
        this.list.add(new CollapseAboveElement(n));
    }

    public void addPostBlanks(int n) {
        this.list.add(new PostBlanksElement(n));
    }

    public void addAmbiguities(boolean bl) {
        this.list.add(new Ambiguities(bl));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("ImportSpecification:");
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(" == ").append(iterator.next().toString()).append("\n");
        }
        return stringBuffer.toString();
    }

    public void accept(Visitor visitor) {
        visitor.begin();
        Iterator iterator = this.list.iterator();
        while (iterator.hasNext()) {
            ((SpecificationElement)iterator.next()).accept(visitor);
        }
        visitor.end();
    }

    public static interface Visitor {
        public void begin();

        public void text(String var1);

        public void regExp(String var1, Pattern var2);

        public void javaLang(String var1, boolean var2);

        public void own(String var1, boolean var2);

        public void rest(String var1);

        public void collapseAbove(int var1);

        public void postBlanks(int var1);

        public void ambiguities(boolean var1);

        public void end();

        public String getEOL();
    }

    public static class Ambiguities
    extends SpecificationElement {
        private boolean ambiguities;

        protected Ambiguities(boolean bl) {
            this.ambiguities = bl;
        }

        public void accept(Visitor visitor) {
            visitor.ambiguities(this.ambiguities);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("AmbiguitySwitch:[");
            stringBuffer.append("ambiguities='").append(this.ambiguities).append("'").append("]");
            return stringBuffer.toString();
        }
    }

    public static class PostBlanksElement
    extends SpecificationElement {
        private int numberOfLines;

        protected PostBlanksElement(int n) {
            this.numberOfLines = n;
        }

        public void accept(Visitor visitor) {
            visitor.postBlanks(this.numberOfLines);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("PostBlankElement:[");
            stringBuffer.append("numberOfLines='").append(this.numberOfLines).append("'").append("]");
            return stringBuffer.toString();
        }
    }

    public static class CollapseAboveElement
    extends SpecificationElement {
        private int above;

        protected CollapseAboveElement(int n) {
            this.above = n;
        }

        public void accept(Visitor visitor) {
            visitor.collapseAbove(this.above);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("CollapseAboveElement:[");
            stringBuffer.append("above='").append(this.above).append("'").append("]");
            return stringBuffer.toString();
        }
    }

    public static class JavaLangElement
    extends TextElement {
        private boolean asComment;

        protected JavaLangElement(String string, String string2, boolean bl) {
            super(string, string2);
            this.asComment = bl;
        }

        public void accept(Visitor visitor) {
            visitor.javaLang(this.getText(visitor), this.asComment);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("JavaLangElement:[");
            stringBuffer.append("asComment='").append(this.asComment).append("' ");
            stringBuffer.append(super.toString()).append("]");
            return stringBuffer.toString();
        }
    }

    public static class OwnElement
    extends TextElement {
        private boolean asComment;

        protected OwnElement(String string, String string2, boolean bl) {
            super(string, string2);
            this.asComment = bl;
        }

        public void accept(Visitor visitor) {
            visitor.own(this.getText(visitor), this.asComment);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("OwnElement:[");
            stringBuffer.append("asComment='").append(this.asComment).append("' ");
            stringBuffer.append(super.toString()).append("]");
            return stringBuffer.toString();
        }
    }

    public static class RestElement
    extends TextElement {
        protected RestElement(String string, String string2) {
            super(string, string2);
        }

        public void accept(Visitor visitor) {
            visitor.rest(this.getText(visitor));
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("RestElement:[");
            stringBuffer.append(super.toString()).append("]");
            return stringBuffer.toString();
        }
    }

    public static class RegExpElement
    extends TextElement {
        private Pattern regExp;

        protected RegExpElement(String string, String string2, String string3) {
            this(string, string2, Pattern.compile(string3));
        }

        protected RegExpElement(String string, String string2, Pattern pattern) {
            super(string, string2);
            this.regExp = pattern;
        }

        public void accept(Visitor visitor) {
            visitor.regExp(this.getText(visitor), this.regExp);
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("RegExpElement:[");
            stringBuffer.append("regExp='").append(this.regExp.pattern()).append("' ");
            stringBuffer.append(super.toString()).append("]");
            return stringBuffer.toString();
        }
    }

    public static class TextElement
    extends SpecificationElement {
        private String comment;
        private String text;

        protected TextElement(String string, String string2) {
            this.comment = string;
            this.text = string2;
        }

        public void accept(Visitor visitor) {
            visitor.text(this.getText(visitor));
        }

        public String getText(Visitor visitor) {
            String string = null;
            if (this.comment != null || this.text != null) {
                StringBuffer stringBuffer = new StringBuffer();
                if (this.comment != null) {
                    stringBuffer.append("// ").append(this.comment);
                    if (this.text != null) {
                        stringBuffer.append(visitor.getEOL());
                    }
                }
                if (this.text != null) {
                    stringBuffer.append(this.text);
                }
                string = stringBuffer.toString();
            }
            return string;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer("TextElement:[");
            stringBuffer.append("comment='").append(this.comment).append("' text='").append(this.text).append("'");
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
    }

    public static abstract class SpecificationElement {
        public abstract void accept(Visitor var1);
    }
}

